/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.controlflow;

import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.ControlFlowBuilder;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.controlflow.TransparentInstruction;
import com.intellij.codeInsight.controlflow.impl.DetachedInstructionImpl;
import com.intellij.codeInsight.controlflow.impl.InstructionImpl;
import com.intellij.codeInsight.controlflow.impl.TransparentInstructionImpl;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.actionscript.psi.impl.ActionScriptVariableImpl;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSConditionOwner;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLabeledStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLocalVariable;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSThenableElement;
import com.intellij.lang.javascript.psi.JSThrowExpression;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.lang.javascript.psi.JSYieldExpression;
import com.intellij.lang.javascript.psi.controlflow.JSControlFlowService;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSArrayModificationInstruction;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSBranchInstruction;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSCallInstruction;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSCaseBlockEndInstruction;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSCaseBlockInstruction;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSCatchEntryInstruction;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSCloseInstruction;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSConditionInstruction;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSEntryPointInstruction;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSFinallyEndInstruction;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSFinallyEntryInstruction;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSIndexedModificationInstruction;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSLoopJunctionInstruction;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSReadWriteInstruction;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.impl.JSXXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.types.guard.JSControlFlowTypeGuard;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.lang.javascript.psi.util.ExpressionUtil;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class JSControlFlowBuilder
extends JSRecursiveElementVisitor {
    @NotNull
    private final ControlFlowBuilder myBuilder;
    @NotNull
    private final Stack<ConditionFlow> myConditionTargets;
    @NotNull
    private final Deque<TryPartFlow> myTryTargets;
    @NotNull
    private final Map<PsiElement, BreakContinueFlow> myJumpTargets;

    public JSControlFlowBuilder(@NotNull JSElement scope) {
        if (scope == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(0);
        }
        this.myBuilder = new ControlFlowBuilder(){

            protected void addEntryPointNode(PsiElement startElement) {
                assert (startElement instanceof JSElement && JSControlFlowService.isControlFlowScope(startElement));
                JSEntryPointInstruction entryPointInstruction = new JSEntryPointInstruction(this, null, (JSElement)startElement);
                this.addNodeAndCheckPending((Instruction)entryPointInstruction);
            }
        };
        this.myConditionTargets = new Stack();
        this.myTryTargets = new ArrayDeque<TryPartFlow>();
        this.myJumpTargets = new HashMap<PsiElement, BreakContinueFlow>();
        this.myBuilder.visitFor((PsiElementVisitor)this, (PsiElement)scope);
        assert (this.myConditionTargets.isEmpty());
        assert (this.myTryTargets.isEmpty());
        assert (this.myJumpTargets.isEmpty());
    }

    @NotNull
    public ControlFlow getControlFlow() {
        ControlFlow controlFlow = this.myBuilder.getCompleteControlFlow();
        if (controlFlow == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(1);
        }
        return controlFlow;
    }

    @TestOnly
    @NotNull
    public ControlFlowBuilder getControlFlowBuilder() {
        ControlFlowBuilder controlFlowBuilder = this.myBuilder;
        if (controlFlowBuilder == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(2);
        }
        return controlFlowBuilder;
    }

    private void pushConditionTargets(@NotNull Instruction trueTarget, @NotNull Instruction falseTarget) {
        if (trueTarget == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(3);
        }
        if (falseTarget == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(4);
        }
        this.myConditionTargets.push((Object)new ConditionFlow(trueTarget, falseTarget));
    }

    private void popConditionTargets() {
        assert (!this.myConditionTargets.isEmpty());
        this.myConditionTargets.pop();
    }

    private void pushBreakContinueFlow(@NotNull PsiElement breakContinueTarget, @Nullable Instruction continueInstruction, @NotNull Instruction endInstruction) {
        if (breakContinueTarget == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(5);
        }
        if (endInstruction == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(6);
        }
        this.myJumpTargets.put(breakContinueTarget, new BreakContinueFlow(continueInstruction, endInstruction));
    }

    private void popBreakContinueFlow(@NotNull PsiElement breakContinueTarget) {
        if (breakContinueTarget == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(7);
        }
        this.myJumpTargets.remove(breakContinueTarget);
    }

    private void jump(@NotNull Instruction toInstruction) {
        Instruction prev;
        if (toInstruction == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(8);
        }
        if ((prev = this.myBuilder.prevInstruction) != null) {
            this.myBuilder.addEdge(prev, toInstruction);
        }
        this.myBuilder.checkPending(toInstruction);
        this.myBuilder.flowAbrupted();
    }

    @Override
    public void visitJSParameterList(JSParameterList node) {
        this.myBuilder.startNode((PsiElement)node);
        super.visitJSParameterList(node);
    }

    @Override
    public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
        if (node == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(9);
        }
        this.myBuilder.startNode((PsiElement)node);
    }

    @Override
    public void visitTypeScriptFunctionSignature(TypeScriptFunctionSignature functionSignature) {
        this.visitJSFunctionDeclaration(functionSignature);
    }

    @Override
    public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
        if (node == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(10);
        }
        InstructionImpl functionDeclaration = new InstructionImpl(this.myBuilder, (PsiElement)node);
        this.myBuilder.instructions.add(functionDeclaration);
        this.myBuilder.addEdge((Instruction)this.myBuilder.instructions.get(0), (Instruction)functionDeclaration);
    }

    @Override
    public void visitJSLiteralExpression(JSLiteralExpression node) {
        super.visitJSLiteralExpression(node);
        if (!(node instanceof JSXXmlLiteralExpressionImpl)) {
            return;
        }
        String name = node.getName();
        JSReadWriteInstruction jsxTagInstruction = new JSReadWriteInstruction(this.myBuilder, (PsiElement)node, ReadWriteAccessDetector.Access.Read, name);
        this.myBuilder.addNodeAndCheckPending((Instruction)jsxTagInstruction);
    }

    @Override
    public void visitJSClass(@NotNull JSClass aClass) {
        JSReferenceList implementsList;
        if (aClass == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(11);
        }
        this.myBuilder.startNode((PsiElement)aClass);
        JSReferenceList extendsList = aClass.getExtendsList();
        if (extendsList != null) {
            extendsList.accept(this);
        }
        if ((implementsList = aClass.getImplementsList()) != null) {
            implementsList.accept(this);
        }
        this.myBuilder.addNodeAndCheckPending((Instruction)new JSCloseInstruction(this.myBuilder, aClass));
    }

    @Override
    public void visitTypeScriptModule(@NotNull TypeScriptModule module) {
        if (module == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(12);
        }
        this.myBuilder.startNode((PsiElement)module);
    }

    @Override
    public void visitJSIfStatement(@NotNull JSIfStatement node) {
        if (node == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(13);
        }
        this.myBuilder.startNode((PsiElement)node);
        this.processThenable(node, JSBranchInstruction.BranchOwner.IF);
    }

    @Override
    public void visitJSConditionalExpression(@NotNull JSConditionalExpression node) {
        if (node == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(14);
        }
        this.myBuilder.startNode((PsiElement)node);
        this.processThenable(node, JSBranchInstruction.BranchOwner.CONDITIONAL_EXPRESSION);
    }

    private <T extends JSElement> void processThenable(@NotNull JSThenableElement<T> node, JSBranchInstruction.BranchOwner owner) {
        if (node == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(15);
        }
        this.processBranching((PsiElement)node, node.getCondition(), (PsiElement)node.getThen(), (PsiElement)node.getElse(), owner);
    }

    private void processBranching(@NotNull PsiElement owner, @Nullable JSExpression condition, @Nullable PsiElement thenBranch, @Nullable PsiElement elseBranch, @NotNull JSBranchInstruction.BranchOwner branchOwner) {
        if (owner == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(16);
        }
        if (branchOwner == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(17);
        }
        JSConditionInstruction.ConditionState state2 = JSControlFlowBuilder.evaluateCondition(condition);
        JSBranchInstruction ifThen = new JSBranchInstruction(owner, branchOwner, true, state2);
        JSBranchInstruction ifElse = new JSBranchInstruction(owner, branchOwner, false, state2);
        this.processCondition(condition, (Instruction)ifThen, (Instruction)ifElse);
        this.myBuilder.prevInstruction = ifThen;
        ifThen.addToInstructions(this.myBuilder);
        if (thenBranch != null) {
            thenBranch.accept((PsiElementVisitor)this);
            this.reapplyPendingScopesAndUpdateNeverAvailable(owner, thenBranch, state2 == JSConditionInstruction.ConditionState.CONDITION_ALWAYS_FALSE);
        }
        this.myBuilder.addPendingEdge(owner, this.myBuilder.prevInstruction);
        ifElse.addToInstructions(this.myBuilder);
        this.myBuilder.prevInstruction = ifElse;
        if (elseBranch != null) {
            elseBranch.accept((PsiElementVisitor)this);
            this.reapplyPendingScopesAndUpdateNeverAvailable(owner, elseBranch, state2 == JSConditionInstruction.ConditionState.CONDITION_ALWAYS_TRUE);
        } else {
            this.myBuilder.addPendingEdge(owner, (Instruction)ifElse);
        }
    }

    private void reapplyPendingScopesAndUpdateNeverAvailable(@NotNull PsiElement owner, @NotNull PsiElement branch, boolean isNeverAvailable) {
        Instruction prev;
        if (owner == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(18);
        }
        if (branch == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(19);
        }
        this.myBuilder.updatePendingElementScope(branch, isNeverAvailable ? null : owner);
        if (isNeverAvailable && (prev = this.myBuilder.prevInstruction) != null) {
            this.myBuilder.flowAbrupted();
            PsiElement element = prev.getElement();
            if (element != null && prev.allSucc().isEmpty() && PsiTreeUtil.isAncestor((PsiElement)branch, (PsiElement)element, (boolean)false)) {
                this.myBuilder.addPendingEdge(null, prev);
            }
        }
    }

    @Override
    public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
        JSExpression qualifier;
        if (node == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(20);
        }
        if ((qualifier = node.getQualifier()) == null || JSTypeGuardChecker.isNarrowableReference(node)) {
            PsiElement parent = JSUtils.getParentSkipParentheses((PsiElement)node);
            if ((parent instanceof ActionScriptVariableImpl || parent instanceof JSLocalVariable) && ((JSVariable)parent).getNameIdentifier() == node) {
                return;
            }
            String name = node.getReferenceName();
            if (parent instanceof JSDefinitionExpression) {
                PsiElement forInCandidate = parent.getParent();
                if (JSControlFlowBuilder.isForEachVariableExpression(parent, forInCandidate)) {
                    Instruction instruction = this.writeAccess(parent, name);
                    this.myBuilder.addNodeAndCheckPending(instruction);
                }
            } else {
                if (qualifier != null) {
                    super.visitJSReferenceExpression(node);
                }
                if (name != null) {
                    Instruction instruction = this.getReferenceExpressionInstruction(node, parent, name);
                    this.myBuilder.addNodeAndCheckPending(instruction);
                }
                return;
            }
        }
        super.visitJSReferenceExpression(node);
    }

    @NotNull
    private Instruction getReferenceExpressionInstruction(@NotNull JSReferenceExpression node, @Nullable PsiElement parent, @NotNull String name) {
        JSExpression source2;
        if (node == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(21);
        }
        if (name == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(22);
        }
        if ((source2 = JSDestructuringUtil.getDestructuringAssignmentSource(node)) != null) {
            Instruction instruction = this.writeAccess((PsiElement)node, name);
            if (instruction == null) {
                JSControlFlowBuilder.$$$reportNull$$$0(23);
            }
            return instruction;
        }
        Instruction instruction = JSControlFlowBuilder.isForEachVariableExpression((PsiElement)node, parent) ? this.writeAccess(parent, name) : this.readAccess((PsiElement)node, name);
        if (instruction == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(24);
        }
        return instruction;
    }

    public static boolean isForEachVariableExpression(@NotNull PsiElement node, @Nullable PsiElement parent) {
        if (node == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(25);
        }
        return parent instanceof JSForInStatement && JSUtils.unparenthesize(((JSForInStatement)parent).getVariableExpression()) == node;
    }

    @Override
    public void visitJSStatement(JSStatement node) {
        this.addNode((PsiElement)node);
        super.visitJSStatement(node);
    }

    @Override
    public void visitJSPrefixExpression(JSPrefixExpression node) {
        JSExpression expression;
        IElementType sign = node.getOperationSign();
        if (sign == JSTokenTypes.EXCL && !this.myConditionTargets.isEmpty()) {
            ConditionFlow flow = (ConditionFlow)this.myConditionTargets.peek();
            this.pushConditionTargets(flow.myFalseInstruction, flow.myTrueInstruction);
            super.visitJSPrefixExpression(node);
            this.popConditionTargets();
            return;
        }
        super.visitJSPrefixExpression(node);
        if ((sign == JSTokenTypes.PLUSPLUS || sign == JSTokenTypes.MINUSMINUS) && (expression = node.getExpression()) instanceof JSReferenceExpression && JSTypeGuardChecker.isNarrowableReference(expression)) {
            this.myBuilder.addNodeAndCheckPending(this.readWriteAccess((PsiElement)node, ((JSReferenceExpression)expression).getReferenceName()));
        }
    }

    @Override
    public void visitJSLabeledStatement(JSLabeledStatement node) {
        JSStatement statement = node.getStatement();
        if (statement == null) {
            return;
        }
        if (statement instanceof JSLoopStatement || statement instanceof JSSwitchStatement) {
            super.visitJSLabeledStatement(node);
            return;
        }
        TransparentInstructionImpl loopOutInstruction = new TransparentInstructionImpl(this.myBuilder, (PsiElement)node, "labeled-out");
        this.pushBreakContinueFlow((PsiElement)statement, null, (Instruction)loopOutInstruction);
        statement.accept(this);
        this.popBreakContinueFlow((PsiElement)statement);
        this.myBuilder.addNodeAndCheckPending((Instruction)loopOutInstruction);
    }

    @Override
    public void visitJSPostfixExpression(JSPostfixExpression node) {
        JSExpression expression;
        super.visitJSPostfixExpression(node);
        IElementType sign = node.getOperationSign();
        if ((sign == JSTokenTypes.PLUSPLUS || sign == JSTokenTypes.MINUSMINUS) && (expression = node.getExpression()) instanceof JSReferenceExpression && JSTypeGuardChecker.isNarrowableReference(expression)) {
            this.myBuilder.addNodeAndCheckPending(this.readWriteAccess((PsiElement)node, ((JSReferenceExpression)expression).getReferenceName()));
        }
    }

    @Override
    public void visitJSBinaryExpression(@NotNull JSBinaryExpression node) {
        boolean isAndAnd;
        if (node == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(26);
        }
        IElementType sign = node.getOperationSign();
        JSExpression lOperand = node.getLOperand();
        JSExpression rOperand = node.getROperand();
        boolean isOrOr = sign == JSTokenTypes.OROR || sign == JSTokenTypes.QUEST_QUEST;
        boolean bl = isAndAnd = sign == JSTokenTypes.ANDAND;
        if (isOrOr || isAndAnd) {
            if (JSControlFlowBuilder.isTopLevelBinaryExpression(node)) {
                DetachedInstructionImpl exitCondition = new DetachedInstructionImpl((PsiElement)node);
                this.processLogicalExpression(node, (Instruction)exitCondition, (Instruction)exitCondition, isAndAnd);
                exitCondition.addToInstructions(this.myBuilder);
                this.myBuilder.prevInstruction = exitCondition;
            } else {
                ConditionFlow elements = (ConditionFlow)this.myConditionTargets.peek();
                Instruction trueTarget = elements.myTrueInstruction;
                Instruction falseTarget = elements.myFalseInstruction;
                this.processLogicalExpression(node, trueTarget, falseTarget, isAndAnd);
            }
        } else {
            if (lOperand != null) {
                lOperand.accept(this);
            }
            if (rOperand != null) {
                rOperand.accept(this);
            }
        }
    }

    private void processLogicalExpression(@NotNull JSBinaryExpression expression, @NotNull Instruction trueTarget, @NotNull Instruction falseTarget, boolean isAndAnd) {
        JSBranchInstruction branch;
        if (expression == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(27);
        }
        if (trueTarget == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(28);
        }
        if (falseTarget == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(29);
        }
        JSExpression left = expression.getLOperand();
        if (isAndAnd) {
            branch = new JSBranchInstruction((PsiElement)expression, JSBranchInstruction.BranchOwner.LOGICAL_EXPRESSION, true, JSConditionInstruction.ConditionState.UNKNOWN);
            this.processCondition(left, (Instruction)branch, falseTarget);
        } else {
            branch = new JSBranchInstruction((PsiElement)expression, JSBranchInstruction.BranchOwner.LOGICAL_EXPRESSION, false, JSConditionInstruction.ConditionState.UNKNOWN);
            this.processCondition(left, trueTarget, (Instruction)branch);
        }
        branch.addToInstructions(this.myBuilder);
        this.myBuilder.prevInstruction = branch;
        this.processCondition(expression.getROperand(), trueTarget, falseTarget);
    }

    public void connectPendingToNodes(@NotNull PsiElement scope, @NotNull Instruction firstNode, @NotNull Instruction secondNode) {
        if (scope == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(30);
        }
        if (firstNode == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(31);
        }
        if (secondNode == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(32);
        }
        this.myBuilder.processPending((pendingScope, pendingInstruction) -> {
            if (pendingScope != null && PsiTreeUtil.isAncestor((PsiElement)scope, (PsiElement)pendingScope, (boolean)false)) {
                this.myBuilder.addEdge(pendingInstruction, firstNode);
                this.myBuilder.addEdge(pendingInstruction, secondNode);
            } else {
                this.myBuilder.addPendingEdge(pendingScope, pendingInstruction);
            }
        });
    }

    private void processCondition(@Nullable JSExpression expression, @NotNull Instruction trueTarget, @NotNull Instruction falseTarget) {
        if (trueTarget == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(33);
        }
        if (falseTarget == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(34);
        }
        this.pushConditionTargets(trueTarget, falseTarget);
        if (expression != null) {
            expression.accept(this);
        }
        this.popConditionTargets();
        if (expression == null) {
            Instruction prevInstruction = this.myBuilder.prevInstruction;
            if (prevInstruction != null) {
                this.myBuilder.addEdge(prevInstruction, trueTarget);
            }
            this.myBuilder.checkPending(trueTarget);
            return;
        }
        if (!JSControlFlowBuilder.isLogicalExpression((PsiElement)expression)) {
            Object value;
            Object object = value = expression instanceof JSLiteralExpression || expression instanceof JSBinaryExpression ? ExpressionUtil.computeConstantExpression(expression) : null;
            JSConditionInstruction.ConditionState state2 = value instanceof Boolean ? (((Boolean)value).booleanValue() ? JSConditionInstruction.ConditionState.CONDITION_ALWAYS_TRUE : JSConditionInstruction.ConditionState.CONDITION_ALWAYS_FALSE) : JSConditionInstruction.ConditionState.UNKNOWN;
            JSConditionInstruction trueCondition = new JSConditionInstruction((PsiElement)expression, true, state2);
            JSConditionInstruction falseCondition = new JSConditionInstruction((PsiElement)expression, false, state2);
            this.connectPendingToNodes((PsiElement)expression, (Instruction)trueCondition, (Instruction)falseCondition);
            Instruction prevInstruction = this.myBuilder.prevInstruction;
            if (prevInstruction != null) {
                this.myBuilder.addEdge(prevInstruction, (Instruction)trueCondition);
                this.myBuilder.addEdge(prevInstruction, (Instruction)falseCondition);
            }
            trueCondition.addToInstructions(this.myBuilder);
            falseCondition.addToInstructions(this.myBuilder);
            this.myBuilder.addEdge((Instruction)trueCondition, trueTarget);
            this.myBuilder.addEdge((Instruction)falseCondition, falseTarget);
        }
    }

    private static boolean isTopLevelBinaryExpression(@NotNull JSExpression expression) {
        if (expression == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(35);
        }
        PsiElement parent = expression.getParent();
        JSExpression currentExpression = expression;
        while (parent instanceof JSParenthesizedExpression || JSControlFlowBuilder.isExclExpression(parent)) {
            currentExpression = parent;
            parent = parent.getParent();
        }
        return !JSControlFlowBuilder.isStatementCondition(parent, (PsiElement)currentExpression) && !JSControlFlowBuilder.isLogicalExpression(parent);
    }

    private static boolean isStatementCondition(@Nullable PsiElement parent, @Nullable PsiElement currentElement) {
        if (parent == null) {
            return false;
        }
        JSExpression parentCondition = null;
        if (parent instanceof JSConditionOwner) {
            parentCondition = ((JSConditionOwner)parent).getCondition();
        }
        return parentCondition == currentElement;
    }

    private static boolean isLogicalExpression(@NotNull PsiElement expression) {
        if (expression == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(36);
        }
        while (expression != null) {
            if (expression instanceof JSParenthesizedExpression) {
                expression = ((JSParenthesizedExpression)expression).getInnerExpression();
                continue;
            }
            boolean exclExpression = JSControlFlowBuilder.isExclExpression(expression);
            if (exclExpression) {
                expression = ((JSPrefixExpression)expression).getExpression();
                continue;
            }
            if (!(expression instanceof JSBinaryExpression)) {
                return false;
            }
            JSBinaryExpression binaryExpression = (JSBinaryExpression)expression;
            IElementType sign = binaryExpression.getOperationSign();
            return sign == JSTokenTypes.OROR || sign == JSTokenTypes.QUEST_QUEST || sign == JSTokenTypes.ANDAND;
        }
        return false;
    }

    private static boolean isExclExpression(@NotNull PsiElement expression) {
        if (expression == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(37);
        }
        return expression instanceof JSPrefixExpression && ((JSPrefixExpression)expression).getOperationSign() == JSTokenTypes.EXCL;
    }

    @Override
    public void visitJSVariable(JSVariable node) {
        super.visitJSVariable(node);
        String variableName = node.getName();
        if (variableName != null) {
            Instruction instruction = this.writeAccess((PsiElement)node, variableName);
            this.myBuilder.addNodeAndCheckPending(instruction);
        }
    }

    @Override
    public void visitJSTypeDeclaration(JSTypeDeclaration type) {
    }

    @Override
    public void visitJSForStatement(@NotNull JSForStatement forStatement) {
        if (forStatement == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(38);
        }
        this.myBuilder.startNode((PsiElement)forStatement);
        JSExpression initialization = forStatement.getInitialization();
        JSVarStatement varDeclaration = forStatement.getVarDeclaration();
        if (initialization != null) {
            initialization.accept(this);
        } else if (varDeclaration != null) {
            varDeclaration.accept(this);
        }
        JSExpression condition = forStatement.getCondition();
        JSConditionInstruction.ConditionState state2 = JSControlFlowBuilder.evaluateCondition(condition);
        JSLoopJunctionInstruction loopBeginInstruction = new JSLoopJunctionInstruction((PsiElement)forStatement);
        TransparentInstructionImpl loopContinueInstruction = new TransparentInstructionImpl(this.myBuilder, (PsiElement)forStatement, "for-continue");
        TransparentInstructionImpl loopOutInstruction = new TransparentInstructionImpl(this.myBuilder, (PsiElement)forStatement, "for-out");
        this.pushBreakContinueFlow((PsiElement)forStatement, (Instruction)loopContinueInstruction, (Instruction)loopOutInstruction);
        loopBeginInstruction.addNodeAndMarkRegularPred(this.myBuilder);
        JSBranchInstruction conditionTrue = new JSBranchInstruction((PsiElement)forStatement, JSBranchInstruction.BranchOwner.FOR, true, state2);
        JSBranchInstruction conditionFalse = null;
        if (condition != null) {
            conditionFalse = new JSBranchInstruction((PsiElement)forStatement, JSBranchInstruction.BranchOwner.FOR, false, state2);
            this.processCondition(condition, (Instruction)conditionTrue, (Instruction)conditionFalse);
            this.myBuilder.prevInstruction = conditionTrue;
            conditionTrue.addToInstructions(this.myBuilder);
        } else {
            conditionTrue.addNode(this.myBuilder);
        }
        JSStatement body = forStatement.getBody();
        if (body != null) {
            body.accept(this);
        }
        this.popBreakContinueFlow((PsiElement)forStatement);
        this.myBuilder.addNodeAndCheckPending((Instruction)loopContinueInstruction);
        JSExpression update2 = forStatement.getUpdate();
        if (update2 != null) {
            update2.accept(this);
        }
        this.jump((Instruction)loopBeginInstruction);
        if (conditionFalse != null) {
            this.myBuilder.prevInstruction = conditionFalse;
            conditionFalse.addToInstructions(this.myBuilder);
        }
        this.myBuilder.addNodeAndCheckPending((Instruction)loopOutInstruction);
    }

    @Override
    public void visitJSForInStatement(@NotNull JSForInStatement forInStatement) {
        if (forInStatement == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(39);
        }
        this.myBuilder.startNode((PsiElement)forInStatement);
        JSLoopJunctionInstruction loopStartInstruction = new JSLoopJunctionInstruction((PsiElement)forInStatement);
        TransparentInstructionImpl loopOutInstruction = new TransparentInstructionImpl(this.myBuilder, (PsiElement)forInStatement, "for-of(in)-exit-point");
        this.pushBreakContinueFlow((PsiElement)forInStatement, (Instruction)loopStartInstruction, (Instruction)loopOutInstruction);
        JSExpression expression = forInStatement.getCollectionExpression();
        if (expression != null) {
            expression.accept(this);
        }
        loopStartInstruction.addNodeAndMarkRegularPred(this.myBuilder);
        this.jump((Instruction)loopOutInstruction);
        this.myBuilder.prevInstruction = loopStartInstruction;
        JSVarStatement statement = forInStatement.getVarDeclaration();
        if (statement != null) {
            statement.accept(this);
        } else {
            JSExpression variableExpression = forInStatement.getVariableExpression();
            if (variableExpression != null) {
                variableExpression.accept(this);
            }
        }
        JSStatement body = forInStatement.getBody();
        if (body != null) {
            body.accept(this);
        }
        this.jump((Instruction)loopStartInstruction);
        this.myBuilder.addNodeAndCheckPending((Instruction)loopOutInstruction);
        this.popBreakContinueFlow((PsiElement)forInStatement);
    }

    @Override
    public void visitJSWhileStatement(@NotNull JSWhileStatement whileStatement) {
        if (whileStatement == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(40);
        }
        JSLoopJunctionInstruction loopStartInstruction = new JSLoopJunctionInstruction((PsiElement)whileStatement);
        loopStartInstruction.addNodeAndMarkRegularPred(this.myBuilder);
        TransparentInstructionImpl loopOutInstruction = new TransparentInstructionImpl(this.myBuilder, (PsiElement)whileStatement, "while-exit-point");
        this.pushBreakContinueFlow((PsiElement)whileStatement, (Instruction)loopStartInstruction, (Instruction)loopOutInstruction);
        JSExpression condition = whileStatement.getCondition();
        JSConditionInstruction.ConditionState state2 = JSControlFlowBuilder.evaluateCondition(condition);
        JSBranchInstruction conditionTrue = new JSBranchInstruction((PsiElement)whileStatement, JSBranchInstruction.BranchOwner.WHILE, true, state2);
        JSBranchInstruction conditionFalse = new JSBranchInstruction((PsiElement)whileStatement, JSBranchInstruction.BranchOwner.WHILE, false, state2);
        this.processCondition(condition, (Instruction)conditionTrue, (Instruction)conditionFalse);
        conditionTrue.addToInstructions(this.myBuilder);
        this.myBuilder.prevInstruction = conditionTrue;
        JSStatement body = whileStatement.getBody();
        if (body != null) {
            body.accept(this);
        }
        this.jump((Instruction)loopStartInstruction);
        conditionFalse.addToInstructions(this.myBuilder);
        this.myBuilder.prevInstruction = conditionFalse;
        this.myBuilder.addNodeAndCheckPending((Instruction)loopOutInstruction);
        this.popBreakContinueFlow((PsiElement)whileStatement);
    }

    @Override
    public void visitJSDoWhileStatement(JSDoWhileStatement whileStatement) {
        JSLoopJunctionInstruction junction = new JSLoopJunctionInstruction((PsiElement)whileStatement);
        junction.addNodeAndMarkRegularPred(this.myBuilder);
        TransparentInstructionImpl continueInstruction = new TransparentInstructionImpl(this.myBuilder, (PsiElement)whileStatement, "continue-before-condition");
        TransparentInstructionImpl loopOutInstruction = new TransparentInstructionImpl(this.myBuilder, (PsiElement)whileStatement, "do-while-exit-point");
        this.pushBreakContinueFlow((PsiElement)whileStatement, (Instruction)continueInstruction, (Instruction)loopOutInstruction);
        JSStatement body = whileStatement.getBody();
        if (body != null) {
            body.accept(this);
        }
        this.myBuilder.addNodeAndCheckPending((Instruction)continueInstruction);
        JSExpression condition = whileStatement.getCondition();
        JSConditionInstruction.ConditionState state2 = JSControlFlowBuilder.evaluateCondition(condition);
        JSBranchInstruction conditionTrue = new JSBranchInstruction((PsiElement)whileStatement, JSBranchInstruction.BranchOwner.WHILE, true, state2);
        JSBranchInstruction conditionFalse = new JSBranchInstruction((PsiElement)whileStatement, JSBranchInstruction.BranchOwner.WHILE, false, state2);
        this.processCondition(condition, (Instruction)conditionTrue, (Instruction)conditionFalse);
        this.connectPendingToNodes((PsiElement)whileStatement, (Instruction)conditionTrue, (Instruction)conditionFalse);
        this.myBuilder.prevInstruction = conditionTrue;
        conditionTrue.addToInstructions(this.myBuilder);
        this.jump((Instruction)junction);
        this.myBuilder.prevInstruction = conditionFalse;
        conditionFalse.addToInstructions(this.myBuilder);
        this.myBuilder.addNodeAndCheckPending((Instruction)loopOutInstruction);
        this.popBreakContinueFlow((PsiElement)whileStatement);
    }

    @Override
    public void visitJSYieldExpression(JSYieldExpression statement) {
        this.addNode((PsiElement)statement);
        super.visitJSYieldExpression(statement);
    }

    @Override
    public void visitJSReturnStatement(JSReturnStatement node) {
        this.addNode((PsiElement)node);
        JSExpression expression = node.getExpression();
        if (expression != null) {
            expression.accept(this);
        }
        TransparentInstruction returnInstruction = this.myBuilder.startTransparentNode((PsiElement)node, "return");
        TryFinallyFlow nearestTryWithFinally = this.findNearestTryWithFinally();
        if (nearestTryWithFinally == null) {
            this.myBuilder.addPendingEdge(null, (Instruction)returnInstruction);
        } else {
            nearestTryWithFinally.join((Instruction)returnInstruction, this.myBuilder);
            List reverse = ContainerUtil.reverse(new ArrayList<TryPartFlow>(this.myTryTargets));
            for (TryPartFlow flow : reverse) {
                if (!(flow instanceof TryFinallyFlow)) continue;
                JSFinallyEndInstruction topFinallyEndInstruction = ((TryFinallyFlow)flow).myFinallyEndInstruction;
                boolean hasEdgeToExitPoint = false;
                for (Pair pair : this.myBuilder.pending) {
                    if (pair.first != null || pair.second != topFinallyEndInstruction) continue;
                    hasEdgeToExitPoint = true;
                    break;
                }
                if (hasEdgeToExitPoint) break;
                this.myBuilder.addPendingEdge(null, (Instruction)topFinallyEndInstruction);
                break;
            }
        }
        this.myBuilder.flowAbrupted();
    }

    @Override
    public void visitJSBreakStatement(@NotNull JSBreakStatement node) {
        BreakContinueFlow flow;
        if (node == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(41);
        }
        Instruction instruction = this.addNode((PsiElement)node);
        JSStatement statementToBreak = JSControlFlowBuilder.unwrapLabelStatement(node.getStatementToBreak());
        if (statementToBreak != null && (flow = this.myJumpTargets.get(statementToBreak)) != null) {
            this.jumpBreakOrContinue((PsiElement)statementToBreak, instruction, flow.endInstruction);
        }
    }

    @Override
    public void visitJSContinueStatement(@NotNull JSContinueStatement node) {
        BreakContinueFlow flow;
        if (node == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(42);
        }
        Instruction instruction = this.addNode((PsiElement)node);
        JSStatement statement = JSControlFlowBuilder.unwrapLabelStatement(node.getStatementToContinue());
        if (statement != null && (flow = this.myJumpTargets.get(statement)) != null && flow.continueInstruction != null) {
            this.jumpBreakOrContinue((PsiElement)statement, instruction, flow.continueInstruction);
        }
    }

    @Nullable
    private static JSStatement unwrapLabelStatement(@Nullable JSStatement statementToBreak) {
        if (statementToBreak instanceof JSLabeledStatement) {
            statementToBreak = ((JSLabeledStatement)statementToBreak).getStatement();
        }
        return statementToBreak;
    }

    @Override
    public void visitJSThrowExpression(JSThrowExpression node) {
        if (PsiTreeUtil.getParentOfType((PsiElement)node, JSParameter.class, (boolean)true, (Class[])new Class[]{JSFunction.class}) == null) {
            this.addNode((PsiElement)node);
            this.addThrowVertex((PsiElement)node, node.getExpression());
        } else {
            super.visitJSThrowExpression(node);
        }
    }

    @Override
    public void visitJSThrowStatement(JSThrowStatement node) {
        this.addNode((PsiElement)node);
        this.addThrowVertex((PsiElement)node, node.getExpression());
    }

    private void addThrowVertex(@NotNull PsiElement node, @Nullable JSExpression expression) {
        if (node == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(43);
        }
        if (expression != null) {
            expression.accept(this);
        }
        TransparentInstruction throwInstruction = this.myBuilder.startTransparentNode(node, "return");
        if (this.myTryTargets.isEmpty()) {
            this.myBuilder.addPendingEdge(null, (Instruction)throwInstruction);
        } else {
            TryPartFlow target = this.myTryTargets.peek();
            target.join((Instruction)throwInstruction, this.myBuilder);
        }
        this.myBuilder.flowAbrupted();
    }

    private void jumpBreakOrContinue(@NotNull PsiElement owner, @NotNull Instruction currentInstruction, @NotNull Instruction endInstruction) {
        TryFinallyFlow withFinally;
        if (owner == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(44);
        }
        if (currentInstruction == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(45);
        }
        if (endInstruction == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(46);
        }
        if ((withFinally = this.findNearestTryWithFinally()) == null || !PsiTreeUtil.isAncestor((PsiElement)owner, (PsiElement)withFinally.myTryStatement, (boolean)true)) {
            this.myBuilder.addEdge(currentInstruction, endInstruction);
        } else {
            JSFinallyEntryInstruction finallyEntryInstruction = withFinally.myFinallyEntryInstruction;
            this.myBuilder.addEdge(currentInstruction, (Instruction)finallyEntryInstruction);
            ArrayList<TryPartFlow> targets = new ArrayList<TryPartFlow>(this.myTryTargets);
            List reversedTargets = ContainerUtil.reverse(targets);
            for (TryPartFlow flow : reversedTargets) {
                if (!(flow instanceof TryFinallyFlow) || !PsiTreeUtil.isAncestor((PsiElement)owner, (PsiElement)withFinally.myTryStatement, (boolean)true)) continue;
                this.myBuilder.addEdge((Instruction)((TryFinallyFlow)flow).myFinallyEndInstruction, endInstruction);
                break;
            }
        }
        this.myBuilder.flowAbrupted();
    }

    @Override
    public void visitJSSwitchStatement(@NotNull JSSwitchStatement switchStatement) {
        if (switchStatement == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(47);
        }
        this.addNode((PsiElement)switchStatement);
        TransparentInstructionImpl switchOutInstruction = new TransparentInstructionImpl(this.myBuilder, (PsiElement)switchStatement, "switch-exit-point");
        this.pushBreakContinueFlow((PsiElement)switchStatement, null, (Instruction)switchOutInstruction);
        JSExpression expression = switchStatement.getSwitchExpression();
        JSCaseClause[] clauses = switchStatement.getCaseClauses();
        if (expression != null) {
            expression.accept(this);
        }
        this.myBuilder.startTransparentNode((PsiElement)switchStatement, "switch-start");
        JSCaseBlockEndInstruction prevCaseStatements = null;
        TransparentInstruction prevCaseCondition = null;
        for (int i2 = 0; i2 < clauses.length; ++i2) {
            JSSourceElement[] statements;
            JSCaseClause clause = clauses[i2];
            if (prevCaseCondition != null) {
                this.myBuilder.prevInstruction = prevCaseCondition;
            }
            this.addNode(clause);
            JSExpression caseExpression = clause.getCaseExpression();
            if (caseExpression != null) {
                caseExpression.accept(this);
            }
            TransparentInstruction currentCaseCondition = this.myBuilder.startTransparentNode((PsiElement)clause, "after-case-condition");
            JSCaseBlockInstruction startStatements = new JSCaseBlockInstruction(clause, i2);
            startStatements.addToInstructions(this.myBuilder);
            if (prevCaseStatements != null) {
                this.myBuilder.addEdge(prevCaseStatements, (Instruction)startStatements);
            }
            this.myBuilder.addEdge((Instruction)currentCaseCondition, (Instruction)startStatements);
            this.myBuilder.prevInstruction = startStatements;
            for (JSSourceElement statement : statements = clause.getStatementListItems()) {
                statement.accept(this);
            }
            if (this.myBuilder.prevInstruction == null) {
                prevCaseStatements = null;
            } else {
                JSCaseBlockEndInstruction caseEnd = new JSCaseBlockEndInstruction(this.myBuilder, startStatements);
                this.myBuilder.addNode((Instruction)caseEnd);
                prevCaseStatements = caseEnd;
            }
            prevCaseCondition = currentCaseCondition;
        }
        this.myBuilder.addNodeAndCheckPending((Instruction)switchOutInstruction);
        if (prevCaseCondition != null && !clauses[clauses.length - 1].isDefault()) {
            JSCaseBlockInstruction fakeNoMatchCase = new JSCaseBlockInstruction((PsiElement)switchStatement, -1);
            fakeNoMatchCase.addToInstructions(this.myBuilder);
            this.myBuilder.addEdge(prevCaseCondition, (Instruction)fakeNoMatchCase);
            this.myBuilder.addEdge((Instruction)fakeNoMatchCase, (Instruction)switchOutInstruction);
        }
        this.popBreakContinueFlow((PsiElement)switchStatement);
    }

    @Override
    public void visitJSTryStatement(@NotNull JSTryStatement node) {
        Object[] blocks;
        List catchEntries;
        JSFinallyEndInstruction endFinallyInstruction;
        if (node == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(48);
        }
        Instruction startTryInstruction = this.addNode((PsiElement)node);
        JSExpression initialization = node.getResourceExpression();
        JSVarStatement varDeclaration = node.getVarDeclaration();
        if (initialization != null) {
            initialization.accept(this);
        } else if (varDeclaration != null) {
            varDeclaration.accept(this);
        }
        JSStatement statement = node.getStatement();
        if (statement == null) {
            super.visitJSTryStatement(node);
            return;
        }
        JSStatement finallyStatement = node.getFinallyStatement();
        JSFinallyEntryInstruction startFinallyInstruction = finallyStatement == null ? null : new JSFinallyEntryInstruction((PsiElement)node);
        JSFinallyEndInstruction jSFinallyEndInstruction = endFinallyInstruction = finallyStatement == null ? null : new JSFinallyEndInstruction((PsiElement)finallyStatement);
        if (startFinallyInstruction != null) {
            this.myTryTargets.push(new TryFinallyFlow(node, startFinallyInstruction, endFinallyInstruction));
        }
        if ((catchEntries = ContainerUtil.map((Object[])(blocks = node.getAllCatchBlocks()), JSCatchEntryInstruction::new)).size() > 0) {
            this.myTryTargets.push(new TryCatchFlow(node, catchEntries));
        }
        statement.accept(this);
        TransparentInstructionImpl endTryInstruction = new TransparentInstructionImpl(this.myBuilder, (PsiElement)node, "try-end");
        this.myBuilder.addNodeAndCheckPending((Instruction)endTryInstruction);
        if (catchEntries.size() > 0) {
            this.myTryTargets.pop();
            TransparentInstructionImpl endCatchInstruction = new TransparentInstructionImpl(this.myBuilder, (PsiElement)node, "catches-end");
            for (int i2 = 0; i2 < blocks.length; ++i2) {
                Object block = blocks[i2];
                JSCatchEntryInstruction startCatchInstruction = (JSCatchEntryInstruction)((Object)catchEntries.get(i2));
                startCatchInstruction.addToInstructions(this.myBuilder);
                this.myBuilder.addEdge(startTryInstruction, (Instruction)startCatchInstruction);
                this.myBuilder.prevInstruction = startCatchInstruction;
                block.accept((PsiElementVisitor)this);
                this.myBuilder.addEdge(this.myBuilder.prevInstruction, (Instruction)endCatchInstruction);
                this.myBuilder.addEdge((Instruction)endTryInstruction, (Instruction)startCatchInstruction);
                this.myBuilder.checkPending((Instruction)endCatchInstruction);
            }
            this.myBuilder.addNodeAndCheckPending((Instruction)endCatchInstruction);
            this.myBuilder.addPendingEdge((PsiElement)blocks[0], (Instruction)endCatchInstruction);
        }
        if (startFinallyInstruction != null) {
            TryCatchFlow catchBlock;
            this.myTryTargets.pop();
            if (catchEntries.isEmpty()) {
                this.myBuilder.addEdge(startTryInstruction, (Instruction)startFinallyInstruction);
            } else {
                for (JSCatchEntryInstruction entry : catchEntries) {
                    this.myBuilder.addEdge((Instruction)entry, (Instruction)startFinallyInstruction);
                }
            }
            this.myBuilder.addEdge((Instruction)endTryInstruction, (Instruction)startFinallyInstruction);
            startFinallyInstruction.addNode(this.myBuilder);
            finallyStatement.accept(this);
            endFinallyInstruction.addTransparentNode(this.myBuilder);
            TryFinallyFlow parentTry = this.findNearestTryWithFinally();
            boolean hasParentHandler = false;
            if (parentTry != null) {
                this.myBuilder.addEdge((Instruction)endFinallyInstruction, (Instruction)parentTry.myFinallyEntryInstruction);
                hasParentHandler = true;
            }
            if (catchEntries.size() == 0 && (catchBlock = this.findNearestTryWithCatch()) != null) {
                hasParentHandler = true;
                catchBlock.join((Instruction)endFinallyInstruction, this.myBuilder);
            }
            if (!hasParentHandler) {
                this.myBuilder.addPendingEdge(null, (Instruction)endFinallyInstruction);
            }
        } else {
            this.myBuilder.addPendingEdge((PsiElement)statement, (Instruction)endTryInstruction);
        }
    }

    @Nullable
    private TryFinallyFlow findNearestTryWithFinally() {
        for (TryPartFlow target : this.myTryTargets) {
            if (!(target instanceof TryFinallyFlow)) continue;
            return (TryFinallyFlow)target;
        }
        return null;
    }

    @Override
    public void visitJSFunctionProperty(JSFunctionProperty functionProperty) {
        this.visitJSFunctionDeclaration(functionProperty);
    }

    @Nullable
    private TryCatchFlow findNearestTryWithCatch() {
        for (TryPartFlow target : this.myTryTargets) {
            if (!(target instanceof TryCatchFlow) || ((TryCatchFlow)target).myCatchEntries.size() <= 0) continue;
            return (TryCatchFlow)target;
        }
        return null;
    }

    @Override
    public void visitJSCallExpression(JSCallExpression node) {
        String name;
        super.visitJSCallExpression(node);
        JSExpression expression = node.getMethodExpression();
        if (expression instanceof JSReferenceExpression && JSControlFlowTypeGuard.isPushOrUnshiftName(name = ((JSReferenceExpression)expression).getReferenceName()) && JSTypeGuardChecker.isNarrowableReference(expression)) {
            JSArrayModificationInstruction instruction = new JSArrayModificationInstruction(this.myBuilder, (PsiElement)node, expression);
            this.myBuilder.addNodeAndCheckPending((Instruction)instruction);
            return;
        }
        JSCallInstruction instruction = new JSCallInstruction(this.myBuilder, (PsiElement)node);
        this.myBuilder.addNodeAndCheckPending((Instruction)instruction);
    }

    @Override
    public void visitJSAssignmentExpression(JSAssignmentExpression node) {
        JSDefinitionExpression definitionExpression = node.getDefinitionExpression();
        if (definitionExpression != null) {
            JSExpression expression = definitionExpression.getExpression();
            if (expression instanceof JSReferenceExpression) {
                super.visitJSAssignmentExpression(node);
                String name = definitionExpression.getQualifiedName();
                if (name != null) {
                    Instruction instruction = node.getOperationSign() == JSTokenTypes.EQ ? this.writeAccess((PsiElement)node, name) : this.readWriteAccess((PsiElement)node, name);
                    this.myBuilder.addNodeAndCheckPending(instruction);
                    PsiElement parent = node.getParent();
                    if (JSControlFlowBuilder.isReadParent(node, parent)) {
                        this.myBuilder.addNode(this.readAccess((PsiElement)node, name));
                    }
                }
            } else if (expression instanceof JSArrayLiteralExpression) {
                JSExpression rOperand = node.getROperand();
                if (rOperand != null) {
                    rOperand.accept(this);
                }
                expression.accept(this);
            } else if (expression instanceof JSIndexedPropertyAccessExpression && node.getOperationSign() == JSTokenTypes.EQ) {
                super.visitJSAssignmentExpression(node);
                JSExpression qualifier = ((JSIndexedPropertyAccessExpression)expression).getQualifier();
                if (JSTypeGuardChecker.isNarrowableReference(qualifier)) {
                    JSIndexedModificationInstruction indexedModificationInstruction = new JSIndexedModificationInstruction(this.myBuilder, (PsiElement)node, qualifier);
                    this.myBuilder.addNodeAndCheckPending((Instruction)indexedModificationInstruction);
                }
            } else {
                super.visitJSAssignmentExpression(node);
            }
        } else {
            super.visitJSAssignmentExpression(node);
        }
    }

    private static boolean isReadParent(@NotNull JSExpression node, @Nullable PsiElement parent) {
        if (node == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(49);
        }
        return parent instanceof JSExpression || parent instanceof JSConditionOwner && ((JSConditionOwner)parent).getCondition() == node || parent instanceof JSSwitchStatement && ((JSSwitchStatement)parent).getSwitchExpression() == node;
    }

    private Instruction readAccess(@NotNull PsiElement element, @Nullable String name) {
        if (element == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(50);
        }
        return new JSReadWriteInstruction(this.myBuilder, element, ReadWriteAccessDetector.Access.Read, name);
    }

    private Instruction writeAccess(@NotNull PsiElement element, @Nullable String name) {
        if (element == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(51);
        }
        return new JSReadWriteInstruction(this.myBuilder, element, ReadWriteAccessDetector.Access.Write, name);
    }

    private Instruction readWriteAccess(@NotNull PsiElement element, @Nullable String name) {
        if (element == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(52);
        }
        return new JSReadWriteInstruction(this.myBuilder, element, ReadWriteAccessDetector.Access.ReadWrite, name);
    }

    @NotNull
    private Instruction addNode(@NotNull PsiElement node) {
        if (node == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(53);
        }
        Instruction instruction = this.myBuilder.startNode(node);
        if (instruction == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(54);
        }
        return instruction;
    }

    @NotNull
    private static JSConditionInstruction.ConditionState evaluateCondition(@Nullable JSExpression expression) {
        JSLiteralExpression literalExpression;
        if (expression == null) {
            JSConditionInstruction.ConditionState conditionState = JSConditionInstruction.ConditionState.UNKNOWN;
            if (conditionState == null) {
                JSControlFlowBuilder.$$$reportNull$$$0(55);
            }
            return conditionState;
        }
        JSExpression realExpression = JSUtils.unparenthesize(expression);
        if (realExpression instanceof JSLiteralExpression && (literalExpression = (JSLiteralExpression)realExpression).isBooleanLiteral()) {
            Object value = literalExpression.getValue();
            JSConditionInstruction.ConditionState conditionState = value instanceof Boolean ? JSConditionInstruction.ConditionState.toCondition((Boolean)value) : JSConditionInstruction.ConditionState.UNKNOWN;
            if (conditionState == null) {
                JSControlFlowBuilder.$$$reportNull$$$0(56);
            }
            return conditionState;
        }
        JSConditionInstruction.ConditionState conditionState = JSConditionInstruction.ConditionState.UNKNOWN;
        if (conditionState == null) {
            JSControlFlowBuilder.$$$reportNull$$$0(57);
        }
        return conditionState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 23: 
            case 24: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 23: 
            case 24: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: 
            case 2: 
            case 23: 
            case 24: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/controlflow/JSControlFlowBuilder";
                break;
            }
            case 3: 
            case 28: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trueTarget";
                break;
            }
            case 4: 
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "falseTarget";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakContinueTarget";
                break;
            }
            case 6: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endInstruction";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toInstruction";
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 41: 
            case 42: 
            case 43: 
            case 48: 
            case 49: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 16: 
            case 18: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchOwner";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 27: 
            case 35: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstNode";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondNode";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forStatement";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forInStatement";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whileStatement";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentInstruction";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchStatement";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/controlflow/JSControlFlowBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getControlFlow";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getControlFlowBuilder";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceExpressionInstruction";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "addNode";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateCondition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 23: 
            case 24: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "pushConditionTargets";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "pushBreakContinueFlow";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "popBreakContinueFlow";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "jump";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "visitJSFunctionExpression";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "visitJSFunctionDeclaration";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "visitJSClass";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeScriptModule";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "visitJSIfStatement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "visitJSConditionalExpression";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processThenable";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processBranching";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "reapplyPendingScopesAndUpdateNeverAvailable";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "visitJSReferenceExpression";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceExpressionInstruction";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isForEachVariableExpression";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "visitJSBinaryExpression";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processLogicalExpression";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "connectPendingToNodes";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "processCondition";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isTopLevelBinaryExpression";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isLogicalExpression";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isExclExpression";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "visitJSForStatement";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "visitJSForInStatement";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "visitJSWhileStatement";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "visitJSBreakStatement";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "visitJSContinueStatement";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "addThrowVertex";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "jumpBreakOrContinue";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "visitJSSwitchStatement";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "visitJSTryStatement";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isReadParent";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "readAccess";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "writeAccess";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "readWriteAccess";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "addNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 23: 
            case 24: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class TryCatchFlow
    extends TryPartFlow {
        @NotNull
        private final List<JSCatchEntryInstruction> myCatchEntries;

        private TryCatchFlow(@NotNull JSTryStatement node, @NotNull List<JSCatchEntryInstruction> entries) {
            if (node == null) {
                TryCatchFlow.$$$reportNull$$$0(0);
            }
            if (entries == null) {
                TryCatchFlow.$$$reportNull$$$0(1);
            }
            super(node);
            this.myCatchEntries = entries;
        }

        @Override
        protected void join(@NotNull Instruction fromInstruction, @NotNull ControlFlowBuilder builder) {
            if (fromInstruction == null) {
                TryCatchFlow.$$$reportNull$$$0(2);
            }
            if (builder == null) {
                TryCatchFlow.$$$reportNull$$$0(3);
            }
            for (JSCatchEntryInstruction catchEntryInstruction : this.myCatchEntries) {
                builder.addEdge(fromInstruction, (Instruction)catchEntryInstruction);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entries";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fromInstruction";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/controlflow/JSControlFlowBuilder$TryCatchFlow";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "join";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class TryFinallyFlow
    extends TryPartFlow {
        @NotNull
        private final JSFinallyEntryInstruction myFinallyEntryInstruction;
        @NotNull
        private final JSFinallyEndInstruction myFinallyEndInstruction;

        private TryFinallyFlow(@NotNull JSTryStatement node, @NotNull JSFinallyEntryInstruction finallyEntryInstruction, @NotNull JSFinallyEndInstruction finallyBlockEndInstruction) {
            if (node == null) {
                TryFinallyFlow.$$$reportNull$$$0(0);
            }
            if (finallyEntryInstruction == null) {
                TryFinallyFlow.$$$reportNull$$$0(1);
            }
            if (finallyBlockEndInstruction == null) {
                TryFinallyFlow.$$$reportNull$$$0(2);
            }
            super(node);
            this.myFinallyEntryInstruction = finallyEntryInstruction;
            this.myFinallyEndInstruction = finallyBlockEndInstruction;
        }

        @Override
        protected void join(@NotNull Instruction fromInstruction, @NotNull ControlFlowBuilder builder) {
            if (fromInstruction == null) {
                TryFinallyFlow.$$$reportNull$$$0(3);
            }
            if (builder == null) {
                TryFinallyFlow.$$$reportNull$$$0(4);
            }
            builder.addEdge(fromInstruction, (Instruction)this.myFinallyEntryInstruction);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "finallyEntryInstruction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "finallyBlockEndInstruction";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fromInstruction";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/controlflow/JSControlFlowBuilder$TryFinallyFlow";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "join";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class TryPartFlow {
        @NotNull
        protected final JSTryStatement myTryStatement;

        private TryPartFlow(@NotNull JSTryStatement node) {
            if (node == null) {
                TryPartFlow.$$$reportNull$$$0(0);
            }
            this.myTryStatement = node;
        }

        protected abstract void join(@NotNull Instruction var1, @NotNull ControlFlowBuilder var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/psi/controlflow/JSControlFlowBuilder$TryPartFlow", "<init>"));
        }
    }

    private static final class BreakContinueFlow {
        @Nullable
        private final Instruction continueInstruction;
        @NotNull
        private final Instruction endInstruction;

        private BreakContinueFlow(@Nullable Instruction continueInstruction, @NotNull Instruction breakInstruction) {
            if (breakInstruction == null) {
                BreakContinueFlow.$$$reportNull$$$0(0);
            }
            this.continueInstruction = continueInstruction;
            this.endInstruction = breakInstruction;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakInstruction", "com/intellij/lang/javascript/psi/controlflow/JSControlFlowBuilder$BreakContinueFlow", "<init>"));
        }
    }

    private static final class ConditionFlow {
        @NotNull
        private final Instruction myTrueInstruction;
        @NotNull
        private final Instruction myFalseInstruction;

        private ConditionFlow(@NotNull Instruction trueInstruction, @NotNull Instruction falseInstruction) {
            if (trueInstruction == null) {
                ConditionFlow.$$$reportNull$$$0(0);
            }
            if (falseInstruction == null) {
                ConditionFlow.$$$reportNull$$$0(1);
            }
            this.myTrueInstruction = trueInstruction;
            this.myFalseInstruction = falseInstruction;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "trueInstruction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "falseInstruction";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/psi/controlflow/JSControlFlowBuilder$ConditionFlow";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

