/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.openapi.progress.ProgressManager;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSRecursiveTypeVisitor {
    @NotNull
    private final Set<Object> myVisited;
    private final Checks myCheckResolved;

    public JSRecursiveTypeVisitor() {
        this(false);
    }

    public JSRecursiveTypeVisitor(boolean checkResolved) {
        this(checkResolved ? Checks.RESOLVE : Checks.SIMPLE);
    }

    public JSRecursiveTypeVisitor(@NotNull Checks checkResolved) {
        if (checkResolved == null) {
            JSRecursiveTypeVisitor.$$$reportNull$$$0(0);
        }
        this.myCheckResolved = checkResolved;
        this.myVisited = this.myCheckResolved == Checks.DISABLED ? Collections.emptySet() : new HashSet();
    }

    public void visitJSTypeImpl(@NotNull JSType type) {
        if (type == null) {
            JSRecursiveTypeVisitor.$$$reportNull$$$0(1);
        }
        this.visitJSTypeBaseImpl(type);
    }

    public void visitJSRecordType(@NotNull JSType type) {
        if (type == null) {
            JSRecursiveTypeVisitor.$$$reportNull$$$0(2);
        }
        this.visitJSTypeBaseImpl(type);
    }

    public void visitJSCompositeBaseType(@NotNull JSType type) {
        if (type == null) {
            JSRecursiveTypeVisitor.$$$reportNull$$$0(3);
        }
        this.visitJSTypeBaseImpl(type);
    }

    public void visitJSFunctionType(@NotNull JSType type) {
        if (type == null) {
            JSRecursiveTypeVisitor.$$$reportNull$$$0(4);
        }
        this.visitJSTypeBaseImpl(type);
    }

    public void visitJSDecoratedType(@NotNull JSType type) {
        if (type == null) {
            JSRecursiveTypeVisitor.$$$reportNull$$$0(5);
        }
        this.visitJSTypeBaseImpl(type);
    }

    public void visitJSGenericType(@NotNull JSType type) {
        if (type == null) {
            JSRecursiveTypeVisitor.$$$reportNull$$$0(6);
        }
        this.visitJSTypeBaseImpl(type);
    }

    public void visitJSTypeBaseImpl(@NotNull JSType type) {
        if (type == null) {
            JSRecursiveTypeVisitor.$$$reportNull$$$0(7);
        }
        this.visitFor(type);
    }

    public void visitJSGenericParameter(@NotNull JSType type) {
        if (type == null) {
            JSRecursiveTypeVisitor.$$$reportNull$$$0(8);
        }
        this.visitJSTypeBaseImpl(type);
    }

    public void visitTypeScriptThisGenericType(@NotNull JSType type) {
        if (type == null) {
            JSRecursiveTypeVisitor.$$$reportNull$$$0(9);
        }
        this.visitJSTypeBaseImpl(type);
    }

    public void visitTypeScriptTemplateLiteralType(@NotNull JSType type) {
        if (type == null) {
            JSRecursiveTypeVisitor.$$$reportNull$$$0(10);
        }
        this.visitJSTypeBaseImpl(type);
    }

    protected final void visitFor(@NotNull JSType type) {
        if (type == null) {
            JSRecursiveTypeVisitor.$$$reportNull$$$0(11);
        }
        if (this.myCheckResolved == Checks.DISABLED || this.myVisited.add(this.myCheckResolved == Checks.RESOLVE ? type.getResolvedTypeId() : type)) {
            ProgressManager.checkCanceled();
            this.visitJSType(type);
        }
    }

    public void visitJSType(@NotNull JSType type) {
        if (type == null) {
            JSRecursiveTypeVisitor.$$$reportNull$$$0(12);
        }
        type.acceptChildren(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkResolved";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSRecursiveTypeVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSTypeImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSRecordType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSCompositeBaseType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSFunctionType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSDecoratedType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSGenericType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSTypeBaseImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSGenericParameter";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTypeScriptThisGenericType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTypeScriptTemplateLiteralType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "visitFor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Checks {
        SIMPLE,
        RESOLVE,
        DISABLED;

    }
}

