/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.inline;

import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import gnu.trove.THashSet;
import java.util.Set;

class InjectionQuoteHandler {
    private final boolean inDoubleQuotedContext;
    private final Set<RangeMarker> literalExpressionsToFix;

    InjectionQuoteHandler(PsiElement context) {
        PsiElement injectionPlace = context.getContainingFile().getContext();
        if (injectionPlace != null) {
            String injectionText = injectionPlace.getText();
            this.inDoubleQuotedContext = StringUtil.startsWith((CharSequence)injectionText, (CharSequence)"\"");
            boolean inQuotedContext = StringUtil.startsWith((CharSequence)injectionText, (CharSequence)"'");
            this.literalExpressionsToFix = this.inDoubleQuotedContext || inQuotedContext ? new THashSet() : null;
        } else {
            this.inDoubleQuotedContext = false;
            this.literalExpressionsToFix = null;
        }
    }

    void fixQuotes(PsiElement element, int offset, Document document2) {
        if (this.literalExpressionsToFix != null) {
            SyntaxTraverser.psiTraverser((PsiElement)element).filter(JSLiteralExpression.class).map(lit -> InjectionQuoteHandler.rangeMarker((PsiElement)lit, document2, offset)).addAllTo(this.literalExpressionsToFix);
            char outerBound = this.inDoubleQuotedContext ? (char)'\"' : '\'';
            String outerBoundReplacement = this.inDoubleQuotedContext ? "&quot;" : "&apos;";
            char newBound = this.inDoubleQuotedContext ? (char)'\'' : '\"';
            for (RangeMarker marker : this.literalExpressionsToFix) {
                int endStart = marker.getEndOffset() - 1;
                int startEnd = marker.getStartOffset() + 1;
                CharSequence sequence = document2.getCharsSequence();
                boolean escaped = false;
                char literalStart = sequence.charAt(startEnd - 1);
                boolean changeLiteralBounds = literalStart == outerBound;
                for (int i2 = startEnd; i2 < endStart; ++i2) {
                    sequence = document2.getCharsSequence();
                    char ch = sequence.charAt(i2);
                    if (escaped) {
                        if (ch == outerBound) {
                            document2.replaceString(i2 - 1, i2 + 1, (CharSequence)outerBoundReplacement);
                            i2 += outerBoundReplacement.length() - 2;
                            endStart += outerBoundReplacement.length() - 2;
                        }
                        escaped = false;
                        continue;
                    }
                    if (ch == '\\' && !escaped) {
                        escaped = true;
                        continue;
                    }
                    if (escaped) continue;
                    if (ch == outerBound) {
                        document2.replaceString(i2, i2 + 1, (CharSequence)outerBoundReplacement);
                        i2 += outerBoundReplacement.length() - 1;
                        endStart += outerBoundReplacement.length() - 1;
                        continue;
                    }
                    if (ch != newBound || !changeLiteralBounds) continue;
                    document2.insertString(i2, (CharSequence)"\\");
                    ++i2;
                    ++endStart;
                }
                if (!changeLiteralBounds) continue;
                document2.replaceString(marker.getStartOffset(), startEnd, (CharSequence)Character.toString(newBound));
                document2.replaceString(endStart, marker.getEndOffset(), (CharSequence)Character.toString(newBound));
            }
        }
    }

    private static RangeMarker rangeMarker(PsiElement node, Document document2, int funOffset) {
        return document2.createRangeMarker(node.getTextRange().shiftRight(funOffset));
    }
}

