/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSWithStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.validation.JSProblemReporter;
import com.intellij.lang.javascript.validation.JSReferenceChecker;
import com.intellij.lang.javascript.validation.JSReferenceInspectionProblemReporter;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypedJSReferenceChecker
extends JSReferenceChecker {
    public TypedJSReferenceChecker(@NotNull JSProblemReporter<?> reporter) {
        if (reporter == null) {
            TypedJSReferenceChecker.$$$reportNull$$$0(0);
        }
        super(reporter);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public TypedJSReferenceChecker(final @NotNull JSReferenceInspectionProblemReporter reporter) {
        if (reporter == null) {
            TypedJSReferenceChecker.$$$reportNull$$$0(1);
        }
        super(new JSProblemReporter<Void>(){

            @Override
            @Nullable
            public Void registerProblem(PsiElement place, @Nullable TextRange rangeWithinElement, @NotNull @InspectionMessage String message, @Nullable ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
                if (message == null) {
                    1.$$$reportNull$$$0(0);
                }
                reporter.reportUnresolvedVariableError(place, highlightType, message, Arrays.asList(fixes));
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/validation/TypedJSReferenceChecker$1", "registerProblem"));
            }
        });
    }

    @Override
    @Nullable
    public ProblemHighlightType getUnresolvedReferenceHighlightType(@NotNull JSReferenceExpression node) {
        JSExpression qualifier;
        if (node == null) {
            TypedJSReferenceChecker.$$$reportNull$$$0(2);
        }
        if ((qualifier = node.getQualifier()) == null && node instanceof JSReferenceExpressionImpl) {
            qualifier = ((JSReferenceExpressionImpl)node).getResolveQualifier();
        }
        if (qualifier == null) {
            JSExpression expression;
            JSWithStatement withStatement = (JSWithStatement)PsiTreeUtil.getParentOfType((PsiElement)node, JSWithStatement.class);
            if (withStatement != null && (expression = withStatement.getExpression()) != null && expression != node && PsiTreeUtil.findCommonParent((PsiElement)node, (PsiElement)expression) != expression) {
                return ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
            }
            return ProblemHighlightType.ERROR;
        }
        return ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
    }

    @Override
    protected boolean suggestCreateVarFromUsage(JSReferenceExpression node) {
        JSClass clazz;
        JSExpression qualifier = node.getQualifier();
        JSClass targetClass = null;
        if (qualifier == null) {
            targetClass = JSResolveUtil.getClassOfContext((PsiElement)node);
        } else if (qualifier instanceof JSReferenceExpression && DialectDetector.isActionScript((PsiElement)node) && (clazz = ActionScriptResolveUtil.findClassOfQualifier(qualifier, node.getContainingFile())) != null) {
            targetClass = clazz;
        }
        if (targetClass != null) {
            return !targetClass.isInterface();
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/validation/TypedJSReferenceChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getUnresolvedReferenceHighlightType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

