/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.TypeScriptFileType;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.ProjectScope;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TypeScriptDeprecatedSettingsPanel {
    private final Project myProject;
    private final TypeScriptCompilerSettings myCompilerSettings;
    private final boolean myIsEnabled;
    private JBRadioButton myRadioSetManual;
    private JBRadioButton myRadioUseConfigForCompiler;
    private JCheckBox myGenerateSourceMapCheckBox;
    private JCheckBox myHasOutDirectoryCheckbox;
    private TextFieldWithBrowseButton myOutDirectory;
    private JCheckBox myUseMainFileCheckbox;
    private TextFieldWithBrowseButton myMainFilePath;
    private JBLabel myMainFileErrorLabel;
    private JPanel myCompilerOptionsPanel;
    private JCheckBox myEnableServiceForProjectsWithoutConfig;
    private ScopeChooserCombo myScopeChooserCombo;

    public TypeScriptDeprecatedSettingsPanel(@NotNull Project project, @NotNull TypeScriptCompilerSettings compilerSettings) {
        if (project == null) {
            TypeScriptDeprecatedSettingsPanel.$$$reportNull$$$0(0);
        }
        if (compilerSettings == null) {
            TypeScriptDeprecatedSettingsPanel.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myCompilerSettings = compilerSettings;
        this.myIsEnabled = Registry.is((String)"typescript.compiler.all.settings") || compilerSettings.useDeprecatedSettings() || !compilerSettings.useServiceForProjectsWithoutConfig() || !compilerSettings.getDefaultScopeName().equals(compilerSettings.getScopeName());
    }

    public void buildUIFor(@NotNull FormBuilder mainFormBuilder) {
        if (mainFormBuilder == null) {
            TypeScriptDeprecatedSettingsPanel.$$$reportNull$$$0(2);
        }
        if (!this.myIsEnabled) {
            return;
        }
        this.myRadioSetManual = new JBRadioButton(JavaScriptBundle.message("radio.set.options.manually", new Object[0]));
        this.myEnableServiceForProjectsWithoutConfig = new JCheckBox(JavaScriptBundle.message("typescript.compiler.configurable.options.enable.no.config", new Object[0]));
        this.myEnableServiceForProjectsWithoutConfig.setBorder((Border)JBUI.Borders.empty());
        mainFormBuilder.addComponent((JComponent)new TitledSeparator(JavaScriptBundle.message("separator.deprecated.settings", new Object[0])));
        mainFormBuilder.addComponent((JComponent)this.myEnableServiceForProjectsWithoutConfig);
        if (!this.myProject.isDefault() && !ApplicationManager.getApplication().isUnitTestMode()) {
            this.myScopeChooserCombo = TypeScriptDeprecatedSettingsPanel.createScopeChooser();
            JPanel wrapper = new JPanel(new BorderLayout());
            wrapper.add((Component)this.myScopeChooserCombo, "West");
            wrapper.setBorder((Border)JBUI.Borders.empty());
            wrapper.add(Box.createHorizontalGlue(), "Center");
            mainFormBuilder.addLabeledComponent(JavaScriptBundle.message("typescript.compiler.configurable.options.scope", new Object[0]), (JComponent)wrapper);
        } else {
            this.myScopeChooserCombo = null;
        }
        this.myRadioUseConfigForCompiler = new JBRadioButton(JavaScriptBundle.message("radio.use.tsconfig.json", new Object[0]));
        mainFormBuilder.addLabeledComponent((JComponent)this.myRadioUseConfigForCompiler, (JComponent)this.myRadioSetManual);
        ButtonGroup group = new ButtonGroup();
        group.add((AbstractButton)this.myRadioUseConfigForCompiler);
        group.add((AbstractButton)this.myRadioSetManual);
        this.myRadioUseConfigForCompiler.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TypeScriptDeprecatedSettingsPanel.this.updateUI(TypeScriptDeprecatedSettingsPanel.this.myRadioUseConfigForCompiler.isSelected());
            }
        });
        FormBuilder compilerOptionsBuilder = this.createCompilerOptionsBuilder();
        this.myCompilerOptionsPanel = compilerOptionsBuilder.getPanel();
        this.myCompilerOptionsPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)25));
        JPanel compilerOptionsWrapper = new JPanel(new BorderLayout());
        compilerOptionsWrapper.add((Component)this.myCompilerOptionsPanel, "North");
        mainFormBuilder.addComponent((JComponent)compilerOptionsWrapper);
        this.updateError();
        this.updateUI(this.myRadioUseConfigForCompiler.isSelected());
    }

    @NotNull
    private static ScopeChooserCombo createScopeChooser() {
        return new ScopeChooserCombo(){

            protected void processScopes(DefaultComboBoxModel<ScopeDescriptor> model, DataContext c) {
                super.processScopes(model, c);
                int size = model.getSize();
                boolean hasProjectFiles = false;
                final String name = ProjectScope.getProjectFilesScopeName();
                for (int i2 = 0; i2 < size; ++i2) {
                    ScopeDescriptor at = model.getElementAt(i2);
                    if (!Objects.equals(at.getDisplayName(), name)) continue;
                    hasProjectFiles = true;
                    break;
                }
                if (!hasProjectFiles) {
                    model.addElement(new ScopeDescriptor(null){

                        @Nls
                        public String getDisplayName() {
                            return name;
                        }
                    });
                }
            }
        };
    }

    @NotNull
    private FormBuilder createCompilerOptionsBuilder() {
        FormBuilder compilerOptionsBuilder = FormBuilder.createFormBuilder();
        this.myGenerateSourceMapCheckBox = new JCheckBox(JavaScriptBundle.message("typescript.compiler.configurable.options.generate.source.map", new Object[0]));
        this.myGenerateSourceMapCheckBox.setBorder((Border)JBUI.Borders.emptyBottom((int)10));
        compilerOptionsBuilder.addComponent((JComponent)this.myGenerateSourceMapCheckBox);
        this.myUseMainFileCheckbox = new JCheckBox(JavaScriptBundle.message("typescript.compiler.configurable.options.compile.main", new Object[0]));
        this.myUseMainFileCheckbox.setBorder((Border)JBUI.Borders.empty());
        this.myMainFilePath = new TextFieldWithBrowseButton();
        this.myMainFilePath.addBrowseFolderListener(JavaScriptBundle.message("dialog.title.main.file", new Object[0]), JavaScriptBundle.message("label.choose.main.file", new Object[0]), this.myProject, FileChooserDescriptorFactory.createSingleFileDescriptor((FileType)TypeScriptFileType.INSTANCE));
        this.myUseMainFileCheckbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean enabled = TypeScriptDeprecatedSettingsPanel.this.myUseMainFileCheckbox.isEnabled() && TypeScriptDeprecatedSettingsPanel.this.myUseMainFileCheckbox.isSelected();
                TypeScriptDeprecatedSettingsPanel.this.myMainFilePath.setEnabled(enabled);
                TypeScriptDeprecatedSettingsPanel.this.updateError();
            }
        });
        this.myMainFileErrorLabel = new JBLabel(AllIcons.Actions.Lightning);
        compilerOptionsBuilder.addLabeledComponent((JComponent)this.myUseMainFileCheckbox, (JComponent)this.myMainFilePath);
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)this.myMainFileErrorLabel, "West");
        this.myMainFileErrorLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)8));
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)this.myMainFileErrorLabel);
        compilerOptionsBuilder.addComponentToRightColumn((JComponent)panel2);
        this.myHasOutDirectoryCheckbox = new JCheckBox(JavaScriptBundle.message("typescript.compiler.configurable.options.output.path", new Object[0]));
        this.myHasOutDirectoryCheckbox.setBorder((Border)JBUI.Borders.empty());
        this.myOutDirectory = new TextFieldWithBrowseButton();
        this.myOutDirectory.addBrowseFolderListener(JavaScriptBundle.message("dialog.title.output.directory", new Object[0]), JavaScriptBundle.message("label.choose.output.directory", new Object[0]), this.myProject, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        compilerOptionsBuilder.addLabeledComponent((JComponent)this.myHasOutDirectoryCheckbox, (JComponent)this.myOutDirectory);
        this.myHasOutDirectoryCheckbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean enabled = TypeScriptDeprecatedSettingsPanel.this.myHasOutDirectoryCheckbox.isEnabled() && TypeScriptDeprecatedSettingsPanel.this.myHasOutDirectoryCheckbox.isSelected();
                TypeScriptDeprecatedSettingsPanel.this.myOutDirectory.setEnabled(enabled);
            }
        });
        FormBuilder formBuilder = compilerOptionsBuilder;
        if (formBuilder == null) {
            TypeScriptDeprecatedSettingsPanel.$$$reportNull$$$0(3);
        }
        return formBuilder;
    }

    public void reset() {
        if (!this.myIsEnabled) {
            return;
        }
        boolean useDeprecatedSettings = this.myCompilerSettings.useDeprecatedSettings();
        if (useDeprecatedSettings) {
            this.myRadioSetManual.setSelected(true);
            this.myRadioUseConfigForCompiler.setSelected(false);
        } else {
            this.myRadioSetManual.setSelected(false);
            this.myRadioUseConfigForCompiler.setSelected(true);
        }
        this.myGenerateSourceMapCheckBox.setSelected(this.myCompilerSettings.isGenerateSourceMap());
        this.myGenerateSourceMapCheckBox.setSelected(this.myCompilerSettings.isGenerateSourceMap());
        this.myMainFilePath.setText(this.myCompilerSettings.getMainFilePath());
        this.myUseMainFileCheckbox.setSelected(this.myCompilerSettings.isUseMainFile());
        boolean enableForMainFile = this.myUseMainFileCheckbox.isEnabled() && this.myUseMainFileCheckbox.isSelected();
        this.myMainFilePath.setEnabled(enableForMainFile);
        this.myHasOutDirectoryCheckbox.setSelected(this.myCompilerSettings.isHasOutDirectory());
        this.myOutDirectory.setText(this.myCompilerSettings.getOutDirectory());
        boolean enabledForOut = this.myHasOutDirectoryCheckbox.isEnabled() && this.myHasOutDirectoryCheckbox.isSelected();
        this.myOutDirectory.setEnabled(enabledForOut);
        this.myEnableServiceForProjectsWithoutConfig.setSelected(this.myCompilerSettings.useServiceForProjectsWithoutConfig());
        if (this.myScopeChooserCombo != null) {
            this.myScopeChooserCombo.init(this.myProject, false, false, this.myCompilerSettings.getScopeName());
            this.myScopeChooserCombo.setUsageView(false);
            this.myScopeChooserCombo.setCurrentSelection(false);
        }
        this.updateError();
    }

    public void apply() {
        if (!this.myIsEnabled) {
            return;
        }
        this.myCompilerSettings.setUseDeprecatedSettings(this.myRadioSetManual.isSelected());
        this.myCompilerSettings.setGenerateSourceMap(this.myGenerateSourceMapCheckBox.isSelected());
        this.myCompilerSettings.setHasOutDirectory(this.myHasOutDirectoryCheckbox.isSelected());
        this.myCompilerSettings.setOutDirectory(this.myOutDirectory.getText());
        this.myCompilerSettings.setMainFilePath(this.myMainFilePath.getText());
        this.myCompilerSettings.setUseMainFile(this.myUseMainFileCheckbox.isSelected());
        this.myCompilerSettings.setUseServiceForProjectsWithoutConfig(this.myEnableServiceForProjectsWithoutConfig.isSelected());
        if (this.myScopeChooserCombo != null) {
            String scopeName = this.myScopeChooserCombo.getSelectedScopeName();
            this.myCompilerSettings.setScopeName(scopeName == null ? ProjectScope.getProjectFilesScopeName() : scopeName);
        }
    }

    public boolean isModified() {
        if (!this.myIsEnabled) {
            return false;
        }
        this.updateError();
        if (this.myMainFileErrorLabel.isVisible()) {
            return false;
        }
        return this.myGenerateSourceMapCheckBox.isSelected() != this.myCompilerSettings.isGenerateSourceMap() || this.myHasOutDirectoryCheckbox.isSelected() != this.myCompilerSettings.isHasOutDirectory() || null != this.myScopeChooserCombo && !StringUtil.equals((CharSequence)this.myScopeChooserCombo.getSelectedScopeName(), (CharSequence)this.myCompilerSettings.getScopeName()) || this.myRadioSetManual.isSelected() != this.myCompilerSettings.useDeprecatedSettings() || this.myEnableServiceForProjectsWithoutConfig.isSelected() != this.myCompilerSettings.useServiceForProjectsWithoutConfig() || this.myHasOutDirectoryCheckbox.isSelected() && !StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myOutDirectory.getText()), (CharSequence)this.myCompilerSettings.getOutDirectory()) || this.myUseMainFileCheckbox.isSelected() != this.myCompilerSettings.isUseMainFile() || this.myUseMainFileCheckbox.isSelected() && !StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myMainFilePath.getText()), (CharSequence)this.myCompilerSettings.getMainFilePath());
    }

    public void updateUI(boolean useTSConfigCompiler) {
        if (!this.myIsEnabled) {
            return;
        }
        UIUtil.setEnabled((Component)this.myCompilerOptionsPanel, (!(useTSConfigCompiler |= this.myRadioUseConfigForCompiler.isSelected()) ? 1 : 0) != 0, (boolean)true);
        boolean enabledForOut = !useTSConfigCompiler && this.myHasOutDirectoryCheckbox.isSelected();
        this.myOutDirectory.setEnabled(enabledForOut);
        boolean enableForMainFile = !useTSConfigCompiler && this.myUseMainFileCheckbox.isSelected();
        this.myMainFilePath.setEnabled(enableForMainFile);
    }

    private void updateError() {
        this.myMainFileErrorLabel.setText("");
        this.myMainFileErrorLabel.setVisible(false);
        if (!this.myUseMainFileCheckbox.isSelected() || !this.myUseMainFileCheckbox.isEnabled()) {
            return;
        }
        String path2 = this.myMainFilePath.getText();
        if (StringUtil.isEmpty((String)path2) || !new File(path2).exists()) {
            this.myMainFileErrorLabel.setVisible(true);
            this.myMainFileErrorLabel.setText(JavaScriptBundle.message("typescript.compiler.configurable.options.compile.main.error", new Object[0]));
        }
    }

    public void dispose() {
        ScopeChooserCombo combo = this.myScopeChooserCombo;
        if (combo != null) {
            Disposer.dispose((Disposable)combo);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainFormBuilder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/ui/TypeScriptDeprecatedSettingsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/ui/TypeScriptDeprecatedSettingsPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompilerOptionsBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildUIFor";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

