/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.actions.microservices;

import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.httpClient.actions.generation.HttpRequestGenerationManager;
import com.intellij.httpClient.actions.generation.HttpRequestPresentableError;
import com.intellij.httpClient.actions.generation.HttpRequestUrlContextInfo;
import com.intellij.httpClient.actions.generation.HttpRequestUrlPathInfo;
import com.intellij.httpClient.actions.generation.HttpRequestUrlPathInfoError;
import com.intellij.httpClient.actions.generation.HttpRequestUrlsGenerationRequest;
import com.intellij.httpClient.actions.generation.PartialResult;
import com.intellij.httpClient.actions.generation.PartialResultKt;
import com.intellij.httpClient.actions.microservices.HttpRequestMicroservicesUtil;
import com.intellij.httpClient.actions.microservices.OpenInHttpClientIntention;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpRequestLanguage;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.microservices.url.references.UrlPathReference;
import com.intellij.microservices.url.references.UrlPathReferenceUnifiedPomTarget;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.ContributedReferenceHost;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import icons.RestClientIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001c2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0019\u0010\u000b\u001a\t\u0018\u00010\f\u00a2\u0006\u0002\b\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0019\u0010\u0010\u001a\t\u0018\u00010\u0011\u00a2\u0006\u0002\b\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J!\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0096\u0002J\"\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a8\u0006\u001d"}, d2={"Lcom/intellij/httpClient/actions/microservices/OpenInHttpClientIntention;", "Lcom/intellij/codeInsight/intention/AbstractIntentionAction;", "Lcom/intellij/openapi/util/Iconable;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "()V", "getIcon", "Ljavax/swing/Icon;", "flags", "", "getText", "", "getUrlPathReference", "Lcom/intellij/microservices/url/references/UrlPathReference;", "Lkotlin/internal/NoInfer;", "elementAtCaret", "Lcom/intellij/psi/PsiElement;", "getWebReference", "Lcom/intellij/openapi/paths/WebReference;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "Companion", "intellij.restClient"})
public final class OpenInHttpClientIntention
extends AbstractIntentionAction
implements Iconable,
HighPriorityAction {
    private static final int SEARCH_LIMIT = 3;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getText() {
        String string = RestClientBundle.message("http.request.generate.request.in.http.client.action.message", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RestClientBundle.message\u2026p.client.action.message\")");
        return string;
    }

    @NotNull
    public Icon getIcon(int flags) {
        Icon icon = RestClientIcons.Http_requests_filetype;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"RestClientIcons.Http_requests_filetype");
        return icon;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (Intrinsics.areEqual((Object)file2.getLanguage(), (Object)((Object)HttpRequestLanguage.INSTANCE))) {
            return false;
        }
        if (editor == null) {
            return false;
        }
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        int offset = caretModel.getOffset();
        PsiElement elementAtCaret = file2.findElementAt(offset);
        WebReference webReference = this.getWebReference(elementAtCaret);
        if (webReference != null) {
            String string = webReference.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"webReference.url");
            Collection collection = PartialResultKt.unwrapSuccess(OpenInHttpClientIntention.Companion.generationRequestsFromUrl(project, string));
            boolean bl = false;
            if (!collection.isEmpty()) {
                return true;
            }
            boolean bl2 = false;
            if (bl2) return true;
        }
        if (this.getUrlPathReference(elementAtCaret) == null) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final UrlPathReference getUrlPathReference(PsiElement elementAtCaret) {
        UrlPathReference urlPathReference;
        PsiReference[] psiReferenceArray = elementAtCaret;
        if (elementAtCaret != null && (psiReferenceArray = PsiTreeUtilKt.parentOfTypes((PsiElement)psiReferenceArray, (KClass[])new KClass[]{Reflection.getOrCreateKotlinClass(PsiLanguageInjectionHost.class), Reflection.getOrCreateKotlinClass(ContributedReferenceHost.class)}, (boolean)true)) != null && (psiReferenceArray = psiReferenceArray.getReferences()) != null) {
            Object v1;
            block4: {
                void $this$filterIsInstanceTo$iv$iv;
                PsiReference[] $this$filterIsInstance$iv = psiReferenceArray;
                boolean $i$f$filterIsInstance = false;
                Object object = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof UrlPathReference)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable iterable = (List)destination$iv$iv;
                boolean bl = false;
                object = iterable;
                boolean bl2 = false;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    UrlPathReference it = (UrlPathReference)t;
                    boolean bl3 = false;
                    if (!it.isAtEnd()) continue;
                    v1 = t;
                    break block4;
                }
                v1 = null;
            }
            urlPathReference = v1;
        } else {
            urlPathReference = null;
        }
        return urlPathReference;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final WebReference getWebReference(PsiElement elementAtCaret) {
        void $this$filterIsInstanceTo$iv$iv;
        Object v3;
        PsiReference[] psiReferenceArray;
        block2: {
            psiReferenceArray = elementAtCaret;
            if (elementAtCaret == null) return null;
            PsiReference[] psiReferenceArray2 = PsiTreeUtilKt.parents((PsiElement)psiReferenceArray, (boolean)true);
            psiReferenceArray = psiReferenceArray2;
            if (psiReferenceArray2 == null) return null;
            Sequence sequence = SequencesKt.take((Sequence)psiReferenceArray, (int)3);
            psiReferenceArray = sequence;
            if (sequence == null) return null;
            PsiReference[] $this$firstOrNull$iv = psiReferenceArray;
            boolean $i$f$firstOrNull = false;
            for (Object e : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)e;
                boolean bl = false;
                if (!WebReference.isWebReferenceWorthy((PsiElement)it)) continue;
                v3 = e;
                break block2;
            }
            v3 = null;
        }
        PsiElement psiElement = v3;
        psiReferenceArray = psiElement;
        if (psiElement == null) return null;
        PsiReference[] psiReferenceArray3 = psiReferenceArray.getReferences();
        psiReferenceArray = psiReferenceArray3;
        if (psiReferenceArray3 == null) return null;
        PsiReference[] $this$filterIsInstance$iv = psiReferenceArray;
        boolean $i$f$filterIsInstance = false;
        PsiReference[] psiReferenceArray4 = $this$filterIsInstance$iv;
        Collection collection = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof WebReference)) continue;
            collection.add(element$iv$iv);
        }
        WebReference webReference = (WebReference)CollectionsKt.firstOrNull((List)((List)collection));
        return webReference;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        List list;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        UrlPathReference urlPathReference = this.getUrlPathReference(file2.findElementAt(caretModel.getOffset()));
        if (urlPathReference != null) {
            UrlPathReferenceUnifiedPomTarget urlPathReferenceUnifiedPomTarget = urlPathReference.getUnifiedPomTarget();
            if (urlPathReferenceUnifiedPomTarget == null || (urlPathReferenceUnifiedPomTarget = urlPathReferenceUnifiedPomTarget.getContext()) == null) {
                return;
            }
            UrlPathReferenceUnifiedPomTarget context = urlPathReferenceUnifiedPomTarget;
            list = HttpRequestMicroservicesUtil.generationRequestsFromUrlPathContext(project, (UrlPathContext)context);
        } else {
            CaretModel caretModel2 = editor.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel2, (String)"editor.caretModel");
            WebReference webReference = this.getWebReference(file2.findElementAt(caretModel2.getOffset()));
            if (webReference == null) {
                return;
            }
            WebReference webReference2 = webReference;
            String string = webReference2.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"webReference.url");
            list = OpenInHttpClientIntention.Companion.generationRequestsFromUrl(project, string);
        }
        List requestsInfo = list;
        Companion.generateRequests$intellij_restClient(requestsInfo, project, editor);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J7\u0010\u0005\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J*\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J.\u0010\u0014\u001a \u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0015\u0012\u0004\u0012\u00020\u00160\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0017\u001a\u00020\u0013*\b\u0012\u0004\u0012\u00020\u000b0\u0018H\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/httpClient/actions/microservices/OpenInHttpClientIntention$Companion;", "", "()V", "SEARCH_LIMIT", "", "generateRequests", "", "requestsInfo", "", "Lcom/intellij/httpClient/actions/generation/PartialResult;", "Lcom/intellij/httpClient/actions/generation/HttpRequestUrlsGenerationRequest;", "Lcom/intellij/httpClient/actions/generation/HttpRequestPresentableError;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "generateRequests$intellij_restClient", "generationRequestsFromUrl", "url", "", "parseWebReference", "Lkotlin/Triple;", "Lcom/intellij/httpClient/actions/microservices/OpenInHttpClientIntention$Companion$WebReferenceParseError;", "concatErrors", "", "WebReferenceParseError", "intellij.restClient"})
    public static final class Companion {
        public final void generateRequests$intellij_restClient(@NotNull List<? extends PartialResult<HttpRequestUrlsGenerationRequest, ? extends HttpRequestPresentableError>> requestsInfo, @NotNull Project project, @NotNull Editor editor) {
            Intrinsics.checkNotNullParameter(requestsInfo, (String)"requestsInfo");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            List<HttpRequestUrlsGenerationRequest> requests = PartialResultKt.unwrapSuccess((Iterable)requestsInfo);
            Collection collection = requests;
            boolean bl = false;
            if (!collection.isEmpty()) {
                new HttpRequestGenerationManager(project).generateRequestsInHttpEditor(requests);
            } else {
                String messageContent = this.concatErrors(PartialResultKt.unwrapErrors((Iterable)requestsInfo));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)messageContent, (String)RestClientBundle.message("http.request.open.in.http.client.intention.error.title", new Object[0]), null);
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final List<PartialResult<HttpRequestUrlsGenerationRequest, HttpRequestPresentableError>> generationRequestsFromUrl(Project project, String url) {
            PartialResult<Object, HttpRequestPresentableError> partialResult;
            PartialResult<Triple<String, String, String>, WebReferenceParseError> $this$flatMap$iv = this.parseWebReference(url);
            boolean $i$f$flatMap = false;
            PartialResult<Triple<String, String, String>, WebReferenceParseError> partialResult2 = $this$flatMap$iv;
            if (partialResult2 instanceof PartialResult.Success) {
                void authority;
                void scheme;
                Triple $dstr$scheme$authority$urlPath = (Triple)((PartialResult.Success)$this$flatMap$iv).getResult();
                boolean bl = false;
                String string = (String)$dstr$scheme$authority$urlPath.component1();
                String string2 = (String)$dstr$scheme$authority$urlPath.component2();
                String urlPath = (String)$dstr$scheme$authority$urlPath.component3();
                PartialResult<HttpRequestUrlPathInfo, HttpRequestUrlPathInfoError> $this$flatMap$iv2 = HttpRequestUrlPathInfo.Companion.create(project, urlPath, CollectionsKt.listOf((Object)"GET"));
                boolean $i$f$flatMap2 = false;
                PartialResult<HttpRequestUrlPathInfo, HttpRequestUrlPathInfoError> partialResult3 = $this$flatMap$iv2;
                if (partialResult3 instanceof PartialResult.Success) {
                    HttpRequestUrlPathInfo urlInfo = (HttpRequestUrlPathInfo)((PartialResult.Success)$this$flatMap$iv2).getResult();
                    boolean bl2 = false;
                    partialResult = HttpRequestUrlContextInfo.Companion.create(project, CollectionsKt.listOf((Object)scheme), CollectionsKt.listOf((Object)authority)).map((Function1)new Function1<HttpRequestUrlContextInfo, HttpRequestUrlsGenerationRequest>(urlInfo){
                        final /* synthetic */ HttpRequestUrlPathInfo $urlInfo;

                        @NotNull
                        public final HttpRequestUrlsGenerationRequest invoke(@NotNull HttpRequestUrlContextInfo context) {
                            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                            return new HttpRequestUrlsGenerationRequest(CollectionsKt.listOf((Object)this.$urlInfo), context);
                        }
                        {
                            this.$urlInfo = httpRequestUrlPathInfo;
                            super(1);
                        }
                    });
                } else if (partialResult3 instanceof PartialResult.PartialSuccess) {
                    HttpRequestUrlPathInfo urlInfo = (HttpRequestUrlPathInfo)((PartialResult.PartialSuccess)$this$flatMap$iv2).getResult();
                    boolean bl3 = false;
                    partialResult = HttpRequestUrlContextInfo.Companion.create(project, CollectionsKt.listOf((Object)scheme), CollectionsKt.listOf((Object)authority)).map((Function1)new /* invalid duplicate definition of identical inner class */);
                } else {
                    if (!(partialResult3 instanceof PartialResult.Error)) throw new NoWhenBranchMatchedException();
                    partialResult = $this$flatMap$iv2;
                }
            } else if (partialResult2 instanceof PartialResult.PartialSuccess) {
                Triple $dstr$scheme$authority$urlPath = (Triple)((PartialResult.PartialSuccess)$this$flatMap$iv).getResult();
                boolean bl = false;
                String scheme = (String)$dstr$scheme$authority$urlPath.component1();
                String authority = (String)$dstr$scheme$authority$urlPath.component2();
                String urlPath = (String)$dstr$scheme$authority$urlPath.component3();
                PartialResult<HttpRequestUrlPathInfo, HttpRequestUrlPathInfoError> $this$flatMap$iv3 = HttpRequestUrlPathInfo.Companion.create(project, urlPath, CollectionsKt.listOf((Object)"GET"));
                boolean $i$f$flatMap3 = false;
                PartialResult<HttpRequestUrlPathInfo, HttpRequestUrlPathInfoError> partialResult4 = $this$flatMap$iv3;
                if (partialResult4 instanceof PartialResult.Success) {
                    HttpRequestUrlPathInfo urlInfo = (HttpRequestUrlPathInfo)((PartialResult.Success)$this$flatMap$iv3).getResult();
                    boolean bl4 = false;
                    partialResult = HttpRequestUrlContextInfo.Companion.create(project, CollectionsKt.listOf((Object)scheme), CollectionsKt.listOf((Object)authority)).map((Function1)new /* invalid duplicate definition of identical inner class */);
                } else if (partialResult4 instanceof PartialResult.PartialSuccess) {
                    HttpRequestUrlPathInfo urlInfo = (HttpRequestUrlPathInfo)((PartialResult.PartialSuccess)$this$flatMap$iv3).getResult();
                    boolean bl5 = false;
                    partialResult = HttpRequestUrlContextInfo.Companion.create(project, CollectionsKt.listOf((Object)scheme), CollectionsKt.listOf((Object)authority)).map((Function1)new /* invalid duplicate definition of identical inner class */);
                } else {
                    if (!(partialResult4 instanceof PartialResult.Error)) throw new NoWhenBranchMatchedException();
                    partialResult = $this$flatMap$iv3;
                }
            } else {
                if (!(partialResult2 instanceof PartialResult.Error)) throw new NoWhenBranchMatchedException();
                partialResult = $this$flatMap$iv;
            }
            PartialResult<Triple<String, String, String>, WebReferenceParseError> generationRequest2 = partialResult;
            return CollectionsKt.listOf(generationRequest2);
        }

        private final PartialResult<Triple<String, String, String>, WebReferenceParseError> parseWebReference(String url) {
            Object v0;
            String it;
            block4: {
                Iterable $this$firstOrNull$iv = UrlConstants.HTTP_SCHEMES;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (String)element$iv;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)url, (String)it, (boolean)false, (int)2, null)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            String string = v0;
            if (string == null) {
                String string2 = RestClientBundle.message("http.request.open.in.http.client.intention.web.reference.scheme.error.message", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"RestClientBundle.message\u2026ce.scheme.error.message\")");
                return new PartialResult.Error<WebReferenceParseError>(new WebReferenceParseError(string2));
            }
            String scheme = string;
            String $i$f$firstOrNull = StringsKt.removePrefix((String)url, (CharSequence)scheme);
            boolean bl = false;
            boolean bl2 = false;
            it = $i$f$firstOrNull;
            boolean bl3 = false;
            CharSequence charSequence = it;
            boolean bl4 = false;
            String string3 = !(charSequence.length() == 0) ? $i$f$firstOrNull : null;
            if (string3 == null) {
                String string4 = RestClientBundle.message("http.request.open.in.http.client.intention.web.reference.authority.error.message", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"RestClientBundle.message\u2026authority.error.message\")");
                return new PartialResult.Error<WebReferenceParseError>(new WebReferenceParseError(string4));
            }
            String withoutPrefix = string3;
            List parsedWebReference = StringsKt.split$default((CharSequence)withoutPrefix, (String[])new String[]{"/"}, (boolean)false, (int)2, (int)2, null);
            Object e = parsedWebReference.get(0);
            String string5 = (String)CollectionsKt.getOrNull((List)parsedWebReference, (int)1);
            if (string5 == null) {
                string5 = "";
            }
            return new PartialResult.Success<Triple>(new Triple((Object)scheme, e, (Object)string5));
        }

        @NlsSafe
        private final String concatErrors(Iterable<? extends HttpRequestPresentableError> $this$concatErrors) {
            return CollectionsKt.joinToString$default($this$concatErrors, (CharSequence)"\n", null, null, (int)0, null, (Function1)concatErrors.1.INSTANCE, (int)30, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/httpClient/actions/microservices/OpenInHttpClientIntention$Companion$WebReferenceParseError;", "Lcom/intellij/httpClient/actions/generation/HttpRequestPresentableError;", "message", "", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "intellij.restClient"})
        private static final class WebReferenceParseError
        implements HttpRequestPresentableError {
            @NotNull
            private final String message;

            @Override
            @NotNull
            public String getMessage() {
                return this.message;
            }

            public WebReferenceParseError(@NotNull String message2) {
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                this.message = message2;
            }
        }
    }
}

