/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.HttpHost;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0003\t\n\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/httpClient/execution/SocksAwareConnectionManagerFactory;", "", "()V", "getConnectionManager", "Lorg/apache/http/conn/HttpClientConnectionManager;", "proxy", "Ljava/net/Proxy;", "sslContext", "Ljavax/net/ssl/SSLContext;", "FakeDnsResolver", "SocksPlainConnectionSocketFactory", "SocksSSLConnectionSocketFactory", "intellij.restClient"})
public final class SocksAwareConnectionManagerFactory {
    @NotNull
    public static final SocksAwareConnectionManagerFactory INSTANCE;

    @JvmStatic
    @NotNull
    public static final HttpClientConnectionManager getConnectionManager(@Nullable Proxy proxy, @NotNull SSLContext sslContext) {
        SSLConnectionSocketFactory sSLConnectionSocketFactory;
        PlainConnectionSocketFactory httpFactory;
        PlainConnectionSocketFactory plainConnectionSocketFactory;
        boolean notHasProxy;
        Intrinsics.checkNotNullParameter((Object)sslContext, (String)"sslContext");
        boolean bl = notHasProxy = proxy == null || proxy.type() != Proxy.Type.SOCKS;
        if (notHasProxy) {
            plainConnectionSocketFactory = new PlainConnectionSocketFactory();
        } else {
            Proxy proxy2 = proxy;
            Intrinsics.checkNotNull((Object)proxy2);
            plainConnectionSocketFactory = httpFactory = (PlainConnectionSocketFactory)new SocksPlainConnectionSocketFactory(proxy2);
        }
        if (notHasProxy) {
            sSLConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        } else {
            Proxy proxy3 = proxy;
            Intrinsics.checkNotNull((Object)proxy3);
            sSLConnectionSocketFactory = new SocksSSLConnectionSocketFactory(sslContext, proxy3);
        }
        SSLConnectionSocketFactory httpsFactory = sSLConnectionSocketFactory;
        Registry registry = RegistryBuilder.create().register("http", (Object)httpFactory).register("https", (Object)httpsFactory).build();
        return notHasProxy ? (HttpClientConnectionManager)new BasicHttpClientConnectionManager((Lookup)registry) : (HttpClientConnectionManager)new BasicHttpClientConnectionManager((Lookup)registry, null, null, (DnsResolver)new FakeDnsResolver());
    }

    private SocksAwareConnectionManagerFactory() {
    }

    static {
        SocksAwareConnectionManagerFactory socksAwareConnectionManagerFactory;
        INSTANCE = socksAwareConnectionManagerFactory = new SocksAwareConnectionManagerFactory();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J>\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/httpClient/execution/SocksAwareConnectionManagerFactory$SocksSSLConnectionSocketFactory;", "Lorg/apache/http/conn/ssl/SSLConnectionSocketFactory;", "sslContext", "Ljavax/net/ssl/SSLContext;", "proxy", "Ljava/net/Proxy;", "(Ljavax/net/ssl/SSLContext;Ljava/net/Proxy;)V", "getProxy", "()Ljava/net/Proxy;", "connectSocket", "Ljava/net/Socket;", "connectTimeout", "", "socket", "host", "Lorg/apache/http/HttpHost;", "remoteAddress", "Ljava/net/InetSocketAddress;", "localAddress", "context", "Lorg/apache/http/protocol/HttpContext;", "createSocket", "intellij.restClient"})
    private static final class SocksSSLConnectionSocketFactory
    extends SSLConnectionSocketFactory {
        @NotNull
        private final Proxy proxy;

        @NotNull
        public Socket createSocket(@NotNull HttpContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new Socket(this.proxy);
        }

        @NotNull
        public Socket connectSocket(int connectTimeout, @Nullable Socket socket, @NotNull HttpHost host, @NotNull InetSocketAddress remoteAddress, @Nullable InetSocketAddress localAddress, @Nullable HttpContext context) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)remoteAddress, (String)"remoteAddress");
            InetSocketAddress unresolvedRemote = InetSocketAddress.createUnresolved(host.getHostName(), remoteAddress.getPort());
            Socket socket2 = super.connectSocket(connectTimeout, socket, host, unresolvedRemote, localAddress, context);
            Intrinsics.checkNotNullExpressionValue((Object)socket2, (String)"super.connectSocket(conn\u2026e, localAddress, context)");
            return socket2;
        }

        @NotNull
        public final Proxy getProxy() {
            return this.proxy;
        }

        public SocksSSLConnectionSocketFactory(@NotNull SSLContext sslContext, @NotNull Proxy proxy) {
            Intrinsics.checkNotNullParameter((Object)sslContext, (String)"sslContext");
            Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
            super(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            this.proxy = proxy;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J>\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u0010\u0013\u001a\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/intellij/httpClient/execution/SocksAwareConnectionManagerFactory$SocksPlainConnectionSocketFactory;", "Lorg/apache/http/conn/socket/PlainConnectionSocketFactory;", "proxy", "Ljava/net/Proxy;", "(Ljava/net/Proxy;)V", "getProxy", "()Ljava/net/Proxy;", "connectSocket", "Ljava/net/Socket;", "connectTimeout", "", "socket", "host", "Lorg/apache/http/HttpHost;", "remoteAddress", "Ljava/net/InetSocketAddress;", "localAddress", "context", "Lorg/apache/http/protocol/HttpContext;", "createSocket", "intellij.restClient"})
    private static final class SocksPlainConnectionSocketFactory
    extends PlainConnectionSocketFactory {
        @NotNull
        private final Proxy proxy;

        @NotNull
        public Socket createSocket(@Nullable HttpContext context) {
            return new Socket(this.proxy);
        }

        @NotNull
        public Socket connectSocket(int connectTimeout, @Nullable Socket socket, @NotNull HttpHost host, @NotNull InetSocketAddress remoteAddress, @Nullable InetSocketAddress localAddress, @Nullable HttpContext context) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)remoteAddress, (String)"remoteAddress");
            InetSocketAddress unresolvedRemote = InetSocketAddress.createUnresolved(host.getHostName(), remoteAddress.getPort());
            Socket socket2 = super.connectSocket(connectTimeout, socket, host, unresolvedRemote, localAddress, context);
            Intrinsics.checkNotNullExpressionValue((Object)socket2, (String)"super.connectSocket(conn\u2026e, localAddress, context)");
            return socket2;
        }

        @NotNull
        public final Proxy getProxy() {
            return this.proxy;
        }

        public SocksPlainConnectionSocketFactory(@NotNull Proxy proxy) {
            Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
            this.proxy = proxy;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/httpClient/execution/SocksAwareConnectionManagerFactory$FakeDnsResolver;", "Lorg/apache/http/conn/DnsResolver;", "()V", "resolve", "", "Ljava/net/InetAddress;", "host", "", "(Ljava/lang/String;)[Ljava/net/InetAddress;", "intellij.restClient"})
    private static final class FakeDnsResolver
    implements DnsResolver {
        @NotNull
        public InetAddress[] resolve(@NotNull String host) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            InetAddress[] inetAddressArray = new InetAddress[1];
            InetAddress inetAddress = InetAddress.getByAddress(new byte[]{1, 1, 1, 1});
            Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"InetAddress.getByAddress(byteArrayOf(1, 1, 1, 1))");
            inetAddressArray[0] = inetAddress;
            return inetAddressArray;
        }
    }
}

