/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution.ssl;

import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.execution.ssl.HttpRequestSslConfigurationException;
import com.intellij.httpClient.execution.ssl.PemHelper;
import com.intellij.httpClient.execution.ssl.SslConfiguration;
import com.intellij.httpClient.execution.ssl.SslConfigurationContext;
import com.intellij.httpClient.execution.ssl.SslErrorDescriptor;
import com.intellij.httpClient.execution.ssl.SslFilesFormatGuessStrategy;
import com.intellij.openapi.diagnostic.Logger;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Path;
import java.security.PrivateKey;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.crypto.util.PrivateKeyInfoFactory;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0001\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bJ\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH$j\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0011"}, d2={"Lcom/intellij/httpClient/execution/ssl/PrivateKeyFormat;", "", "(Ljava/lang/String;I)V", "readKey", "Ljava/security/PrivateKey;", "path", "Ljava/nio/file/Path;", "passphrase", "", "context", "Lcom/intellij/httpClient/execution/ssl/SslConfigurationContext;", "readKey$intellij_restClient", "readKeyInfo", "Lorg/bouncycastle/asn1/pkcs/PrivateKeyInfo;", "PEM", "DER", "Companion", "intellij.restClient"})
public abstract class PrivateKeyFormat
extends Enum<PrivateKeyFormat> {
    public static final /* enum */ PrivateKeyFormat PEM;
    public static final /* enum */ PrivateKeyFormat DER;
    private static final /* synthetic */ PrivateKeyFormat[] $VALUES;
    @NotNull
    private static final String guessExplanation;
    @NotNull
    public static final Companion Companion;

    static {
        PrivateKeyFormat[] privateKeyFormatArray = new PrivateKeyFormat[2];
        PrivateKeyFormat[] privateKeyFormatArray2 = privateKeyFormatArray;
        privateKeyFormatArray[0] = PEM = new PEM("PEM", 0);
        privateKeyFormatArray[1] = DER = new DER("DER", 1);
        $VALUES = privateKeyFormatArray;
        Companion = new Companion(null);
        guessExplanation = ".pem, .key -> PEM; .der -> DER";
    }

    @NotNull
    protected abstract PrivateKeyInfo readKeyInfo(@NotNull Path var1, @Nullable String var2) throws IOException;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final PrivateKey readKey$intellij_restClient(@NotNull Path path, @Nullable String passphrase, @NotNull SslConfigurationContext context) throws HttpRequestSslConfigurationException {
        void $this$getOrRethrowSslException$iv;
        Object object;
        Object it2;
        boolean bl;
        PrivateKeyInfo privateKeyInfo;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean bl2 = false;
        try {
            object2 = Result.Companion;
            boolean bl3 = false;
            privateKeyInfo = this.readKeyInfo(path, passphrase);
            bl = false;
            object2 = Result.constructor-impl((Object)privateKeyInfo);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl4 = false;
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object object3 = object2;
        boolean bl5 = false;
        if (Result.isSuccess-impl((Object)object3)) {
            Object object4;
            privateKeyInfo = object3;
            bl = false;
            try {
                object4 = Result.Companion;
                Object object5 = privateKeyInfo;
                boolean bl6 = false;
                it2 = object5;
                boolean bl7 = false;
                object5 = new JcaPEMKeyConverter().getPrivateKey((PrivateKeyInfo)it2);
                bl6 = false;
                object4 = Result.constructor-impl((Object)object5);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                boolean it2 = false;
                object4 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object = object4;
        } else {
            object = Result.constructor-impl((Object)object3);
        }
        object3 = object;
        boolean $i$f$getOrRethrowSslException = false;
        privateKeyInfo = $this$getOrRethrowSslException$iv;
        bl = false;
        boolean bl8 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)privateKeyInfo);
        if (throwable != null) {
            HttpRequestSslConfigurationException httpRequestSslConfigurationException;
            Throwable it$iv = throwable;
            boolean bl9 = false;
            if (it$iv instanceof HttpRequestSslConfigurationException) {
                httpRequestSslConfigurationException = (HttpRequestSslConfigurationException)it$iv;
            } else {
                it2 = it$iv;
                boolean bl10 = false;
                String string = RestClientBundle.message("http.request.ssl.cannot.read.key.error", ((Throwable)it2).getLocalizedMessage());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RestClientBundle.message\u2026or\", it.localizedMessage)");
                String string2 = context.getErrorMessage(SslErrorDescriptor.KEY, string);
                Throwable throwable2 = it$iv;
                String string3 = string2;
                httpRequestSslConfigurationException = new HttpRequestSslConfigurationException(string3, throwable2);
            }
            HttpRequestSslConfigurationException exception$iv = httpRequestSslConfigurationException;
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(SslConfiguration.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.warn((Throwable)exception$iv);
            throw (Throwable)exception$iv;
        }
        return (PrivateKey)privateKeyInfo;
    }

    private PrivateKeyFormat() {
    }

    public /* synthetic */ PrivateKeyFormat(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static PrivateKeyFormat[] values() {
        return (PrivateKeyFormat[])$VALUES.clone();
    }

    public static PrivateKeyFormat valueOf(String string) {
        return Enum.valueOf(PrivateKeyFormat.class, string);
    }

    @JvmStatic
    @Nullable
    public static PrivateKeyFormat guessFormat(@NotNull Path path) {
        return Companion.guessFormat(path);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0014\u00a8\u0006\b"}, d2={"Lcom/intellij/httpClient/execution/ssl/PrivateKeyFormat$PEM;", "Lcom/intellij/httpClient/execution/ssl/PrivateKeyFormat;", "readKeyInfo", "Lorg/bouncycastle/asn1/pkcs/PrivateKeyInfo;", "path", "Ljava/nio/file/Path;", "passphrase", "", "intellij.restClient"})
    static final class PEM
    extends PrivateKeyFormat {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        protected PrivateKeyInfo readKeyInfo(@NotNull Path path, @Nullable String passphrase) throws IOException {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Closeable closeable = (Closeable)new PEMParser((Reader)new FileReader(path.toFile()));
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                PEMParser pemParser = (PEMParser)closeable;
                boolean bl3 = false;
                Object keyObject = pemParser.readObject();
                boolean bl4 = PemHelper.INSTANCE.isKey(keyObject);
                boolean bl5 = false;
                boolean bl6 = false;
                if (!bl4) {
                    boolean bl7 = false;
                    String string = RestClientBundle.message("http.request.ssl.no.key.in.file.error", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RestClientBundle.message\u2026sl.no.key.in.file.error\")");
                    String string2 = string;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                PrivateKeyInfo privateKeyInfo = PemHelper.INSTANCE.readKey(keyObject, passphrase);
                return privateKeyInfo;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        /*
         * WARNING - void declaration
         */
        PEM() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0014\u00a8\u0006\b"}, d2={"Lcom/intellij/httpClient/execution/ssl/PrivateKeyFormat$DER;", "Lcom/intellij/httpClient/execution/ssl/PrivateKeyFormat;", "readKeyInfo", "Lorg/bouncycastle/asn1/pkcs/PrivateKeyInfo;", "path", "Ljava/nio/file/Path;", "passphrase", "", "intellij.restClient"})
    static final class DER
    extends PrivateKeyFormat {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        protected PrivateKeyInfo readKeyInfo(@NotNull Path path, @Nullable String passphrase) throws IOException {
            PrivateKeyInfo privateKeyInfo;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Closeable closeable = new FileInputStream(path.toFile());
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                FileInputStream stream = (FileInputStream)closeable;
                boolean bl3 = false;
                AsymmetricKeyParameter asymmetricKeyParameter = PrivateKeyFactory.createKey((InputStream)stream);
                PrivateKeyInfo privateKeyInfo2 = PrivateKeyInfoFactory.createPrivateKeyInfo((AsymmetricKeyParameter)asymmetricKeyParameter);
                privateKeyInfo = privateKeyInfo2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Intrinsics.checkNotNullExpressionValue((Object)privateKeyInfo, (String)"FileInputStream(path.toF\u2026tricKeyParameter)\n      }");
            return privateKeyInfo;
        }

        /*
         * WARNING - void declaration
         */
        DER() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\nH\u0017R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/intellij/httpClient/execution/ssl/PrivateKeyFormat$Companion;", "Lcom/intellij/httpClient/execution/ssl/SslFilesFormatGuessStrategy;", "Lcom/intellij/httpClient/execution/ssl/PrivateKeyFormat;", "()V", "guessExplanation", "", "getGuessExplanation", "()Ljava/lang/String;", "guessFormat", "path", "Ljava/nio/file/Path;", "intellij.restClient"})
    public static final class Companion
    implements SslFilesFormatGuessStrategy<PrivateKeyFormat> {
        /*
         * Unable to fully structure code
         */
        @Override
        @JvmStatic
        @Nullable
        public PrivateKeyFormat guessFormat(@NotNull Path path) {
            block5: {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                var2_2 = PathsKt.getExtension((Path)path);
                switch (var2_2.hashCode()) {
                    case 99345: {
                        if (!var2_2.equals("der")) ** break;
                        break;
                    }
                    case 110872: {
                        if (!var2_2.equals("pem")) ** break;
                        ** GOTO lbl12
                    }
                    case 106079: {
                        if (!var2_2.equals("key")) ** break;
lbl12:
                        // 2 sources

                        v0 = PrivateKeyFormat.PEM;
                        break block5;
                    }
                }
                v0 = PrivateKeyFormat.DER;
                break block5;
                v0 = null;
            }
            return v0;
        }

        @Override
        @NotNull
        public String getGuessExplanation() {
            return guessExplanation;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

