/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.security;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0010\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/httpClient/http/security/Http2HttpsQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "intellij.restClient"})
public class Http2HttpsQuickFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        String string = RestClientBundle.message("intention.family.name.change.prefix.to.https", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RestClientBundle.message\u2026.change.prefix.to.https\")");
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = descriptor.getPsiElement();
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)psiElement);
        if (manipulator == null) {
            Logger logger = Logger.getInstance(Http2HttpsQuickFix.class);
            StringBuilder stringBuilder = new StringBuilder().append("No Manipulator for ").append(psiElement).append(", language:");
            PsiElement psiElement2 = psiElement;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"psiElement");
            logger.warn(stringBuilder.append(psiElement2.getLanguage()).toString());
            return;
        }
        TextRange textRange = descriptor.getTextRangeInElement();
        if (textRange != null) {
            ElementManipulators.handleContentChange((PsiElement)psiElement, (TextRange)descriptor.getTextRangeInElement(), (String)"https://");
        } else {
            Logger.getInstance(Http2HttpsQuickFix.class).warn("No provided textRange for schema in " + psiElement);
            PsiElement psiElement3 = psiElement;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"psiElement");
            String string = psiElement3.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"psiElement.text");
            String replace2 = StringsKt.replaceFirst$default((String)string, (String)"http://", (String)"https://", (boolean)false, (int)4, null);
            ElementManipulators.handleContentChange((PsiElement)psiElement, (String)replace2);
        }
    }
}

