/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.text.StringKt;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchainsUtil;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.toolchains.CidrExecutableTool;
import java.io.File;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/Make;", "Lcom/jetbrains/cidr/toolchains/CidrExecutableTool;", "executable", "Ljava/io/File;", "environment", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "(Ljava/io/File;Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;)V", "toolSet", "Lcom/jetbrains/cidr/cpp/toolchains/CPPToolSet;", "Lorg/jetbrains/annotations/NotNull;", "readToolVersion", "Lcom/jetbrains/cidr/ToolVersion;", "readVersion", "", "intellij.cidr.toolchains"})
public final class Make
extends CidrExecutableTool {
    private final CPPToolSet toolSet;
    private final CPPEnvironment environment;

    @Override
    @Nullable
    public String readVersion() {
        String string;
        GeneralCommandLine commandLine = new GeneralCommandLine();
        try {
            this.toolSet.prepareEnvironment(commandLine, CidrToolEnvironment.PrepareFor.BUILD, CollectionsKt.emptyList());
        }
        catch (ExecutionException e) {
            return null;
        }
        File file = this.myExecutable;
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"myExecutable");
        commandLine.setExePath(file.getPath());
        commandLine.addParameter("--version");
        try {
            HostMachine hostMachine = this.environment.getHostMachine();
            Intrinsics.checkNotNullExpressionValue((Object)hostMachine, (String)"environment.hostMachine");
            HostMachine host = hostMachine;
            ProcessOutput processOutput = host.runProcess(commandLine, 10000);
            Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"host.runProcess(commandL\u2026til.READ_VERSION_TIMEOUT)");
            ProcessOutput output = processOutput;
            String string2 = output.getStdout();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"output.stdout");
            string = StringKt.nullize((String)((String)CollectionsKt.firstOrNull((List)StringsKt.lines((CharSequence)string2))), (boolean)true);
        }
        catch (ExecutionException ignored) {
            string = null;
        }
        String result = string;
        Logger logger = CPPLog.LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"CPPLog.LOG");
        if (logger.isDebugEnabled()) {
            CPPLog.logReadVersion("Make", this.myExecutable, result);
        }
        return result;
    }

    @Override
    @Nullable
    public ToolVersion readToolVersion() {
        ToolVersion toolVersion;
        String string = this.readVersion();
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            toolVersion = ToolVersion.parse((String)it, (Pattern[])new Pattern[]{CPPToolchainsUtil.VERSION_PATTERN});
        } else {
            toolVersion = null;
        }
        return toolVersion;
    }

    public Make(@NotNull File executable, @NotNull CPPEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
        super(executable);
        this.environment = environment;
        CPPToolSet cPPToolSet = this.environment.getToolSet();
        Intrinsics.checkNotNullExpressionValue((Object)cPPToolSet, (String)"environment.toolSet");
        this.toolSet = cPPToolSet;
    }
}

