/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.cidr.CidrExecutionBundle;
import com.jetbrains.cidr.execution.BuildConfigurationProblems;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BuildTargetAndConfigurationData {
    @Nullable
    public final BuildTargetData target;
    @Nullable
    public final String configurationName;

    public BuildTargetAndConfigurationData(@Nullable BuildTargetData target, @Nullable String configurationName) {
        this.target = target;
        this.configurationName = configurationName;
    }

    public BuildTargetAndConfigurationData(@Nullable String projectName, @Nullable String targetName, @Nullable String configurationName) {
        this(projectName == null || targetName == null ? null : new BuildTargetData(projectName, targetName), configurationName);
    }

    public BuildTargetAndConfigurationData(@Nullable CidrBuildTarget<?> target, @Nullable String configurationName) {
        this(target == null ? null : target.getProjectName(), target == null ? null : target.getName(), configurationName);
    }

    public BuildTargetAndConfigurationData(@Nullable CidrBuildTarget<?> target, @Nullable CidrBuildConfiguration configuration) {
        this(target, configuration == null ? null : configuration.getName());
    }

    public BuildTargetAndConfigurationData() {
        this(null, null, null);
    }

    public String toString() {
        return this.getDisplayString();
    }

    @NotNull
    public String getDisplayString() {
        return BuildTargetAndConfigurationData.formatDisplayString(this.target == null ? null : this.target.projectName, this.target == null ? null : this.target.targetName, this.configurationName);
    }

    @Contract(value="_, null, _ -> false")
    public static boolean checkData(@NotNull CidrBuildConfigurationHelper<?, ?> helper, @Nullable BuildTargetAndConfigurationData data, @Nullable BuildConfigurationProblems problems) {
        if (helper == null) {
            BuildTargetAndConfigurationData.$$$reportNull$$$0(0);
        }
        return BuildTargetAndConfigurationData.checkData(helper, data, problems, false, false);
    }

    @Contract(value="_, null, _, false, _ -> false; _, null, _, _, false -> false")
    public static boolean checkData(@NotNull CidrBuildConfigurationHelper<?, ?> helper, @Nullable BuildTargetAndConfigurationData data, @Nullable BuildConfigurationProblems problems, boolean allowEmptyTarget, boolean allowEmptyConfiguration) {
        String configurationName;
        if (helper == null) {
            BuildTargetAndConfigurationData.$$$reportNull$$$0(1);
        }
        BuildTargetData target = data != null ? data.target : null;
        String string = configurationName = data != null ? data.configurationName : null;
        if (problems != null) {
            problems.title = CidrExecutionBundle.message("build.configuration.invalid", new Object[0]);
        }
        if (target == null && !allowEmptyTarget || configurationName == null && !allowEmptyConfiguration) {
            if (problems != null) {
                if (target == null && !allowEmptyTarget) {
                    problems.problems.add(CidrExecutionBundle.message("build.configuration.parameterNotSelected", helper.getTargetTitle()));
                }
                if (configurationName == null && !allowEmptyConfiguration) {
                    problems.problems.add(CidrExecutionBundle.message("build.configuration.parameterNotSelected", helper.getConfigurationTitle()));
                }
            }
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildTargetAndConfigurationData that = (BuildTargetAndConfigurationData)o;
        if (!Objects.equals(this.target, that.target)) {
            return false;
        }
        return Objects.equals(this.configurationName, that.configurationName);
    }

    public int hashCode() {
        int result = this.target != null ? this.target.hashCode() : 0;
        result = 31 * result + (this.configurationName != null ? this.configurationName.hashCode() : 0);
        return result;
    }

    @NotNull
    @NlsSafe
    public static String formatDisplayString(@NlsSafe @Nullable String projectName, @NlsSafe @Nullable String targetName, @NlsSafe @Nullable String configName) {
        String string = BuildTargetAndConfigurationData.formatDisplayString(projectName, targetName) + " - " + configName;
        if (string == null) {
            BuildTargetAndConfigurationData.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public static String formatDisplayString(@Nullable @NlsSafe String projectName, @Nullable @NlsSafe String targetName) {
        String string = targetName + " (" + projectName + ")";
        if (string == null) {
            BuildTargetAndConfigurationData.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/BuildTargetAndConfigurationData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/BuildTargetAndConfigurationData";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDisplayString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkData";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

