/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.util.PlatformUtils;
import java.awt.Component;
import java.io.File;
import java.nio.file.Path;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrLangUtil {
    public static boolean enableObjectiveCSettings() {
        return PlatformUtils.isAppCode();
    }

    @NotNull
    @NlsSafe
    public static String getOCLanguageDisplayName() {
        return CidrLangUtil.enableObjectiveCSettings() ? "C/C++/Objective-C" : "C/C++";
    }

    @NotNull
    public static HyperlinkLabel createLinkToConfigurable(@NotNull @NlsContexts.LinkLabel String hyperlinkText, final @NotNull Class<? extends Configurable> targetConfigurable, final @Nullable Predicate<? super Configurable> predicate, final @Nullable Consumer<? super Configurable> additionalConsumer) {
        if (hyperlinkText == null) {
            CidrLangUtil.$$$reportNull$$$0(0);
        }
        if (targetConfigurable == null) {
            CidrLangUtil.$$$reportNull$$$0(1);
        }
        final HyperlinkLabel hyperlinkLabel = new HyperlinkLabel(hyperlinkText);
        hyperlinkLabel.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)hyperlinkLabel);
                Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
                if (project != null) {
                    ShowSettingsUtil.getInstance().showSettingsDialog(project, c -> ConfigurableWrapper.cast((Class)targetConfigurable, (UnnamedConfigurable)c) != null && (predicate == null || predicate.test(c)), additionalConsumer);
                }
            }
        });
        HyperlinkLabel hyperlinkLabel2 = hyperlinkLabel;
        if (hyperlinkLabel2 == null) {
            CidrLangUtil.$$$reportNull$$$0(2);
        }
        return hyperlinkLabel2;
    }

    @NotNull
    @NlsSafe
    public static String getPrettyNameFromClassName(@NotNull Class<?> clazz) {
        if (clazz == null) {
            CidrLangUtil.$$$reportNull$$$0(3);
        }
        String className = clazz.getSimpleName();
        if (clazz.isAnonymousClass()) {
            className = clazz.getSuperclass().getSimpleName();
        }
        return CidrLangUtil.getPrettyNameFromClassName(className);
    }

    @NotNull
    public static String getPrettyNameFromClassName(@NotNull String className) {
        if (className == null) {
            CidrLangUtil.$$$reportNull$$$0(4);
        }
        StringBuilder result = new StringBuilder();
        className = StringUtil.trimStart((String)className, (String)"OC");
        className = StringUtil.trimEnd((String)className, (String)"Inspection");
        className = StringUtil.trimEnd((String)className, (String)"IntentionAction");
        for (String word : StringUtil.findMatches((String)className, (Pattern)Pattern.compile("([A-Z][a-z]*)"))) {
            if (result.length() > 0) {
                result.append(' ').append(StringUtil.decapitalize((String)word));
                continue;
            }
            result.append(word);
        }
        String string = result.toString();
        if (string == null) {
            CidrLangUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static void restartCodeAnalyzer() {
        Project[] openProjects;
        for (Project project : openProjects = ProjectManager.getInstance().getOpenProjects()) {
            if (!project.isInitialized() || project.isDisposed()) continue;
            DaemonCodeAnalyzerEx.getInstanceEx((Project)project).restart();
        }
    }

    @Nullable
    public static VirtualFile findBestFile(@NotNull Project project, @NotNull String path, int requestedLine, @NotNull Predicate<VirtualFile> fileAcceptor) {
        Document document;
        VirtualFile file;
        if (project == null) {
            CidrLangUtil.$$$reportNull$$$0(6);
        }
        if (path == null) {
            CidrLangUtil.$$$reportNull$$$0(7);
        }
        if (fileAcceptor == null) {
            CidrLangUtil.$$$reportNull$$$0(8);
        }
        long targetStamp = 0L;
        VirtualFile targetVirtualFile = null;
        for (VirtualFile file2 : LocalFileSystem.getInstance().findCachedFilesForPath(path)) {
            Document document2;
            if (!fileAcceptor.test(file2) || (document2 = FileDocumentManager.getInstance().getDocument(file2)) == null || requestedLine >= document2.getLineCount()) continue;
            if (targetVirtualFile == null) {
                targetVirtualFile = file2;
                targetStamp = document2.getModificationStamp();
                continue;
            }
            long curStamp = document2.getModificationStamp();
            if (curStamp <= targetStamp) continue;
            targetVirtualFile = file2;
            targetStamp = curStamp;
        }
        if (targetVirtualFile == null && (file = VfsUtil.findFile((Path)new File(path).toPath(), (boolean)false)) != null && (document = FileDocumentManager.getInstance().getDocument(file)) != null && requestedLine < document.getLineCount()) {
            targetVirtualFile = file;
        }
        return targetVirtualFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlinkText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetConfigurable";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/CidrLangUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileAcceptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/CidrLangUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createLinkToConfigurable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrettyNameFromClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createLinkToConfigurable";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPrettyNameFromClassName";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findBestFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

