/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.newFile;

import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.cidr.lang.CidrLangBundle;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCUsageTriggerCollector;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileLangBackendHandlerProvider;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileWithSelectedExtensionAction;
import com.jetbrains.cidr.lang.settings.FileExtensionPair;
import com.jetbrains.cidr.lang.settings.NamingConventionStyle;
import icons.CidrLangIcons;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNewCppClassAction
extends OCNewFileWithSelectedExtensionAction<MyCreateClassDialog> {
    protected static final String NAMESPACES_OPEN_PROPERTY = "NAMESPACES_OPEN";
    protected static final String NAMESPACES_CLOSE_PROPERTY = "NAMESPACES_CLOSE";
    @Nullable
    private String myNamespaceOpenText;
    @Nullable
    private String myNamespaceCloseText;

    public OCNewCppClassAction() {
        super((FileType)OCNewFileLangBackendHandlerProvider.getHandler().getFileType(), CidrLangBundle.message("create.cpp.class.title", new Object[0]), CidrLangBundle.message("create.cpp.class.description", new Object[0]), CidrLangIcons.CodeAssistantStruct);
    }

    public OCNewCppClassAction(@Nullable String namespaceOpenText, @Nullable String namespaceCloseText) {
        this();
        this.myNamespaceOpenText = namespaceOpenText;
        this.myNamespaceCloseText = namespaceCloseText;
    }

    @Override
    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName) {
        LOG.assertTrue(this.getState() != null, (Object)"state");
        LOG.assertTrue(selectedName != null, (Object)"name");
        MyCreateClassDialog dialog = (MyCreateClassDialog)((Object)this.getState().dialogPeer);
        FileExtensionPair extensionPair = dialog.myFileExtensionPair;
        LOG.assertTrue(extensionPair != null, (Object)"extension pair");
        return OCNewCppClassAction.getNewFileNames(selectedName, extensionPair, dialog.myHeaderOnly);
    }

    @Override
    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName, @NotNull PsiFile sampleFile) {
        if (sampleFile == null) {
            OCNewCppClassAction.$$$reportNull$$$0(0);
        }
        Couple<String> detectedEp = this.determineExtensions(sampleFile, null, null);
        FileExtensionPair extensionPair = null;
        for (FileExtensionPair ep : this.getExtensions(sampleFile.getProject())) {
            if (!ep.mySourceExt.equals(detectedEp.first) || !ep.myHeaderExt.equals(detectedEp.second)) continue;
            extensionPair = ep;
            break;
        }
        if (extensionPair == null) {
            extensionPair = new FileExtensionPair((String)detectedEp.first, (String)detectedEp.second, NamingConventionStyle.NONE);
        }
        LOG.assertTrue(selectedName != null, (Object)"name");
        return OCNewCppClassAction.getNewFileNames(selectedName, extensionPair, false);
    }

    @NotNull
    private static OCNewFileActionBase.NewFileNames getNewFileNames(@NotNull String selectedName, @NotNull FileExtensionPair extensionPair, boolean headerOnly) {
        if (selectedName == null) {
            OCNewCppClassAction.$$$reportNull$$$0(1);
        }
        if (extensionPair == null) {
            OCNewCppClassAction.$$$reportNull$$$0(2);
        }
        NamingConventionStyle convention = extensionPair.myFileNamingConvention;
        String name = convention.apply(selectedName);
        return new OCNewFileActionBase.NewFileNames(headerOnly ? null : name + "." + extensionPair.mySourceExt, name + "." + extensionPair.myHeaderExt);
    }

    @Override
    protected boolean isValidName(@NotNull String selectedName) {
        if (selectedName == null) {
            OCNewCppClassAction.$$$reportNull$$$0(3);
        }
        return StringUtil.isJavaIdentifier((String)selectedName);
    }

    @Override
    protected void setAdditionalProperties(Properties properties, String fileName, PsiFile sampleFile, Project project) {
        String headerName;
        if (this.getState() != null) {
            headerName = this.getNewFileNames(this.mySelectedName).getHeaderName();
        } else {
            assert (sampleFile != null);
            headerName = this.getNewFileNames(this.mySelectedName, sampleFile).getHeaderName();
        }
        properties.setProperty("HEADER_FILENAME", headerName);
        properties.setProperty(NAMESPACES_OPEN_PROPERTY, StringUtil.notNullize((String)this.myNamespaceOpenText));
        properties.setProperty(NAMESPACES_CLOSE_PROPERTY, StringUtil.notNullize((String)this.myNamespaceCloseText));
    }

    @Override
    protected String getFileTemplate(String fileName) {
        if (OCFileTypeHelpers.isSourceFile(fileName)) {
            return "C++ Class.cc";
        }
        if (OCFileTypeHelpers.isHeaderFile(fileName)) {
            return "C++ Class Header.h";
        }
        assert (false);
        return null;
    }

    @Override
    @NotNull
    protected MyCreateClassDialog createDialog(@NotNull @NlsContexts.Label String defaultName) {
        if (defaultName == null) {
            OCNewCppClassAction.$$$reportNull$$$0(4);
        }
        return new MyCreateClassDialog(defaultName);
    }

    @NotNull
    protected ImmutableList<FileExtensionPair> getExtensions(@NotNull Project project) {
        if (project == null) {
            OCNewCppClassAction.$$$reportNull$$$0(5);
        }
        List filtered = ContainerUtil.filter(super.getExtensions(project), pair -> OCNewFileLangBackendHandlerProvider.getHandler().isCppFileExtension("." + pair.mySourceExt, project));
        ImmutableList immutableList = ContainerUtil.immutableList((List)filtered);
        if (immutableList == null) {
            OCNewCppClassAction.$$$reportNull$$$0(6);
        }
        return immutableList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sampleFile";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPair";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/actions/newFile/OCNewCppClassAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/actions/newFile/OCNewCppClassAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNewFileNames";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createDialog";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getExtensions";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class MyCreateClassDialog
    extends OCNewFileWithSelectedExtensionAction.CreateFileDialog {
        boolean myHeaderOnly;

        public MyCreateClassDialog(String defaultName) {
            super(OCNewCppClassAction.this, CidrLangBundle.message("create.cpp.class.dialog.title", new Object[0]), defaultName);
        }

        @Override
        public void fillGenericControls(FormBuilder formBuilder) {
            super.fillGenericControls(formBuilder);
            NonFocusableCheckBox headerCheckBox = new NonFocusableCheckBox(CidrLangBundle.message("create.checkbox.cpp.class.header", new Object[0]));
            DialogUtil.registerMnemonic((AbstractButton)headerCheckBox, (char)'&');
            headerCheckBox.addItemListener(new ItemListener((JCheckBox)headerCheckBox){
                final /* synthetic */ JCheckBox val$headerCheckBox;
                {
                    this.val$headerCheckBox = jCheckBox;
                }

                @Override
                public void itemStateChanged(ItemEvent e) {
                    MyCreateClassDialog.this.myHeaderOnly = this.val$headerCheckBox.isSelected();
                    if (MyCreateClassDialog.this.myKindCombo != null) {
                        MyCreateClassDialog.this.reloadExtensions();
                    }
                    MyCreateClassDialog.this.validateOkAction();
                }
            });
            OCNewCppClassAction.this.addAuxAction(createdElements -> OCUsageTriggerCollector.logEvent("create.cpp.class", new FeatureUsageData().addData("header_only", this.myHeaderOnly)));
            formBuilder.addComponent((JComponent)headerCheckBox);
        }

        @Override
        @NotNull
        protected String getPresentableName(@NotNull FileExtensionPair pair) {
            if (pair == null) {
                MyCreateClassDialog.$$$reportNull$$$0(0);
            }
            Object name = this.myHeaderOnly ? "." + pair.myHeaderExt : super.getPresentableName(pair);
            NamingConventionStyle nc = pair.myFileNamingConvention;
            Object object = nc == NamingConventionStyle.NONE ? name : (String)name + "  [" + nc + "]";
            if (object == null) {
                MyCreateClassDialog.$$$reportNull$$$0(1);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pair";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/actions/newFile/OCNewCppClassAction$MyCreateClassDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/actions/newFile/OCNewCppClassAction$MyCreateClassDialog";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentableName";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

