/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetListener;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.cidr.lang.settings.OCResolveContextSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCRunConfigurationWithResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceListener;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackersImpl;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class OCWorkspaceRunConfigurationListener {
    private static volatile boolean ourDisableUpdatesInTests;
    @Nullable
    private volatile OCResolveConfiguration mySelectedResolveConfiguration;

    public OCWorkspaceRunConfigurationListener(@NotNull Project project) {
        if (project == null) {
            OCWorkspaceRunConfigurationListener.$$$reportNull$$$0(0);
        }
        ProjectUtil.runWhenProjectOpened((Project)project, () -> {
            OCWorkspaceRunConfigurationListener.updateSelectedConfiguration(project);
            OCWorkspaceRunConfigurationListener.listenChanges(project);
        });
    }

    private static void listenChanges(@NotNull Project project) {
        if (project == null) {
            OCWorkspaceRunConfigurationListener.$$$reportNull$$$0(1);
        }
        MessageBusConnection connection = project.getMessageBus().connect();
        class MyListener
        implements RunManagerListener,
        ExecutionTargetListener,
        OCWorkspaceListener {
            final AtomicInteger bulkUpdate = new AtomicInteger(0);
            final AtomicBoolean updateTarget = new AtomicBoolean();
            final AtomicBoolean isUpdating = new AtomicBoolean();
            final /* synthetic */ Project val$project;

            MyListener(Project project) {
                this.val$project = project;
            }

            public void beginUpdate() {
                this.bulkUpdate.incrementAndGet();
            }

            public void endUpdate() {
                if (this.bulkUpdate.decrementAndGet() == 0) {
                    this.doUpdate();
                }
            }

            public void runConfigurationSelected(@Nullable RunnerAndConfigurationSettings settings) {
                this.doUpdate();
            }

            public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    MyListener.$$$reportNull$$$0(0);
                }
                this.doUpdate();
            }

            public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    MyListener.$$$reportNull$$$0(1);
                }
                this.doUpdate();
            }

            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    MyListener.$$$reportNull$$$0(2);
                }
                this.doUpdate();
            }

            public void activeTargetChanged(@NotNull ExecutionTarget newTarget) {
                if (newTarget == null) {
                    MyListener.$$$reportNull$$$0(3);
                }
                this.doUpdate();
            }

            @Override
            public void workspaceChanged(@NotNull OCWorkspaceListener.OCWorkspaceEvent event) {
                if (event == null) {
                    MyListener.$$$reportNull$$$0(4);
                }
                if (event.resolveConfigurationsChanged() || event.clientVersionChanged()) {
                    this.updateTarget.set(true);
                    this.doUpdate();
                }
            }

            void doUpdate() {
                if (!ourDisableUpdatesInTests && this.bulkUpdate.get() == 0 && this.isUpdating.compareAndSet(false, true)) {
                    try {
                        if (this.updateTarget.getAndSet(false)) {
                            ExecutionTargetManager.getInstance((Project)this.val$project).update();
                        }
                        OCWorkspaceRunConfigurationListener.updateSelectedConfiguration(this.val$project);
                    }
                    finally {
                        this.isUpdating.set(false);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "settings";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newTarget";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/OCWorkspaceRunConfigurationListener$1MyListener";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationChanged";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "activeTargetChanged";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "workspaceChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        MyListener listener = new MyListener(project);
        connection.subscribe(RunManagerListener.TOPIC, (Object)listener);
        connection.subscribe(ExecutionTargetManager.TOPIC, (Object)listener);
        connection.subscribe(OCWorkspaceListener.TOPIC, (Object)listener);
    }

    private static void updateSelectedConfiguration(@NotNull Project project) {
        if (project == null) {
            OCWorkspaceRunConfigurationListener.$$$reportNull$$$0(2);
        }
        OCResolveConfiguration selectedResolveConfiguration = (OCResolveConfiguration)ReadAction.compute(() -> {
            RunnerAndConfigurationSettings settings = RunManager.getInstance((Project)project).getSelectedConfiguration();
            ExecutionTarget target = ExecutionTargetManager.getInstance((Project)project).getActiveTarget();
            if (settings != null && settings.getConfiguration() instanceof OCRunConfigurationWithResolveConfiguration) {
                return ((OCRunConfigurationWithResolveConfiguration)settings.getConfiguration()).getResolveConfiguration(target);
            }
            return null;
        });
        OCWorkspaceRunConfigurationListener.setSelectedResolveConfiguration(project, selectedResolveConfiguration);
    }

    @Nullable
    public static OCResolveConfiguration getSelectedResolveConfiguration(@NotNull Project project) {
        if (project == null) {
            OCWorkspaceRunConfigurationListener.$$$reportNull$$$0(3);
        }
        return project.isDefault() ? null : OCWorkspaceRunConfigurationListener.getInstance((Project)project).mySelectedResolveConfiguration;
    }

    public static void setSelectedResolveConfiguration(@NotNull Project project, @Nullable OCResolveConfiguration selectedResolveConfiguration) {
        if (project == null) {
            OCWorkspaceRunConfigurationListener.$$$reportNull$$$0(4);
        }
        if (project.isDefault()) {
            return;
        }
        OCWorkspaceRunConfigurationListener configurationListener = OCWorkspaceRunConfigurationListener.getInstance(project);
        if (!Objects.equals(configurationListener.mySelectedResolveConfiguration, selectedResolveConfiguration)) {
            OCResolveConfiguration old = configurationListener.mySelectedResolveConfiguration;
            configurationListener.mySelectedResolveConfiguration = selectedResolveConfiguration;
            ApplicationManager.getApplication().runWriteAction(() -> {
                OCWorkspaceModificationTrackersImpl trackers = (OCWorkspaceModificationTrackersImpl)OCWorkspace.getInstance(project).getModificationTrackers();
                trackers.fireSelectedResolveConfigurationChanged();
            });
            OCResolveContextSettings.getInstance(project).onRunConfigurationChanged(old, selectedResolveConfiguration);
        }
    }

    @NotNull
    private static OCWorkspaceRunConfigurationListener getInstance(@NotNull Project project) {
        if (project == null) {
            OCWorkspaceRunConfigurationListener.$$$reportNull$$$0(5);
        }
        OCWorkspaceRunConfigurationListener oCWorkspaceRunConfigurationListener = (OCWorkspaceRunConfigurationListener)project.getComponent(OCWorkspaceRunConfigurationListener.class);
        if (oCWorkspaceRunConfigurationListener == null) {
            OCWorkspaceRunConfigurationListener.$$$reportNull$$$0(6);
        }
        return oCWorkspaceRunConfigurationListener;
    }

    @TestOnly
    public static void setDisableUpdatesInTests(boolean value) {
        ourDisableUpdatesInTests = value;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/OCWorkspaceRunConfigurationListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/OCWorkspaceRunConfigurationListener";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "listenChanges";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateSelectedConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedResolveConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedResolveConfiguration";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

