/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.statistics;

import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.CidrRunConfigurationWithFrameworkInfo;
import gnu.trove.TObjectIntHashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrTestingFrameworkUsagesCollector
extends ProjectUsagesCollector {
    public static final String GROUP_ID = "cidr.testingFrameworks";

    protected boolean requiresReadAccess() {
        return true;
    }

    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project) {
        if (project == null) {
            CidrTestingFrameworkUsagesCollector.$$$reportNull$$$0(0);
        }
        TObjectIntHashMap data = new TObjectIntHashMap();
        List configurationsList = RunManager.getInstance((Project)project).getAllConfigurationsList();
        for (RunConfiguration runConfiguration : configurationsList) {
            ProgressManager.checkCanceled();
            String name = CidrTestingFrameworkUsagesCollector.getFrameworkId(runConfiguration);
            if (name == null) continue;
            if (!data.containsKey((Object)name)) {
                data.put((Object)name, 0);
            }
            data.increment((Object)name);
        }
        Set set = ContainerUtil.map2Set((Object[])data.keys(), o -> {
            String key = (String)o;
            FeatureUsageData eventData = new FeatureUsageData().addData("framework_id", key);
            return MetricEventFactoryKt.newCounterMetric((String)"test.run.configuration", (int)data.get((Object)key), (FeatureUsageData)eventData);
        });
        if (set == null) {
            CidrTestingFrameworkUsagesCollector.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Nullable
    public static String getFrameworkId(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            CidrTestingFrameworkUsagesCollector.$$$reportNull$$$0(2);
        }
        if (runConfiguration instanceof CidrRunConfigurationWithFrameworkInfo) {
            return ((CidrRunConfigurationWithFrameworkInfo)runConfiguration).getFrameworkId();
        }
        return null;
    }

    @NotNull
    public String getGroupId() {
        return GROUP_ID;
    }

    public int getVersion() {
        return 2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/statistics/CidrTestingFrameworkUsagesCollector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/statistics/CidrTestingFrameworkUsagesCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFrameworkId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

