/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.RSyncUtil;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.SshRemoteHostIdentificationHasChangedException;
import com.intellij.util.SystemProperties;
import com.jetbrains.cidr.cpp.ToolchainsBundle;
import com.jetbrains.cidr.system.RemoteHostUtil;
import com.jetbrains.cidr.system.RemoteUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class CidrRSyncUtil {
    @NotNull
    public static File rsyncDirToLocal(@NotNull RemoteCredentials credentials, @NotNull String remotePath, @NotNull String localPath, @NotNull ProgressIndicator progressIndicator) throws IOException {
        Comparable<File> comparable;
        Comparable<File> result;
        if (credentials == null) {
            CidrRSyncUtil.$$$reportNull$$$0(0);
        }
        if (remotePath == null) {
            CidrRSyncUtil.$$$reportNull$$$0(1);
        }
        if (localPath == null) {
            CidrRSyncUtil.$$$reportNull$$$0(2);
        }
        if (progressIndicator == null) {
            CidrRSyncUtil.$$$reportNull$$$0(3);
        }
        progressIndicator.checkCanceled();
        File logfile = FileUtil.createTempFile((String)"rsync_download", (String)".log");
        File fileListPath = null;
        if (RemoteUtil.isTextFilesSyncEnabled()) {
            fileListPath = FileUtil.createTempFile((String)"fileList", (String)".txt");
            result = RemoteUtil.filterTextFiles(credentials, remotePath, fileListPath.toPath());
            fileListPath = result == null ? null : result.toFile();
        }
        try {
            result = new File(localPath);
            if (RemoteHostUtil.LOG.isDebugEnabled()) {
                RemoteHostUtil.LOG.debug("RemoteHost: rsync directory: " + remotePath + " -> " + localPath);
            }
            RSyncUtil.downloadFolderWithRSync((String)localPath, (String)remotePath, (RemoteCredentials)credentials, (ProgressIndicator)progressIndicator, (File)fileListPath, (String)logfile.getPath());
            FileUtil.delete((File)logfile);
            Comparable<File> comparable2 = result;
            comparable = comparable2;
        }
        catch (SshRemoteHostIdentificationHasChangedException e) {
            RemoteHostUtil.LOG.info("rsync: remote host identification has changed");
            @NlsSafe String title = "rsync";
            RemoteUtil.NOTIFICATION_GROUP.createNotification("rsync", ToolchainsBundle.message("remote.rsync.fix.message", new Object[0]), NotificationType.ERROR).setSubtitle(e.getMessage()).addAction((AnAction)NotificationAction.createSimpleExpiring((String)ToolchainsBundle.message("remote.rsync.fix", new Object[0]), () -> ProcessIOExecutorService.INSTANCE.execute(() -> {
                GeneralCommandLine cmd = new GeneralCommandLine(new String[]{"ssh-keygen"});
                cmd.addParameters(new String[]{"-f", SystemProperties.getUserHome() + "/.ssh/known_hosts"});
                cmd.addParameters(new String[]{"-R", "[" + credentials.getHost() + "]:" + credentials.getPort()});
                try {
                    ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)cmd, (int)RemoteHostUtil.DEFAULT_COMMAND_TIMEOUT);
                    output.checkSuccess(RemoteHostUtil.LOG);
                }
                catch (ExecutionException ex) {
                    RemoteHostUtil.LOG.error("ERROR: " + cmd.getCommandLineString(), (Throwable)ex);
                }
            }))).addAction((AnAction)NotificationAction.createSimple((String)SshBundle.message((String)"notification.Anonymous.text.log.file", (Object[])new Object[0]), () -> RevealFileAction.openFile((File)logfile))).notify(null);
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            RemoteHostUtil.LOG.error("rsync directory failed: remote (" + remotePath + ") -> local (" + localPath + ")");
            throw new IOException(e);
        }
        finally {
            if (fileListPath != null) {
                FileUtil.delete((File)fileListPath);
            }
        }
        if (comparable == null) {
            CidrRSyncUtil.$$$reportNull$$$0(4);
        }
        return comparable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/system/CidrRSyncUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/system/CidrRSyncUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "rsyncDirToLocal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "rsyncDirToLocal";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

