/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.speller;

import com.intellij.grazie.speller.GrazieSpeller;
import com.intellij.grazie.speller.Speller;
import com.intellij.grazie.speller.dictionary.Dictionary;
import com.intellij.grazie.speller.dictionary.transformation.TransformedDictionary;
import com.intellij.grazie.speller.dictionary.transformation.WordTransformation;
import com.intellij.grazie.speller.language.English;
import com.intellij.grazie.speller.rule.Rule;
import com.intellij.grazie.speller.suggestion.filter.SuggestionFilter;
import com.intellij.grazie.speller.suggestion.ranker.SuggestionRanker;
import com.intellij.grazie.speller.utils.DictionaryResources;
import com.intellij.grazie.speller.utils.UtilsKt;
import com.intellij.grazie.speller.utils.aligner.SuggestionAligner;
import com.intellij.grazie.speller.utils.spitter.CamelCaseSplitter;
import com.intellij.grazie.speller.utils.spitter.Splitter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0010B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J$\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J$\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/grazie/speller/GrazieSpeller;", "Lcom/intellij/grazie/speller/Speller;", "config", "Lcom/intellij/grazie/speller/GrazieSpeller$UserConfig;", "(Lcom/intellij/grazie/speller/GrazieSpeller$UserConfig;)V", "isAlien", "", "word", "", "isMisspelled", "mySuggestAndRank", "", "", "max", "", "suggestAndRank", "UserConfig", "spellchecker"})
public final class GrazieSpeller
implements Speller {
    private final UserConfig config;

    @Override
    public boolean isMisspelled(@NotNull String word) {
        Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
        if (word.length() < this.config.getMinSize()) {
            return false;
        }
        return !this.config.getDictionaries().getSuggested().contains(word) && !this.config.getDictionaries().getIgnored().contains(word) && !this.config.getDictionaries().getExcluded().contains(word);
    }

    @Override
    public boolean isAlien(@NotNull String word) {
        Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
        return this.config.getDictionaries().getSuggested().isAlien(word) && this.config.getDictionaries().getIgnored().isAlien(word) && this.config.getDictionaries().getExcluded().isAlien(word);
    }

    @Override
    @NotNull
    public Map<String, Double> suggestAndRank(@NotNull String word, int max) {
        Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
        String normalized = this.config.getModel().getAligner().normalize(word);
        if (Intrinsics.areEqual((Object)normalized, (Object)word)) {
            return this.config.getModel().getAligner().align(word, this.mySuggestAndRank(word, max));
        }
        Map<String, Double> wordResult = this.mySuggestAndRank(word, max);
        Map<String, Double> normalizedResult = this.mySuggestAndRank(normalized, max);
        Map<String, Double> map = UtilsKt.maxOf(wordResult, normalizedResult, suggestAndRank.1.INSTANCE);
        boolean bl = false;
        boolean bl2 = false;
        Map<String, Double> it = map;
        boolean bl3 = false;
        return this.config.getModel().getAligner().align(word, it);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Double> mySuggestAndRank(String word, int max) {
        Object object;
        Object object2;
        Iterator<Integer> $this$mapTo$iv$iv;
        boolean $i$f$mapTo2;
        Object destination$iv$iv;
        if (!this.isMisspelled(word)) {
            return MapsKt.emptyMap();
        }
        HashMap<void, Double> result = new HashMap<void, Double>();
        if (this.config.getModel().getRules().contains(word)) {
            Collection<Pair> collection;
            void $this$map$iv;
            Iterable iterable = this.config.getModel().getRules().suggest(word);
            HashMap<void, Double> hashMap = result;
            boolean $i$f$map = false;
            void var6_8 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo2 = false;
            object2 = $this$mapTo$iv$iv.iterator();
            while (object2.hasNext()) {
                void it;
                Object item$iv$iv = object2.next();
                object = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)it, (Object)1.0);
                collection.add(pair);
            }
            collection = (List)destination$iv$iv;
            hashMap.putAll(MapsKt.toMap((Iterable)collection));
        }
        Set<String> suggested2 = SetsKt.emptySet();
        $this$mapTo$iv$iv = this.config.getDistances().iterator();
        while ($this$mapTo$iv$iv.hasNext()) {
            int distance = ((Number)$this$mapTo$iv$iv.next()).intValue();
            suggested2 = this.config.getDictionaries().getSuggested().suggest(word, distance);
            destination$iv$iv = suggested2;
            $i$f$mapTo2 = false;
            if (!(!destination$iv$iv.isEmpty())) continue;
            break;
        }
        Map<String, Double> ranked = this.config.getModel().getRanker().score(word, suggested2);
        Map<String, Double> filtered2 = this.config.getModel().getFilter().filter(ranked);
        Object $this$sortedByDescending$iv = filtered2.entrySet();
        boolean $i$f$sortedByDescending = false;
        object = $this$sortedByDescending$iv;
        boolean bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Map.Entry it = (Map.Entry)b;
                boolean bl2 = false;
                Comparable comparable = Double.valueOf(((Number)it.getValue()).doubleValue());
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Double d = ((Number)it.getValue()).doubleValue();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d);
            }
        };
        Iterator $i$f$mapTo2 = CollectionsKt.sortedWith((Iterable)object, (Comparator)comparator).iterator();
        while ($i$f$mapTo2.hasNext()) {
            void key;
            Object object3 = destination$iv$iv = (Map.Entry)$i$f$mapTo2.next();
            boolean bl2 = false;
            $this$sortedByDescending$iv = (String)object3.getKey();
            object3 = destination$iv$iv;
            bl2 = false;
            double value = ((Number)object3.getValue()).doubleValue();
            result.putIfAbsent(key, value);
        }
        Set set = result.entrySet();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"result.entries");
        Iterable $this$sortedByDescending$iv2 = set;
        boolean $i$f$sortedByDescending2 = false;
        object2 = $this$sortedByDescending$iv2;
        boolean bl3 = false;
        object = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Map.Entry it = (Map.Entry)b;
                boolean bl2 = false;
                Comparable comparable = (Double)it.getValue();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Double d = (Double)it.getValue();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d);
            }
        };
        return UtilsKt.toMap(CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)object2, (Comparator)object), (int)max));
    }

    public GrazieSpeller(@NotNull UserConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.config = config;
    }

    public /* synthetic */ GrazieSpeller(UserConfig userConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            userConfig = new UserConfig(0, null, null, null, 15, null);
        }
        this(userConfig);
    }

    public GrazieSpeller() {
        this(null, 1, null);
    }

    @Override
    @NotNull
    public LinkedHashSet<String> suggest(@NotNull String word, int max) {
        Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
        return Speller.DefaultImpls.suggest(this, word, max);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB3\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J7\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lcom/intellij/grazie/speller/GrazieSpeller$UserConfig;", "", "minSize", "", "distances", "", "dictionaries", "Lcom/intellij/grazie/speller/GrazieSpeller$UserConfig$Dictionaries;", "model", "Lcom/intellij/grazie/speller/GrazieSpeller$UserConfig$Model;", "(ILjava/util/Set;Lcom/intellij/grazie/speller/GrazieSpeller$UserConfig$Dictionaries;Lcom/intellij/grazie/speller/GrazieSpeller$UserConfig$Model;)V", "getDictionaries", "()Lcom/intellij/grazie/speller/GrazieSpeller$UserConfig$Dictionaries;", "getDistances", "()Ljava/util/Set;", "getMinSize", "()I", "getModel", "()Lcom/intellij/grazie/speller/GrazieSpeller$UserConfig$Model;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "Dictionaries", "Model", "spellchecker"})
    public static final class UserConfig {
        private final int minSize;
        @NotNull
        private final Set<Integer> distances;
        @NotNull
        private final Dictionaries dictionaries;
        @NotNull
        private final Model model;

        public final int getMinSize() {
            return this.minSize;
        }

        @NotNull
        public final Set<Integer> getDistances() {
            return this.distances;
        }

        @NotNull
        public final Dictionaries getDictionaries() {
            return this.dictionaries;
        }

        @NotNull
        public final Model getModel() {
            return this.model;
        }

        public UserConfig(int minSize, @NotNull Set<Integer> distances, @NotNull Dictionaries dictionaries, @NotNull Model model) {
            Intrinsics.checkParameterIsNotNull(distances, (String)"distances");
            Intrinsics.checkParameterIsNotNull((Object)dictionaries, (String)"dictionaries");
            Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
            this.minSize = minSize;
            this.distances = distances;
            this.dictionaries = dictionaries;
            this.model = model;
        }

        public /* synthetic */ UserConfig(int n, Set set, Dictionaries dictionaries, Model model, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 4;
            }
            if ((n2 & 2) != 0) {
                set = SetsKt.setOf((Object[])new Integer[]{3, 4, 5, 6});
            }
            if ((n2 & 4) != 0) {
                dictionaries = new Dictionaries(null, null, null, null, null, 31, null);
            }
            if ((n2 & 8) != 0) {
                model = new Model(null, null, null, null, 15, null);
            }
            this(n, set, dictionaries, model);
        }

        public UserConfig() {
            this(0, null, null, null, 15, null);
        }

        public final int component1() {
            return this.minSize;
        }

        @NotNull
        public final Set<Integer> component2() {
            return this.distances;
        }

        @NotNull
        public final Dictionaries component3() {
            return this.dictionaries;
        }

        @NotNull
        public final Model component4() {
            return this.model;
        }

        @NotNull
        public final UserConfig copy(int minSize, @NotNull Set<Integer> distances, @NotNull Dictionaries dictionaries, @NotNull Model model) {
            Intrinsics.checkParameterIsNotNull(distances, (String)"distances");
            Intrinsics.checkParameterIsNotNull((Object)dictionaries, (String)"dictionaries");
            Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
            return new UserConfig(minSize, distances, dictionaries, model);
        }

        public static /* synthetic */ UserConfig copy$default(UserConfig userConfig, int n, Set set, Dictionaries dictionaries, Model model, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = userConfig.minSize;
            }
            if ((n2 & 2) != 0) {
                set = userConfig.distances;
            }
            if ((n2 & 4) != 0) {
                dictionaries = userConfig.dictionaries;
            }
            if ((n2 & 8) != 0) {
                model = userConfig.model;
            }
            return userConfig.copy(n, set, dictionaries, model);
        }

        @NotNull
        public String toString() {
            return "UserConfig(minSize=" + this.minSize + ", distances=" + this.distances + ", dictionaries=" + this.dictionaries + ", model=" + this.model + ")";
        }

        public int hashCode() {
            Set<Integer> set = this.distances;
            Dictionaries dictionaries = this.dictionaries;
            Model model = this.model;
            return ((Integer.hashCode(this.minSize) * 31 + (set != null ? ((Object)set).hashCode() : 0)) * 31 + (dictionaries != null ? ((Object)dictionaries).hashCode() : 0)) * 31 + (model != null ? ((Object)model).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof UserConfig)) break block3;
                    UserConfig userConfig = (UserConfig)object;
                    if (this.minSize != userConfig.minSize || !Intrinsics.areEqual(this.distances, userConfig.distances) || !Intrinsics.areEqual((Object)this.dictionaries, (Object)userConfig.dictionaries) || !Intrinsics.areEqual((Object)this.model, (Object)userConfig.model)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/intellij/grazie/speller/GrazieSpeller$UserConfig$Model;", "", "rules", "Lcom/intellij/grazie/speller/rule/Rule;", "filter", "Lcom/intellij/grazie/speller/suggestion/filter/SuggestionFilter;", "ranker", "Lcom/intellij/grazie/speller/suggestion/ranker/SuggestionRanker;", "aligner", "Lcom/intellij/grazie/speller/utils/aligner/SuggestionAligner;", "(Lcom/intellij/grazie/speller/rule/Rule;Lcom/intellij/grazie/speller/suggestion/filter/SuggestionFilter;Lcom/intellij/grazie/speller/suggestion/ranker/SuggestionRanker;Lcom/intellij/grazie/speller/utils/aligner/SuggestionAligner;)V", "getAligner", "()Lcom/intellij/grazie/speller/utils/aligner/SuggestionAligner;", "getFilter", "()Lcom/intellij/grazie/speller/suggestion/filter/SuggestionFilter;", "getRanker", "()Lcom/intellij/grazie/speller/suggestion/ranker/SuggestionRanker;", "getRules", "()Lcom/intellij/grazie/speller/rule/Rule;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "spellchecker"})
        public static final class Model {
            @NotNull
            private final Rule rules;
            @NotNull
            private final SuggestionFilter filter;
            @NotNull
            private final SuggestionRanker ranker;
            @NotNull
            private final SuggestionAligner aligner;

            @NotNull
            public final Rule getRules() {
                return this.rules;
            }

            @NotNull
            public final SuggestionFilter getFilter() {
                return this.filter;
            }

            @NotNull
            public final SuggestionRanker getRanker() {
                return this.ranker;
            }

            @NotNull
            public final SuggestionAligner getAligner() {
                return this.aligner;
            }

            public Model(@NotNull Rule rules2, @NotNull SuggestionFilter filter, @NotNull SuggestionRanker ranker, @NotNull SuggestionAligner aligner) {
                Intrinsics.checkParameterIsNotNull((Object)rules2, (String)"rules");
                Intrinsics.checkParameterIsNotNull((Object)filter, (String)"filter");
                Intrinsics.checkParameterIsNotNull((Object)ranker, (String)"ranker");
                Intrinsics.checkParameterIsNotNull((Object)aligner, (String)"aligner");
                this.rules = rules2;
                this.filter = filter;
                this.ranker = ranker;
                this.aligner = aligner;
            }

            public /* synthetic */ Model(Rule rule, SuggestionFilter suggestionFilter, SuggestionRanker suggestionRanker, SuggestionAligner suggestionAligner, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    rule = English.Rules.INSTANCE.getReplacing();
                }
                if ((n & 2) != 0) {
                    suggestionFilter = English.Filter.INSTANCE.getSpeller();
                }
                if ((n & 4) != 0) {
                    suggestionRanker = English.Ranker.INSTANCE.getSpeller();
                }
                if ((n & 8) != 0) {
                    suggestionAligner = English.Utils.INSTANCE.getAligner();
                }
                this(rule, suggestionFilter, suggestionRanker, suggestionAligner);
            }

            public Model() {
                this(null, null, null, null, 15, null);
            }

            @NotNull
            public final Rule component1() {
                return this.rules;
            }

            @NotNull
            public final SuggestionFilter component2() {
                return this.filter;
            }

            @NotNull
            public final SuggestionRanker component3() {
                return this.ranker;
            }

            @NotNull
            public final SuggestionAligner component4() {
                return this.aligner;
            }

            @NotNull
            public final Model copy(@NotNull Rule rules2, @NotNull SuggestionFilter filter, @NotNull SuggestionRanker ranker, @NotNull SuggestionAligner aligner) {
                Intrinsics.checkParameterIsNotNull((Object)rules2, (String)"rules");
                Intrinsics.checkParameterIsNotNull((Object)filter, (String)"filter");
                Intrinsics.checkParameterIsNotNull((Object)ranker, (String)"ranker");
                Intrinsics.checkParameterIsNotNull((Object)aligner, (String)"aligner");
                return new Model(rules2, filter, ranker, aligner);
            }

            public static /* synthetic */ Model copy$default(Model model, Rule rule, SuggestionFilter suggestionFilter, SuggestionRanker suggestionRanker, SuggestionAligner suggestionAligner, int n, Object object) {
                if ((n & 1) != 0) {
                    rule = model.rules;
                }
                if ((n & 2) != 0) {
                    suggestionFilter = model.filter;
                }
                if ((n & 4) != 0) {
                    suggestionRanker = model.ranker;
                }
                if ((n & 8) != 0) {
                    suggestionAligner = model.aligner;
                }
                return model.copy(rule, suggestionFilter, suggestionRanker, suggestionAligner);
            }

            @NotNull
            public String toString() {
                return "Model(rules=" + this.rules + ", filter=" + this.filter + ", ranker=" + this.ranker + ", aligner=" + this.aligner + ")";
            }

            public int hashCode() {
                Rule rule = this.rules;
                SuggestionFilter suggestionFilter = this.filter;
                SuggestionRanker suggestionRanker = this.ranker;
                SuggestionAligner suggestionAligner = this.aligner;
                return (((rule != null ? rule.hashCode() : 0) * 31 + (suggestionFilter != null ? suggestionFilter.hashCode() : 0)) * 31 + (suggestionRanker != null ? suggestionRanker.hashCode() : 0)) * 31 + (suggestionAligner != null ? suggestionAligner.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Model)) break block3;
                        Model model = (Model)object;
                        if (!Intrinsics.areEqual((Object)this.rules, (Object)model.rules) || !Intrinsics.areEqual((Object)this.filter, (Object)model.filter) || !Intrinsics.areEqual((Object)this.ranker, (Object)model.ranker) || !Intrinsics.areEqual((Object)this.aligner, (Object)model.aligner)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J=\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lcom/intellij/grazie/speller/GrazieSpeller$UserConfig$Dictionaries;", "", "transformation", "Lcom/intellij/grazie/speller/dictionary/transformation/WordTransformation;", "splitter", "Lcom/intellij/grazie/speller/utils/spitter/Splitter;", "excluded", "Lcom/intellij/grazie/speller/dictionary/Dictionary;", "ignored", "suggested", "(Lcom/intellij/grazie/speller/dictionary/transformation/WordTransformation;Lcom/intellij/grazie/speller/utils/spitter/Splitter;Lcom/intellij/grazie/speller/dictionary/Dictionary;Lcom/intellij/grazie/speller/dictionary/Dictionary;Lcom/intellij/grazie/speller/dictionary/Dictionary;)V", "getExcluded", "()Lcom/intellij/grazie/speller/dictionary/Dictionary;", "getIgnored", "getSplitter", "()Lcom/intellij/grazie/speller/utils/spitter/Splitter;", "getSuggested", "getTransformation", "()Lcom/intellij/grazie/speller/dictionary/transformation/WordTransformation;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "", "spellchecker"})
        public static final class Dictionaries {
            @NotNull
            private final WordTransformation transformation;
            @Nullable
            private final Splitter splitter;
            @NotNull
            private final Dictionary excluded;
            @NotNull
            private final Dictionary ignored;
            @NotNull
            private final Dictionary suggested;

            @NotNull
            public final WordTransformation getTransformation() {
                return this.transformation;
            }

            @Nullable
            public final Splitter getSplitter() {
                return this.splitter;
            }

            @NotNull
            public final Dictionary getExcluded() {
                return this.excluded;
            }

            @NotNull
            public final Dictionary getIgnored() {
                return this.ignored;
            }

            @NotNull
            public final Dictionary getSuggested() {
                return this.suggested;
            }

            public Dictionaries(@NotNull WordTransformation transformation, @Nullable Splitter splitter, @NotNull Dictionary excluded2, @NotNull Dictionary ignored2, @NotNull Dictionary suggested2) {
                Intrinsics.checkParameterIsNotNull((Object)transformation, (String)"transformation");
                Intrinsics.checkParameterIsNotNull((Object)excluded2, (String)"excluded");
                Intrinsics.checkParameterIsNotNull((Object)ignored2, (String)"ignored");
                Intrinsics.checkParameterIsNotNull((Object)suggested2, (String)"suggested");
                this.transformation = transformation;
                this.splitter = splitter;
                this.excluded = excluded2;
                this.ignored = ignored2;
                this.suggested = suggested2;
            }

            public /* synthetic */ Dictionaries(WordTransformation wordTransformation, Splitter splitter, Dictionary dictionary, Dictionary dictionary2, Dictionary dictionary3, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    Locale locale = Locale.ENGLISH;
                    Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ENGLISH");
                    wordTransformation = new WordTransformation.LowerCase(locale);
                }
                if ((n & 2) != 0) {
                    splitter = CamelCaseSplitter.INSTANCE;
                }
                if ((n & 4) != 0) {
                    dictionary = DictionaryResources.getTransformingDictionary$default(DictionaryResources.INSTANCE, English.Lists.INSTANCE.getExcluded(), wordTransformation, null, 4, null);
                }
                if ((n & 8) != 0) {
                    dictionary2 = DictionaryResources.INSTANCE.getTransformingDictionary(English.Lists.INSTANCE.getIgnored(), wordTransformation, splitter);
                }
                if ((n & 0x10) != 0) {
                    dictionary3 = new Dictionary.Aggregated(new TransformedDictionary(English.Lists.INSTANCE.getSuggested(), wordTransformation), DictionaryResources.INSTANCE.getSplitsDictionary(English.Lists.INSTANCE.getSuggested(), wordTransformation, splitter));
                }
                this(wordTransformation, splitter, dictionary, dictionary2, dictionary3);
            }

            public Dictionaries() {
                this(null, null, null, null, null, 31, null);
            }

            @NotNull
            public final WordTransformation component1() {
                return this.transformation;
            }

            @Nullable
            public final Splitter component2() {
                return this.splitter;
            }

            @NotNull
            public final Dictionary component3() {
                return this.excluded;
            }

            @NotNull
            public final Dictionary component4() {
                return this.ignored;
            }

            @NotNull
            public final Dictionary component5() {
                return this.suggested;
            }

            @NotNull
            public final Dictionaries copy(@NotNull WordTransformation transformation, @Nullable Splitter splitter, @NotNull Dictionary excluded2, @NotNull Dictionary ignored2, @NotNull Dictionary suggested2) {
                Intrinsics.checkParameterIsNotNull((Object)transformation, (String)"transformation");
                Intrinsics.checkParameterIsNotNull((Object)excluded2, (String)"excluded");
                Intrinsics.checkParameterIsNotNull((Object)ignored2, (String)"ignored");
                Intrinsics.checkParameterIsNotNull((Object)suggested2, (String)"suggested");
                return new Dictionaries(transformation, splitter, excluded2, ignored2, suggested2);
            }

            public static /* synthetic */ Dictionaries copy$default(Dictionaries dictionaries, WordTransformation wordTransformation, Splitter splitter, Dictionary dictionary, Dictionary dictionary2, Dictionary dictionary3, int n, Object object) {
                if ((n & 1) != 0) {
                    wordTransformation = dictionaries.transformation;
                }
                if ((n & 2) != 0) {
                    splitter = dictionaries.splitter;
                }
                if ((n & 4) != 0) {
                    dictionary = dictionaries.excluded;
                }
                if ((n & 8) != 0) {
                    dictionary2 = dictionaries.ignored;
                }
                if ((n & 0x10) != 0) {
                    dictionary3 = dictionaries.suggested;
                }
                return dictionaries.copy(wordTransformation, splitter, dictionary, dictionary2, dictionary3);
            }

            @NotNull
            public String toString() {
                return "Dictionaries(transformation=" + this.transformation + ", splitter=" + this.splitter + ", excluded=" + this.excluded + ", ignored=" + this.ignored + ", suggested=" + this.suggested + ")";
            }

            public int hashCode() {
                WordTransformation wordTransformation = this.transformation;
                Splitter splitter = this.splitter;
                Dictionary dictionary = this.excluded;
                Dictionary dictionary2 = this.ignored;
                Dictionary dictionary3 = this.suggested;
                return ((((wordTransformation != null ? wordTransformation.hashCode() : 0) * 31 + (splitter != null ? splitter.hashCode() : 0)) * 31 + (dictionary != null ? dictionary.hashCode() : 0)) * 31 + (dictionary2 != null ? dictionary2.hashCode() : 0)) * 31 + (dictionary3 != null ? dictionary3.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Dictionaries)) break block3;
                        Dictionaries dictionaries = (Dictionaries)object;
                        if (!Intrinsics.areEqual((Object)this.transformation, (Object)dictionaries.transformation) || !Intrinsics.areEqual((Object)this.splitter, (Object)dictionaries.splitter) || !Intrinsics.areEqual((Object)this.excluded, (Object)dictionaries.excluded) || !Intrinsics.areEqual((Object)this.ignored, (Object)dictionaries.ignored) || !Intrinsics.areEqual((Object)this.suggested, (Object)dictionaries.suggested)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

