/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.clion.perf;

import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.CallTreeBuilder;
import com.intellij.profiler.DummyCallTreeBuilder;
import com.intellij.profiler.FileBasedProfilerProcess;
import com.intellij.profiler.LegacyBridgeProfilerConfiguration;
import com.intellij.profiler.ParserUtilKt;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.api.DataReady;
import com.intellij.profiler.api.NewCallTreeOnlyProfilerData;
import com.intellij.profiler.api.ProfilerData;
import com.intellij.profiler.api.ProfilerError;
import com.intellij.profiler.api.ProfilerState;
import com.intellij.profiler.api.ProfilerTargetProcess;
import com.intellij.profiler.clion.CPPProfilerBundleKt;
import com.intellij.profiler.clion.NativeTargetProcess;
import com.intellij.profiler.clion.perf.NavigatableNativeCall;
import com.intellij.profiler.clion.perf.PerfFrame;
import com.intellij.profiler.clion.perf.PerfNavigationMap;
import com.intellij.profiler.clion.perf.PerfProfilerProcess;
import com.intellij.profiler.clion.perf.PerfProfilerProcess$processPerfData$;
import com.intellij.profiler.clion.perf.PerfProfilerSettings;
import com.intellij.profiler.clion.perf.PerfSample;
import com.intellij.profiler.clion.perf.PerfScriptProcess;
import com.intellij.profiler.clion.perf.PerfSourceFileLineData;
import com.intellij.profiler.model.NativeThread;
import com.intellij.profiler.model.ThreadInfo;
import com.intellij.profiler.ui.BaseCallStackElementRenderer;
import com.intellij.profiler.ui.NativeCallStackElementRenderer;
import com.intellij.psi.NavigatablePsiElement;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.system.HostMachine;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 ?2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001?BS\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0010\b\u0002\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012\u00a2\u0006\u0002\u0010\u0014J&\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020\u0006H\u0016J\u0018\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u0010,\u001a\u00020-H\u0002J\b\u00103\u001a\u00020\u0006H\u0014J\u0010\u00104\u001a\u00020\n2\u0006\u00101\u001a\u000202H\u0002J\u0010\u00105\u001a\u00020\n2\u0006\u00101\u001a\u000202H\u0002J\u0018\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\b2\u0006\u00109\u001a\u00020:H\u0002J\u0018\u0010;\u001a\u0002072\u0006\u00108\u001a\u00020<2\u0006\u00109\u001a\u00020:H\u0014J\u0010\u0010=\u001a\u00020&2\u0006\u0010>\u001a\u00020\bH\u0002R\u0019\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0017X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/intellij/profiler/clion/perf/PerfProfilerProcess;", "Lcom/intellij/profiler/FileBasedProfilerProcess;", "Lcom/intellij/profiler/clion/NativeTargetProcess;", "perfProcessHandler", "Lcom/intellij/execution/process/BaseProcessHandler;", "isAttach", "", "outputPerfDataFile", "Ljava/nio/file/Path;", "processName", "", "project", "Lcom/intellij/openapi/project/Project;", "attachedTimestamp", "", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "navigatableClass", "Ljava/lang/Class;", "Lcom/intellij/psi/NavigatablePsiElement;", "(Lcom/intellij/execution/process/BaseProcessHandler;ZLjava/nio/file/Path;Ljava/lang/String;Lcom/intellij/openapi/project/Project;JLcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;Ljava/lang/Class;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "getAttachedTimestamp", "()J", "helpId", "getHelpId", "()Ljava/lang/String;", "profilerConfiguration", "Lcom/intellij/profiler/LegacyBridgeProfilerConfiguration;", "getProfilerConfiguration", "()Lcom/intellij/profiler/LegacyBridgeProfilerConfiguration;", "stopAttempt", "", "addStackToChart", "", "chartBuilder", "Lcom/intellij/profiler/DummyCallTreeBuilder;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "sample", "Lcom/intellij/profiler/clion/perf/PerfSample;", "navigationMap", "Lcom/intellij/profiler/clion/perf/PerfNavigationMap;", "canBeStopped", "createNavigatableNativeCall", "Lcom/intellij/profiler/clion/perf/NavigatableNativeCall;", "frame", "Lcom/intellij/profiler/clion/perf/PerfFrame;", "doStop", "getBinaryName", "getNormalizedFunctionName", "processPerfData", "Lcom/intellij/profiler/api/ProfilerState;", "dump", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "readPreparedDump", "Ljava/io/File;", "tryDeletePerfData", "dumpPath", "Companion", "intellij.profiler.clion"})
public final class PerfProfilerProcess
extends FileBasedProfilerProcess<NativeTargetProcess> {
    private int stopAttempt;
    @NotNull
    private final LegacyBridgeProfilerConfiguration profilerConfiguration;
    @NotNull
    private final String helpId;
    @NotNull
    private final Logger LOG;
    private final BaseProcessHandler<?> perfProcessHandler;
    private final boolean isAttach;
    private final long attachedTimestamp;
    private final CidrToolEnvironment environment;
    private final Class<? extends NavigatablePsiElement> navigatableClass;
    private static final Logger staticLogger;
    private static final int MAX_GRACEFUL_STOP_ATTEMPTS = 10;
    @NotNull
    public static final Companion Companion;

    @NotNull
    protected ProfilerState readPreparedDump(@NotNull File dump, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Path path = this.environment.getHostMachine().getPath(dump.getPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"environment.hostMachine.getPath(dump.path)");
        Path dumpPath = path;
        try {
            return this.processPerfData(dumpPath, indicator);
        }
        catch (Throwable e) {
            this.tryDeletePerfData(dumpPath);
            if (e instanceof ProcessCanceledException) {
                throw e;
            }
            this.getLOG().warn("Error while reading dump from " + dump.getPath(), e);
            String string = e.getMessage();
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                string2 = "";
            }
            return (ProfilerState)new ProfilerError(string2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ProfilerState processPerfData(Path dump, ProgressIndicator indicator) {
        void title$iv;
        void project$iv;
        DummyCallTreeBuilder chartBuilder = new DummyCallTreeBuilder();
        PerfNavigationMap navigationMap = new PerfNavigationMap();
        PerfScriptProcess.Companion.execute(dump, false, (Function1<? super PerfSample, Unit>)((Function1)new Function1<PerfSample, Unit>(this, chartBuilder, navigationMap){
            final /* synthetic */ PerfProfilerProcess this$0;
            final /* synthetic */ DummyCallTreeBuilder $chartBuilder;
            final /* synthetic */ PerfNavigationMap $navigationMap;

            public final void invoke(@NotNull PerfSample sample) {
                Intrinsics.checkNotNullParameter((Object)sample, (String)"sample");
                PerfProfilerProcess.access$addStackToChart(this.this$0, this.$chartBuilder, sample, this.$navigationMap);
            }
            {
                this.this$0 = perfProfilerProcess;
                this.$chartBuilder = dummyCallTreeBuilder;
                this.$navigationMap = perfNavigationMap;
                super(1);
            }
        }), (Function0<Unit>)((Function0)processPerfData.2.INSTANCE), this.environment, indicator);
        String string = CPPProfilerBundleKt.profilerMessage("profiler.processing.navigation.data", new Object[0]);
        Project project = this.getProject();
        boolean cancellable$iv = true;
        boolean $i$f$runBackgroundableTask = false;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable((Project)project$iv, (String)title$iv, cancellable$iv, (Project)project$iv, (String)title$iv, cancellable$iv, this, dump, navigationMap){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $title;
            final /* synthetic */ boolean $cancellable;
            final /* synthetic */ PerfProfilerProcess this$0;
            final /* synthetic */ Path $dump$inlined;
            final /* synthetic */ PerfNavigationMap $navigationMap$inlined;
            {
                this.$project = $captured_local_variable$1;
                this.$title = $captured_local_variable$2;
                this.$cancellable = $captured_local_variable$3;
                this.this$0 = perfProfilerProcess;
                this.$dump$inlined = path;
                this.$navigationMap$inlined = perfNavigationMap;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                ProgressIndicator backgroundTaskIndicator = indicator;
                boolean bl = false;
                PerfScriptProcess.Companion.execute(this.$dump$inlined, true, (Function1<? super PerfSample, Unit>)((Function1)new Function1<PerfSample, Unit>(this){
                    final /* synthetic */ processPerfData$$inlined$runBackgroundableTask$1 this$0;
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }

                    public final void invoke(@NotNull PerfSample sample) {
                        Intrinsics.checkNotNullParameter((Object)sample, (String)"sample");
                        Iterable $this$forEach$iv = sample.getFrames();
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            PerfFrame frame = (PerfFrame)element$iv;
                            boolean bl = false;
                            PerfSourceFileLineData sourceFileLineData = frame.getMySourceFileLineData();
                            if (sourceFileLineData == null) continue;
                            this.this$0.$navigationMap$inlined.setNavigationData(PerfProfilerProcess.access$getBinaryName(this.this$0.this$0, frame), PerfProfilerProcess.access$getNormalizedFunctionName(this.this$0.this$0, frame), sourceFileLineData);
                        }
                    }
                }), (Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ processPerfData$$inlined$runBackgroundableTask$1 this$0;
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }

                    public final void invoke() {
                        PerfProfilerProcess.access$tryDeletePerfData(this.this$0.this$0, this.this$0.$dump$inlined);
                    }
                }), PerfProfilerProcess.access$getEnvironment$p(this.this$0), backgroundTaskIndicator);
            }
        });
        NewCallTreeOnlyProfilerData data = new NewCallTreeOnlyProfilerData((CallTreeBuilder)chartBuilder, (BaseCallStackElementRenderer)NativeCallStackElementRenderer.Companion.getINSTANCE());
        return (ProfilerState)new DataReady((ProfilerData)data, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void addStackToChart(DummyCallTreeBuilder<BaseCallStackElement> chartBuilder, PerfSample sample, PerfNavigationMap navigationMap) {
        Collection<NavigatableNativeCall> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = CollectionsKt.asReversed(sample.getFrames());
        ThreadInfo threadInfo = (ThreadInfo)new NativeThread(sample.getThreadId(), sample.getThreadName());
        DummyCallTreeBuilder<BaseCallStackElement> dummyCallTreeBuilder = chartBuilder;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PerfFrame perfFrame = (PerfFrame)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            NavigatableNativeCall navigatableNativeCall = this.createNavigatableNativeCall((PerfFrame)it, navigationMap);
            collection.add(navigatableNativeCall);
        }
        collection = (List)destination$iv$iv;
        dummyCallTreeBuilder.addStack(threadInfo, (List)collection, 1L);
    }

    private final NavigatableNativeCall createNavigatableNativeCall(PerfFrame frame, PerfNavigationMap navigationMap) {
        String binaryName = this.getBinaryName(frame);
        String functionName = this.getNormalizedFunctionName(frame);
        NavigatableNativeCall nativeCall = new NavigatableNativeCall(binaryName, functionName, navigationMap, this.navigatableClass);
        PerfSourceFileLineData sourceFileLineData = frame.getMySourceFileLineData();
        if (sourceFileLineData != null) {
            navigationMap.setNavigationData(binaryName, functionName, sourceFileLineData);
        }
        return nativeCall;
    }

    private final String getBinaryName(PerfFrame frame) {
        String string = new File(frame.getBinary()).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File(frame.binary).name");
        return string;
    }

    private final String getNormalizedFunctionName(PerfFrame frame) {
        return ParserUtilKt.fastRemoveCppFunctionArgs((String)frame.getFunction(), (boolean)true);
    }

    private final void tryDeletePerfData(Path dumpPath) {
        if (PerfProfilerSettings.Companion.getInstance().getState().getDeleteOutputOnExit()) {
            Files.deleteIfExists(dumpPath);
        }
    }

    @NotNull
    public LegacyBridgeProfilerConfiguration getProfilerConfiguration() {
        return this.profilerConfiguration;
    }

    @NotNull
    public String getHelpId() {
        return this.helpId;
    }

    public boolean canBeStopped() {
        return this.isAttach;
    }

    protected boolean doStop() {
        if (!this.canBeStopped()) {
            return false;
        }
        Logger logger = this.getLOG();
        HostMachine hostMachine = this.environment.getHostMachine();
        Intrinsics.checkNotNullExpressionValue((Object)hostMachine, (String)"environment.hostMachine");
        logger.assertTrue(!hostMachine.isRemote(), (Object)"Stop profiler action is not available in remote mode");
        PerfProfilerProcess perfProfilerProcess = this;
        ++perfProfilerProcess.stopAttempt;
        if (perfProfilerProcess.stopAttempt <= 10) {
            UnixProcessManager.sendSignalToProcessTree((Process)this.perfProcessHandler.getProcess(), (int)15);
            return true;
        }
        this.getLOG().warn("Failed to stop perf profiler gracefully");
        this.perfProcessHandler.destroyProcess();
        return true;
    }

    @NotNull
    protected Logger getLOG() {
        return this.LOG;
    }

    public long getAttachedTimestamp() {
        return this.attachedTimestamp;
    }

    public PerfProfilerProcess(@NotNull BaseProcessHandler<?> perfProcessHandler, boolean isAttach, @NotNull Path outputPerfDataFile, @NotNull String processName, @NotNull Project project, long attachedTimestamp, @NotNull CidrToolEnvironment environment2, @NotNull Class<? extends NavigatablePsiElement> navigatableClass) {
        Intrinsics.checkNotNullParameter(perfProcessHandler, (String)"perfProcessHandler");
        Intrinsics.checkNotNullParameter((Object)outputPerfDataFile, (String)"outputPerfDataFile");
        Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        Intrinsics.checkNotNullParameter(navigatableClass, (String)"navigatableClass");
        super(project, (ProfilerTargetProcess)new NativeTargetProcess((int)perfProcessHandler.getProcess().pid(), processName), new File(((Object)outputPerfDataFile).toString()));
        this.perfProcessHandler = perfProcessHandler;
        this.isAttach = isAttach;
        this.attachedTimestamp = attachedTimestamp;
        this.environment = environment2;
        this.navigatableClass = navigatableClass;
        this.initTargetProcessLifecycleListener((ProcessHandler)this.perfProcessHandler);
        this.profilerConfiguration = new LegacyBridgeProfilerConfiguration("legacy.perf", "Perf");
        this.helpId = "procedures.profiler";
        this.LOG = staticLogger;
    }

    public /* synthetic */ PerfProfilerProcess(BaseProcessHandler baseProcessHandler, boolean bl, Path path, String string, Project project, long l, CidrToolEnvironment cidrToolEnvironment, Class clazz, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x80) != 0) {
            clazz = OCFunctionDeclaration.class;
        }
        this(baseProcessHandler, bl, path, string, project, l, cidrToolEnvironment, clazz);
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PerfProfilerProcess.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        staticLogger = logger;
    }

    public static final /* synthetic */ void access$addStackToChart(PerfProfilerProcess $this, DummyCallTreeBuilder chartBuilder, PerfSample sample, PerfNavigationMap navigationMap) {
        $this.addStackToChart((DummyCallTreeBuilder<BaseCallStackElement>)chartBuilder, sample, navigationMap);
    }

    public static final /* synthetic */ String access$getBinaryName(PerfProfilerProcess $this, PerfFrame frame) {
        return $this.getBinaryName(frame);
    }

    public static final /* synthetic */ String access$getNormalizedFunctionName(PerfProfilerProcess $this, PerfFrame frame) {
        return $this.getNormalizedFunctionName(frame);
    }

    public static final /* synthetic */ void access$tryDeletePerfData(PerfProfilerProcess $this, Path dumpPath) {
        $this.tryDeletePerfData(dumpPath);
    }

    public static final /* synthetic */ CidrToolEnvironment access$getEnvironment$p(PerfProfilerProcess $this) {
        return $this.environment;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/clion/perf/PerfProfilerProcess$Companion;", "", "()V", "MAX_GRACEFUL_STOP_ATTEMPTS", "", "staticLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.profiler.clion"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

