/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.coverage;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.util.Version;
import com.jetbrains.cidr.cpp.execution.CMakeAppRunConfiguration;
import com.jetbrains.cidr.cpp.execution.CidrExecutionUtil;
import com.jetbrains.cidr.cpp.execution.coverage.CLionCoverageSettings;
import com.jetbrains.cidr.cpp.execution.coverage.CMakeCoverageToolVersionMatcher;
import com.jetbrains.cidr.cpp.execution.coverage.CMakeCoverageUtil;
import com.jetbrains.cidr.cpp.execution.coverage.CoverageToolFinder;
import com.jetbrains.cidr.execution.coverage.CidrCoverageSettings;
import com.jetbrains.cidr.execution.coverage.gcov.GCovCoverageToolProvider;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.ClangClCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.ClangCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/cpp/execution/coverage/CMakeGCovCoverageToolProvider;", "Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageToolProvider;", "()V", "createCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "inputFile", "", "workingDirectory", "createToolFinder", "Lcom/jetbrains/cidr/cpp/execution/coverage/CoverageToolFinder;", "getToolName", "isAvailable", "", "intellij.clion.coverage"})
public class CMakeGCovCoverageToolProvider
implements GCovCoverageToolProvider {
    @Override
    public boolean isAvailable(@NotNull RunConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return configuration instanceof CMakeAppRunConfiguration;
    }

    @Override
    @NotNull
    public String getToolName(@NotNull RunConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        if (CidrExecutionUtil.compilerUsed((CMakeAppRunConfiguration)configuration, (OCCompilerKind)GCCCompilerKind.INSTANCE)) {
            return "gcov";
        }
        return "llvm-cov";
    }

    @Override
    @Nullable
    public GeneralCommandLine createCommandLine(@NotNull RunConfiguration configuration, @NotNull CidrToolEnvironment environment2) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        return this.createToolFinder(configuration, environment2).getCommandLine();
    }

    @Override
    @Nullable
    public GeneralCommandLine createCommandLine(@NotNull String inputFile, @NotNull String workingDirectory, @NotNull RunConfiguration configuration, @NotNull CidrToolEnvironment environment2) {
        Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        GeneralCommandLine generalCommandLine = this.createToolFinder(configuration, environment2).getCommandLine();
        if (generalCommandLine == null) {
            return null;
        }
        GeneralCommandLine commandLine = generalCommandLine;
        commandLine.setWorkDirectory(workingDirectory);
        if (CidrExecutionUtil.compilerUsed((CMakeAppRunConfiguration)configuration, (OCCompilerKind)ClangCompilerKind.INSTANCE, (OCCompilerKind)ClangClCompilerKind.INSTANCE)) {
            commandLine.addParameter("gcov");
        }
        commandLine.withParameters(new String[]{inputFile, "--long-file-names"});
        if (CidrCoverageSettings.Companion.getInstance().getBranchCoverage()) {
            commandLine.withParameters(new String[]{"-a", "-b", "-c"});
        }
        return commandLine;
    }

    private final CoverageToolFinder createToolFinder(RunConfiguration configuration, CidrToolEnvironment environment2) {
        CLionCoverageSettings settings = CLionCoverageSettings.Companion.getInstance();
        RunConfiguration runConfiguration = configuration;
        if (runConfiguration == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.cidr.cpp.execution.CMakeAppRunConfiguration");
        }
        String userPath = CidrExecutionUtil.compilerUsed((CMakeAppRunConfiguration)runConfiguration, (OCCompilerKind)GCCCompilerKind.INSTANCE) ? settings.getGcovExecutablePath() : settings.getLlvmCovExecutablePath();
        String toolName = this.getToolName(configuration);
        Version compilerVersion = new CMakeCoverageToolVersionMatcher().getCompilerVersion(configuration, environment2);
        Object object = CMakeCoverageUtil.Companion.getMostRelevantCompilerSettings(configuration);
        String compilerDirectory = object != null && (object = object.getCompilerExecutable()) != null ? ((File)object).getParent() : null;
        return new CoverageToolFinder(toolName, compilerVersion, userPath, compilerDirectory, environment2);
    }

    @Override
    @Nullable
    public GeneralCommandLine findToolOrNull(@NotNull String toolName) {
        Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
        return GCovCoverageToolProvider.DefaultImpls.findToolOrNull(this, toolName);
    }
}

