/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.gdbserver.remote;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.ui.unified.SshConfigComboBox;
import com.intellij.ssh.ui.unified.SshConfigVisibility;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.cpp.CLionExecutionBundle;
import com.jetbrains.cidr.cpp.execution.gdbserver.DownloadType;
import com.jetbrains.cidr.cpp.execution.gdbserver.GdbParametersPanel;
import com.jetbrains.cidr.cpp.execution.gdbserver.RadioButtonPanel;
import com.jetbrains.cidr.cpp.execution.gdbserver.remote.RemoteGdbServerRunConfiguration;
import com.jetbrains.cidr.cpp.execution.gdbserver.remote.UIUtilKt;
import com.jetbrains.cidr.execution.CidrRunConfigurationExecutableEditor;
import com.jetbrains.cidr.system.HostData;
import com.jetbrains.cidr.system.RemoteDeploymentHelper;
import java.awt.Component;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteGdbParametersPanel
extends GdbParametersPanel
implements Disposable {
    private SshConfigComboBox myConnectionComboBox;
    private LabeledComponent<SshConfigComboBox> myConnectionComponent;
    private LabeledComponent<JBLabel> myConnectionStatusComponent;
    private TextFieldWithBrowseButton myUploadPathField;
    private LabeledComponent<TextFieldWithBrowseButton> myUploadPathFieldComponent;
    private Runnable connectionChecker;
    @Nullable
    private HostData myHostData;
    @NonNls
    private static final String DEFAULT_PORT = "1234";
    @NonNls
    private static final String DEFAULT_UPLOAD_DIR = "/tmp/CLion/debug/";
    @NonNls
    private static final String DEFAULT_EXECUTABLE = "executable";
    @NotNull
    private String myExecutableName;

    public RemoteGdbParametersPanel(@NotNull Project project) {
        if (project == null) {
            RemoteGdbParametersPanel.$$$reportNull$$$0(0);
        }
        this.myExecutableName = DEFAULT_EXECUTABLE;
        MessageBus bus = project.getMessageBus();
        MessageBusConnection connect = bus.connect((Disposable)this);
        connect.subscribe(CidrRunConfigurationExecutableEditor.ExecutableListener.TOPIC, execName -> this.updateUploadPath(execName));
    }

    @Override
    protected void initComponents() {
        this.myConnectionComboBox = new SshConfigComboBox(null, (Disposable)this, SshConfigVisibility.App);
        this.myConnectionComboBox.reload();
        this.myConnectionComboBox.getButton().setIcon(AllIcons.General.GearPlain);
        this.myConnectionComponent = LabeledComponent.create((JComponent)this.myConnectionComboBox, (String)CLionExecutionBundle.message("remote.credentials", new Object[0]), (String)"West");
        JBLabel connectionStatus = new JBLabel(" ", UIUtil.ComponentStyle.SMALL);
        this.myConnectionStatusComponent = LabeledComponent.create((JComponent)connectionStatus, (String)"", (String)"West");
        this.connectionChecker = UIUtilKt.addConnectionChecker(this, (Function0<? extends RemoteCredentials>)((Function0)() -> {
            SshConfig sshConfig = HostData.getSshConfig((HostData)this.myHostData);
            return sshConfig == null ? null : sshConfig.copyToCredentials();
        }), connectionStatus);
        this.myConnectionComboBox.setDataListener(() -> this.updateCredentials(this.myConnectionComboBox.getSelectedSshConfig()));
        this.myUploadPathField = new TextFieldWithBrowseButton();
        this.myUploadPathField.setText(DEFAULT_UPLOAD_DIR);
        this.addBrowseRemoteHostAction(CLionExecutionBundle.message("remote.gdbserver.select.upload.folder", new Object[0]), this.myUploadPathField);
        this.myUploadPathFieldComponent = LabeledComponent.create((JComponent)this.myUploadPathField, (String)CLionExecutionBundle.message("remote.gdbserver.upload.path", new Object[0]), (String)"West");
        super.initComponents();
        this.myDownloadComponent.setText(CLionExecutionBundle.message("remote.gdbserver.upload.executable", new Object[0]));
        RadioButtonPanel downloadButtons = (RadioButtonPanel)((Object)this.myDownloadComponent.getComponent());
        downloadButtons.addChangeListener(e -> this.myUploadPathField.setEnabled(downloadButtons.getSelectedValue() != DownloadType.NONE));
        this.myGdbServerFileField.dispose();
        UIUtilKt.setEmptyText(this.myGdbServerFileField.getTextField(), "/usr/bin/gdbserver");
        this.addBrowseRemoteHostAction(CLionExecutionBundle.message("gdbserver.select.executable", new Object[0]), this.myGdbServerFileField);
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent event) {
                RemoteGdbParametersPanel.this.updateGdbServerArgs();
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                RemoteGdbParametersPanel.this.updateGdbServerArgs();
            }

            @Override
            public void changedUpdate(DocumentEvent event) {
                RemoteGdbParametersPanel.this.updateGdbServerArgs();
            }
        };
        this.myUploadPathField.getTextField().getDocument().addDocumentListener(documentListener);
        this.myGdbRemoteField.getDocument().addDocumentListener(documentListener);
    }

    public void dispose() {
    }

    @Override
    protected void addComponents() {
        this.add((Component)this.myDebuggersComponent);
        this.add((Component)this.myConnectionComponent);
        this.add((Component)this.myConnectionStatusComponent);
        this.add((Component)this.myDownloadComponent);
        this.add((Component)this.myUploadPathFieldComponent);
        this.addCommonComponents();
        this.add((Component)this.myDelayComponent);
    }

    @Override
    public void setAnchor(JComponent anchor) {
        super.setAnchor(anchor);
        this.myConnectionComponent.setAnchor(anchor);
        this.myConnectionStatusComponent.setAnchor(anchor);
        this.myUploadPathFieldComponent.setAnchor(anchor);
    }

    @Override
    public void applyTo(@NotNull CommonProgramRunConfigurationParameters configuration) {
        if (configuration == null) {
            RemoteGdbParametersPanel.$$$reportNull$$$0(1);
        }
        super.applyTo(configuration);
        RemoteGdbServerRunConfiguration remoteGdbConfig = (RemoteGdbServerRunConfiguration)configuration;
        remoteGdbConfig.setHostId(HostData.getId((HostData)this.myHostData));
        remoteGdbConfig.setSshConfigName(HostData.getSshConfigName((HostData)this.myHostData));
        remoteGdbConfig.setUploadFile(StringUtil.nullize((String)this.getUploadFile()));
        String defaultGdbServerArgs = UIUtilKt.getEmptyText(((RawCommandLineEditor)this.myProgramParametersComponent.getComponent()).getTextField());
        remoteGdbConfig.setDefaultGdbServerArgs(defaultGdbServerArgs);
    }

    @Override
    public void reset(@NotNull CommonProgramRunConfigurationParameters configuration) {
        if (configuration == null) {
            RemoteGdbParametersPanel.$$$reportNull$$$0(2);
        }
        super.reset(configuration);
        RemoteGdbServerRunConfiguration remoteGdbConfig = (RemoteGdbServerRunConfiguration)configuration;
        String hostId = remoteGdbConfig.getHostId();
        if (hostId != null) {
            HostData hostData = HostData.readHostData((String)hostId);
            this.setHostData(hostData);
            SshConfig sshConfig = HostData.getSshConfig((HostData)hostData);
            if (sshConfig != null) {
                this.myConnectionComboBox.select(sshConfig);
            }
            this.myUploadPathField.setText(RemoteGdbParametersPanel.getUploadFolder(remoteGdbConfig.getUploadFile()));
        }
    }

    private void addBrowseRemoteHostAction(@NotNull @NlsContexts.DialogTitle String title, @NotNull TextFieldWithBrowseButton field) {
        if (title == null) {
            RemoteGdbParametersPanel.$$$reportNull$$$0(3);
        }
        if (field == null) {
            RemoteGdbParametersPanel.$$$reportNull$$$0(4);
        }
        RemoteDeploymentHelper.addBrowseRemoteHostAction((String)title, (ComponentWithBrowseButton)field, consumer -> {
            SshConfig sshConfig = HostData.getSshConfig((HostData)this.myHostData);
            if (sshConfig != null) {
                consumer.consume((Object)sshConfig.copyToCredentials());
            }
        });
    }

    @Nullable
    private static String getUploadFolder(@Nullable String filePath) {
        if (filePath == null) {
            return null;
        }
        File parent = FileUtil.getParentFile((File)new File(filePath));
        if (parent == null) {
            return null;
        }
        return FileUtil.toSystemIndependentName((String)parent.getPath());
    }

    private void updateCredentials(@Nullable SshConfig sshConfig) {
        if (sshConfig != null && !sshConfig.equals((Object)HostData.getSshConfig((HostData)this.myHostData))) {
            this.setHostData(HostData.updateHostData((HostData)this.myHostData, (SshConfig)sshConfig, (String)"Remote GDB Server"));
            this.updateGdbConnectionParams(sshConfig);
        }
    }

    private void setHostData(@Nullable HostData hostData) {
        if (hostData != null) {
            this.myHostData = hostData;
            this.connectionChecker.run();
        }
    }

    private void updateUploadPath(@Nullable String execName) {
        this.myExecutableName = StringUtil.defaultIfEmpty((String)execName, (String)DEFAULT_EXECUTABLE);
        this.updateGdbServerArgs();
    }

    private void updateGdbConnectionParams(@NotNull SshConfig sshConfig) {
        if (sshConfig == null) {
            RemoteGdbParametersPanel.$$$reportNull$$$0(5);
        }
        String connectionString = StringUtil.notNullize((String)this.myGdbRemoteField.getText());
        String port = RemoteGdbParametersPanel.extractPort(connectionString);
        String host = sshConfig.getHost();
        this.myGdbRemoteField.setText(host + ":" + port);
    }

    private static String extractPort(@NotNull String connectionString) {
        String port;
        if (connectionString == null) {
            RemoteGdbParametersPanel.$$$reportNull$$$0(6);
        }
        return StringUtil.isNotNegativeNumber((CharSequence)(port = StringUtil.substringAfterLast((String)connectionString, (String)":"))) ? port : DEFAULT_PORT;
    }

    private void updateGdbServerArgs() {
        RawCommandLineEditor component = (RawCommandLineEditor)this.myProgramParametersComponent.getComponent();
        String uploadFile = this.getUploadFile();
        String connectionString = StringUtil.notNullize((String)this.myGdbRemoteField.getText());
        String port = RemoteGdbParametersPanel.extractPort(connectionString);
        UIUtilKt.setEmptyText(component.getTextField(), ":" + port + " " + uploadFile);
    }

    @NotNull
    private String getUploadFile() {
        String uploadPath = this.myUploadPathField.getText();
        if (StringUtil.isEmpty((String)uploadPath)) {
            String string = this.myExecutableName;
            if (string == null) {
                RemoteGdbParametersPanel.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = FileUtil.toSystemIndependentName((String)new File(uploadPath, this.myExecutableName).getPath());
        if (string == null) {
            RemoteGdbParametersPanel.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sshConfig";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionString";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/gdbserver/remote/RemoteGdbParametersPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/gdbserver/remote/RemoteGdbParametersPanel";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUploadFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyTo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addBrowseRemoteHostAction";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateGdbConnectionParams";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "extractPort";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

