/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.profiling.actions;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ExporterToTextFile;
import com.intellij.ide.util.ExportToFileUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryProfileExportAction
extends AnAction {
    @Nullable
    private String myContentToExport;
    private static final Logger LOG = Logger.getInstance(MemoryProfileExportAction.class);

    public MemoryProfileExportAction(@Nullable String contentToExport) {
        super(InspectionsBundle.messagePointer((String)"inspection.export.dialog.title", (Object[])new Object[0]), InspectionsBundle.messagePointer((String)"inspection.export.dialog.title", (Object[])new Object[0]), AllIcons.ToolbarDecorator.Export);
        this.myContentToExport = contentToExport;
    }

    @Nullable
    public String getContentToExport() {
        return this.myContentToExport;
    }

    public void setContentToExport(@Nullable String contentToExport) {
        this.myContentToExport = contentToExport;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            MemoryProfileExportAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabled(this.myContentToExport != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            MemoryProfileExportAction.$$$reportNull$$$0(1);
        }
        if (this.myContentToExport == null) {
            return;
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            LOG.warn("Failed to perform Export action, because Project is null");
            return;
        }
        ExporterToTextFile exporter = MemoryProfileExportAction.createExporter(this.myContentToExport, project);
        ExportToFileUtil.chooseFileAndExport((Project)project, (ExporterToTextFile)exporter);
    }

    private static ExporterToTextFile createExporter(final @Nullable String exportContent, final @NotNull Project project) {
        if (project == null) {
            MemoryProfileExportAction.$$$reportNull$$$0(2);
        }
        return new ExporterToTextFile(){

            @NotNull
            public String getReportText() {
                String string = StringUtil.notNullize((String)exportContent);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getDefaultFilePath() {
                VirtualFile baseDir = project.getBaseDir();
                return baseDir != null ? baseDir.getPresentableUrl() + File.separator + "valgrind.xml" : "";
            }

            public boolean canExport() {
                return exportContent != null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/cpp/profiling/actions/MemoryProfileExportAction$1", "getReportText"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/cpp/profiling/actions/MemoryProfileExportAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createExporter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

