/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.cmakecache.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cmake.cmakecache.psi.CMakeCacheElementType;
import com.jetbrains.cmake.cmakecache.psi.CacheEntryImpl;
import com.jetbrains.cmake.cmakecache.psi.EntryNameImpl;
import com.jetbrains.cmake.cmakecache.psi.EntryTypeImpl;
import com.jetbrains.cmake.cmakecache.psi.EntryValueImpl;

public interface CMakeCacheTokenTypes {
    public static final IElementType CACHE_ENTRY = new CMakeCacheElementType("CACHE_ENTRY");
    public static final IElementType ENTRY_NAME = new CMakeCacheElementType("ENTRY_NAME");
    public static final IElementType ENTRY_TYPE = new CMakeCacheElementType("ENTRY_TYPE");
    public static final IElementType ENTRY_VALUE = new CMakeCacheElementType("ENTRY_VALUE");
    public static final IElementType COMMENT = new CMakeCacheElementType("comment");
    public static final IElementType EOL = new CMakeCacheElementType("EOL");
    public static final IElementType KEY = new CMakeCacheElementType("KEY");
    public static final IElementType KEY_QUOTE = new CMakeCacheElementType("\"");
    public static final IElementType TYPE = new CMakeCacheElementType("TYPE");
    public static final IElementType TYPE_SEPARATOR = new CMakeCacheElementType(":");
    public static final IElementType VALUE = new CMakeCacheElementType("VALUE");
    public static final IElementType VALUE_QUOTE = new CMakeCacheElementType("'");
    public static final IElementType VALUE_SEPARATOR = new CMakeCacheElementType("=");
    public static final IElementType WHITESPACES = new CMakeCacheElementType("WHITESPACES");

    public static class Factory {
        public static PsiElement createElement(ASTNode node2) {
            IElementType type = node2.getElementType();
            if (type == CACHE_ENTRY) {
                return new CacheEntryImpl(node2);
            }
            if (type == ENTRY_NAME) {
                return new EntryNameImpl(node2);
            }
            if (type == ENTRY_TYPE) {
                return new EntryTypeImpl(node2);
            }
            if (type == ENTRY_VALUE) {
                return new EntryValueImpl(node2);
            }
            throw new AssertionError((Object)("Unknown element type: " + type));
        }
    }
}

