/*****
 NAME
 	pxmlparser.h - protocol definition for the parser of XML classes
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#if !defined(PXMLPARSER_H_INCLUDED)
#define PXMLPARSER_H_INCLUDED

#include <coconut/pxmltree.h>
#include <coconut/txml.h>

/* generate new object from xml tree */

@protocol PXMLParserPart <PObject>
  - addTagName: (const char *) key value: (int) value ;
  - addAttrName: (const char *) key value: (int) value ;
  - addAttrValue: (const char *) key value: (int) value ;

  - (int) searchTagName: (const char *) key ;
  - (int) searchAttrName: (const char *) key ;
  - (int) searchAttrValue: (const char *) key ;

  - verbose: (id <PXMLNode>) node format: (const char *) form, ... ;
  - warning: (id <PXMLNode>) node format: (const char *) form, ... ;
  - error: (id <PXMLNode>) node format: (const char *) form, ... ;

  - setInputName: (id <PBasicStr>) name ;
  - setVerboseMode: (boolean) doverbose ;
@end

@protocol PXMLParserIF <PObject>
  - parse: (id <PXMLTree>) tree ;
  - parse: (id <PXMLNode>) node name: (id <PBasicStr>) str ;
  - setupNameTable ;
@end

/* output the information of the xml tree */
@protocol PXMLConverter <PObject>
  - (id <PError>) convert: (id <PObject>) output from: (id <PObject>) input ;
@end

#endif /* !defined(PXMLPARSER_H_INCLUDED) */

