.TH FBHIST 1 25-Jun-90
.CM 3
.SH NAME
fbhist \- compute histogram of an image
.SH SYNOPSIS
.nf
fbhist [ -h ] < image
.fi
.SH DESCRIPTION
.PP
Prints some of the header info and displays the maximum, minimum, mean,
and standard deviation of the gray levels.  If given any argument it
also dumps the histogram.  Works correctly for black and white images.
On color images it will work, but the results for images with odd
widths will include the zeroes used to pad to an even byte boundary.
.sp
.TP
.B -h
.I histogram
argument requests printing the actual counts for all gray levels used
by the image.
.SH EXAMPLE
.PP
To compute the mean and range of an image:
.sp
.nf
    % fbhist < tiger.fbm
    Tiger [400x640  8 bits  0.833 aspect ratio]
    Mean 88.83 +- 40.94, range 21..201
.fi
.sp
The output shows that the image is title 'Tiger', and that it is 400
pixels wide and 640 pixels tall.  The pixels are 8 bits deep, and the
image has a 0.833 aspect ratio (it is a rotated version of a 1.2 to 1
image).  The average density is 88.83 with a standard deviation of
40.94.  Pixels range from values 21 (darkest) to 201 (lightest) out of
a 0..255 range.
.SH SEE ALSO
fbm(1) for general discussion, pbm(1) for PBM routines.
.SH BUGS
None known.
.SH HISTORY
Copyright (C) 1989,1990 by Michael Mauldin.  Permission is granted
to use this file in whole or in part for any purpose, educational,
recreational or commercial, provided that this copyright notice
is retained unchanged.  This software is available to all free of
charge by anonymous FTP and in the UUNET archives.
.TP
25-Jun-90  Michael Mauldin at Carnegie Mellon University
Release 1.0 mlm@cs.cmu.edu
.TP
07-Mar-89  Michael L. Mauldin at Carnegie Mellon University
Beta release (version 0.9) mlm@cs.cmu.edu
