/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.editor;

import com.intellij.dmserver.editor.ImportedUnit;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.dmserver.util.VersionUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.osgi.framework.VersionRange;

public class ImportedUnitAttributesDialog
extends DialogWrapper {
    private JTextField myVersionRangeTextField;
    private JPanel myMainPanel;
    private JCheckBox myOptionalCheckBox;
    private final List<ImportedUnit> myImportedUnits;

    public ImportedUnitAttributesDialog(Project project, List<ImportedUnit> importedUnits) {
        super(project);
        this.myImportedUnits = importedUnits;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(DmServerBundle.message("ImportedUnitAttributesDialog.title", objectArray));
        Iterator<ImportedUnit> itImportedUnit = importedUnits.iterator();
        VersionRange initialVersionRange = itImportedUnit.next().getVersionRange();
        while (itImportedUnit.hasNext()) {
            if (initialVersionRange.equals((Object)itImportedUnit.next().getVersionRange())) continue;
            initialVersionRange = null;
            break;
        }
        if (initialVersionRange != null) {
            this.myVersionRangeTextField.setText(initialVersionRange.toString());
        }
        boolean initialOptional = true;
        for (ImportedUnit importedUnit : importedUnits) {
            if (importedUnit.isOptional()) continue;
            initialOptional = false;
            break;
        }
        this.myOptionalCheckBox.setSelected(initialOptional);
        this.init();
    }

    protected void doOKAction() {
        boolean keepVersionRanges = "".equals(this.myVersionRangeTextField.getText());
        VersionRange versionRange = null;
        if (!keepVersionRanges && (versionRange = VersionUtils.parseVersionRange(this.myVersionRangeTextField.getText())) == null) {
            this.setErrorText(DmServerBundle.message("ImportedUnitAttributesDialog.error.version.range.format.not.matched", new Object[0]), this.myVersionRangeTextField);
            return;
        }
        for (ImportedUnit importedUnit : this.myImportedUnits) {
            if (!keepVersionRanges) {
                importedUnit.setVersionRange(versionRange);
            }
            importedUnit.setOptional(this.myOptionalCheckBox.isSelected());
        }
        super.doOKAction();
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JTextField jTextField;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.ImportedUnitAttributesDialog.version.range"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myVersionRangeTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myOptionalCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.ImportedUnitAttributesDialog.optional"));
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

