/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.facet;

import com.intellij.dmserver.facet.DMBundleFacet;
import com.intellij.dmserver.facet.DMCompositeFacet;
import com.intellij.dmserver.facet.DMCompositeFacetConfiguration;
import com.intellij.dmserver.facet.DMCompositeType;
import com.intellij.dmserver.facet.DMConfigFacet;
import com.intellij.dmserver.facet.DMFacetsSwitch;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Ref;
import java.util.ArrayList;
import java.util.List;

public class NestedUnitProvider {
    private final Module myConfiguredModule;
    private final ModulesProvider myModulesProvider;

    public NestedUnitProvider(Module configuredModule, ModulesProvider modulesProvider) {
        this.myConfiguredModule = configuredModule;
        this.myModulesProvider = modulesProvider;
    }

    public List<Module> getPossibleNestedModules(DMCompositeFacetConfiguration configuration) {
        ArrayList<Module> result = new ArrayList<Module>();
        for (Module module : this.myModulesProvider.getModules()) {
            if (module.equals(this.myConfiguredModule) || !NestedUnitProvider.isPossibleNestedModule(module, configuration)) continue;
            result.add(module);
        }
        return result;
    }

    public static boolean isPossibleNestedModule(Module module, DMCompositeFacetConfiguration configuration) {
        return NestedUnitProvider.isPossibleNestedModule(module, configuration, (Ref<? super String>)new Ref());
    }

    public static boolean isPossibleNestedModule(Module module, final DMCompositeFacetConfiguration configuration, final Ref<? super String> errorRef) {
        Boolean result = (Boolean)new DMFacetsSwitch<Boolean>(){

            @Override
            protected Boolean doProcessBundleFacet(DMBundleFacet bundleFacet) {
                return true;
            }

            @Override
            protected Boolean doProcessCompositeFacet(DMCompositeFacet compositeFacet) {
                boolean nestedScope;
                if (configuration.getCompositeType() == DMCompositeType.PAR) {
                    errorRef.set((Object)DmServerBundle.message("NestedUnitProvider.error.par.inside.par", new Object[0]));
                    return false;
                }
                DMCompositeFacetConfiguration compositeFacetConfiguration = compositeFacet.getConfigurationImpl();
                boolean bl = nestedScope = configuration.getScoped() && (compositeFacetConfiguration.getCompositeType() == DMCompositeType.PAR || compositeFacetConfiguration.getScoped());
                if (nestedScope) {
                    errorRef.set((Object)DmServerBundle.message("NestedUnitProvider.error.nested.scopes", new Object[0]));
                }
                return !nestedScope;
            }

            @Override
            protected Boolean doProcessConfigFacet(DMConfigFacet configFacet) {
                return true;
            }
        }.processModule(module);
        if (result == null) {
            errorRef.set((Object)DmServerBundle.message("NestedUnitProvider.error.not.single.dm.facet", new Object[0]));
            return false;
        }
        return result;
    }
}

