/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.libraries.tree;

import com.intellij.dmserver.editor.AvailableBundlesProvider;
import com.intellij.dmserver.integration.RepositoryPattern;
import com.intellij.dmserver.libraries.LibraryDefinition;
import com.intellij.dmserver.libraries.ServerLibrariesContext;
import com.intellij.dmserver.libraries.tree.LibraryElement;
import com.intellij.dmserver.libraries.tree.RepositoryFolderElementBase;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class LibraryFolderElement
extends RepositoryFolderElementBase {
    private static final Comparator<LibraryElement> BY_LIBRARY_FILE_NAME = (o1, o2) -> {
        String name1 = o1.getLibraryDefinition().getLibDefFile().getName();
        String name2 = o2.getLibraryDefinition().getLibDefFile().getName();
        return name1.compareTo(name2);
    };

    public LibraryFolderElement(ServerLibrariesContext context, RepositoryPattern repositoryPattern) {
        super(context, repositoryPattern, "libraries-folder");
    }

    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            LibraryFolderElement.$$$reportNull$$$0(0);
        }
        presentation.setPresentableText(DmServerBundle.message("LibraryFolderElement.name", new Object[0]));
        LibraryFolderElement.updateIcons(presentation);
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        ArrayList<LibraryElement> result = new ArrayList<LibraryElement>();
        for (LibraryDefinition libraryDefinition : AvailableBundlesProvider.getInstance(this.getProject()).getRepositoryLibraries(this.getRepositoryPattern())) {
            result.add(new LibraryElement(this.getContext(), libraryDefinition));
        }
        Collections.sort(result, BY_LIBRARY_FILE_NAME);
        ArrayList<LibraryElement> arrayList = result;
        if (arrayList == null) {
            LibraryFolderElement.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dmserver/libraries/tree/LibraryFolderElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dmserver/libraries/tree/LibraryFolderElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

