/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.run;

import com.intellij.dmserver.install.DMServerInstallation;
import com.intellij.dmserver.install.ServerVersionHandler;
import com.intellij.dmserver.integration.DMServerIntegrationData;
import com.intellij.dmserver.run.DMServerModelBase;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.util.EnvironmentVariable;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.localRun.ColoredCommandLineExecutableObject;
import com.intellij.javaee.run.localRun.EnvironmentHelper;
import com.intellij.javaee.run.localRun.ExecutableObject;
import com.intellij.javaee.run.localRun.ExecutableObjectStartupPolicy;
import com.intellij.javaee.run.localRun.ScriptHelper;
import com.intellij.javaee.run.localRun.ScriptsHelper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class DMServerStartupPolicy
implements ExecutableObjectStartupPolicy {
    private static final Logger LOG = Logger.getInstance(DMServerStartupPolicy.class);
    @NonNls
    public static final String STARTUP_SCRIPT = "startup";
    @NonNls
    private static final String SHUTDOWN_SCRIPT = "shutdown";
    @NonNls
    public static final String DMK_SCRIPT = "dmk";
    @NonNls
    private static final String JMX_OPTS_ENV_VAR = "JMX_OPTS";
    private static final String SH_LINE_CONCAT = "\\";
    private static final String SH_QUOTE = "\"";
    @NonNls
    private static final String BAT_SET = "set";
    private static final boolean isWindows = SystemInfo.isWindows;
    @NonNls
    private static final String DEBUG_ENV_VAR = "DEBUG_OPTS";

    @NonNls
    private static String getEnvVarRef(String envVar) {
        return isWindows ? "%" + envVar + "%" : "$" + envVar;
    }

    @Deprecated
    @Nullable
    public ScriptsHelper getStartupHelper() {
        return null;
    }

    @Deprecated
    @Nullable
    public ScriptsHelper getShutdownHelper() {
        return null;
    }

    private static DMServerIntegrationData getPersistentData(CommonModel commonModel) {
        ApplicationServer applicationServer = commonModel.getApplicationServer();
        if (applicationServer == null) {
            return null;
        }
        return (DMServerIntegrationData)applicationServer.getPersistentData();
    }

    private static ServerVersionHandler getVersionHandler(CommonModel commonModel) {
        DMServerIntegrationData persistentData = DMServerStartupPolicy.getPersistentData(commonModel);
        if (persistentData == null) {
            return null;
        }
        DMServerInstallation installation = persistentData.getInstallation();
        if (installation == null || !installation.isValid()) {
            return null;
        }
        return installation.getServerVersion();
    }

    @Nullable
    public ScriptHelper createStartupScriptHelper(ProgramRunner runner) {
        return new ScriptHelperImpl(STARTUP_SCRIPT){

            public void checkRunnerSettings(RunConfigurationBase runConfiguration, RunnerSettings runnerSettings) throws RuntimeConfigurationException {
                if (runConfiguration instanceof CommonModel) {
                    CommonModel commonModel = (CommonModel)runConfiguration;
                    ServerVersionHandler versionHandler = DMServerStartupPolicy.getVersionHandler(commonModel);
                    if (versionHandler == null) {
                        return;
                    }
                    String scriptName = versionHandler.getJmxScriptName();
                    File script = DMServerStartupPolicy.getScript(commonModel, scriptName);
                    if (script == null) {
                        return;
                    }
                    DMServerStartupPolicy.checkJmxScript(script, versionHandler.getJmxPortEnvVar());
                }
            }
        };
    }

    @Nullable
    public ScriptHelper createShutdownScriptHelper(ProgramRunner runner) {
        return new ScriptHelperImpl(SHUTDOWN_SCRIPT);
    }

    private static void checkJmxScript(File script, String jmxPortEnvVar) throws RuntimeConfigurationError {
        try {
            String scriptContent = FileUtil.loadFile((File)script);
            List scriptLines = StringUtil.split((String)scriptContent, (String)"\n", (boolean)true, (boolean)false);
            ArrayList<String> fixedLines = new ArrayList<String>();
            boolean hasWrongArgs = false;
            LinkedHashSet<String> requiredArgs = new LinkedHashSet<String>();
            requiredArgs.add("-Dcom.sun.management.jmxremote=");
            requiredArgs.add("-Dcom.sun.management.jmxremote.port=" + DMServerStartupPolicy.getEnvVarRef(jmxPortEnvVar));
            requiredArgs.add("-Dcom.sun.management.jmxremote.ssl=false");
            requiredArgs.add("-Dcom.sun.management.jmxremote.authenticate=false");
            String comment = isWindows ? "rem" : "#";
            String jmxOptsRef = DMServerStartupPolicy.getEnvVarRef(JMX_OPTS_ENV_VAR);
            String jmxOptsSet = "JMX_OPTS=";
            Iterator itLine = scriptLines.iterator();
            int insertLineIndex = 0;
            int lineIndex = 0;
            while (itLine.hasNext()) {
                ++lineIndex;
                String line = (String)itLine.next();
                String trimmedLine = line.trim();
                boolean setCandidate = true;
                if (isWindows) {
                    if (StringUtil.startsWithIgnoreCase((String)trimmedLine, (String)BAT_SET)) {
                        trimmedLine = trimmedLine.substring(BAT_SET.length()).trim();
                    } else {
                        setCandidate = false;
                    }
                }
                if (setCandidate && trimmedLine.startsWith("JMX_OPTS=")) {
                    String part;
                    ArrayList<String> partLines = new ArrayList<String>();
                    partLines.add(line);
                    trimmedLine = StringUtil.trimStart((String)trimmedLine, (String)"JMX_OPTS=").trim();
                    if (isWindows) {
                        part = trimmedLine;
                    } else {
                        StringBuilder concatenatedLine = new StringBuilder();
                        while (trimmedLine.endsWith(SH_LINE_CONCAT)) {
                            concatenatedLine.append(StringUtil.trimEnd((String)trimmedLine, (String)SH_LINE_CONCAT));
                            ++lineIndex;
                            line = (String)itLine.next();
                            trimmedLine = line.trim();
                            partLines.add(line);
                        }
                        concatenatedLine.append(trimmedLine);
                        part = concatenatedLine.toString();
                        if (part.startsWith(SH_QUOTE)) {
                            part = StringUtil.trimEnd((String)StringUtil.trimStart((String)part, (String)SH_QUOTE), (String)SH_QUOTE).trim();
                        }
                    }
                    if (insertLineIndex == 0) {
                        insertLineIndex = lineIndex;
                    }
                    part = StringUtil.trimStart((String)part, (String)jmxOptsRef).trim();
                    String[] args = part.split("\\s+");
                    ArrayList<String> partRequiredArgs = new ArrayList<String>();
                    boolean partHasWrongArgs = false;
                    for (String arg : args) {
                        if (requiredArgs.contains(arg)) {
                            partRequiredArgs.add(arg);
                            continue;
                        }
                        partHasWrongArgs = true;
                        hasWrongArgs = true;
                    }
                    for (String partLine : partLines) {
                        if (partHasWrongArgs) {
                            fixedLines.add(comment + " " + partLine);
                            continue;
                        }
                        fixedLines.add(partLine);
                    }
                    if (partHasWrongArgs) continue;
                    requiredArgs.removeAll(partRequiredArgs);
                    continue;
                }
                fixedLines.add(line);
            }
            if (!requiredArgs.isEmpty()) {
                for (String requiredArg : requiredArgs) {
                    String value = jmxOptsRef + " " + requiredArg;
                    if (!isWindows) {
                        value = SH_QUOTE + value + SH_QUOTE;
                    }
                    String line = "JMX_OPTS=" + value;
                    if (isWindows) {
                        line = "set " + line;
                    }
                    fixedLines.add(insertLineIndex, line);
                }
            }
            if (hasWrongArgs || !requiredArgs.isEmpty()) {
                throw new RuntimeConfigurationError(DmServerBundle.message("DMServerStartupPolicy.jmx.arguments.are.incompatible", new Object[0]), () -> {
                    try {
                        String fixedScriptContent = StringUtil.join((String[])ArrayUtil.toStringArray((Collection)fixedLines), (String)"\n");
                        FileUtil.writeToFile((File)script, (byte[])fixedScriptContent.getBytes(Charset.defaultCharset()));
                    }
                    catch (IOException e) {
                        LOG.warn((Throwable)e);
                    }
                });
            }
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
        }
    }

    @Nullable
    public EnvironmentHelper getEnvironmentHelper() {
        return new EnvironmentHelper(){

            public String getDefaultJavaVmEnvVariableName(CommonModel model) {
                return DMServerStartupPolicy.DEBUG_ENV_VAR;
            }

            public List<EnvironmentVariable> getAdditionalEnvironmentVariables(CommonModel model) {
                ArrayList<EnvironmentVariable> result = new ArrayList<EnvironmentVariable>();
                ServerVersionHandler versionHandler = DMServerStartupPolicy.getVersionHandler(model);
                if (versionHandler != null) {
                    DMServerModelBase dmServerModel = (DMServerModelBase)model.getServerModel();
                    result.add(new EnvironmentVariable(versionHandler.getJmxPortEnvVar(), String.valueOf(dmServerModel.getMBeanServerPort()), true));
                }
                return result;
            }
        };
    }

    @Nullable
    private static File getScript(CommonModel commonModel, String scriptName) {
        DMServerIntegrationData data = DMServerStartupPolicy.getPersistentData(commonModel);
        if (data == null) {
            return null;
        }
        File scriptDir = new File(data.getInstallationHome(), "bin");
        return new File(scriptDir, scriptName + (isWindows ? ".bat" : ".sh"));
    }

    private static class ScriptHelperImpl
    extends ScriptHelper {
        private final String myScriptName;

        ScriptHelperImpl(String scriptName) {
            this.myScriptName = scriptName;
        }

        @Nullable
        public ExecutableObject getDefaultScript(CommonModel commonModel) {
            File script = DMServerStartupPolicy.getScript(commonModel, this.myScriptName);
            if (script == null) {
                return null;
            }
            return new ColoredCommandLineExecutableObject(new String[]{script.getAbsolutePath()}, null);
        }
    }
}

