/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.config.anno;

import com.intellij.codeInspection.dataFlow.StringExpressionHelper;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

class CodeConfigurationPropertiesParser {
    private final PsiClass myClass;

    CodeConfigurationPropertiesParser(PsiClass aClass) {
        this.myClass = aClass;
    }

    @Nullable
    String getString(String methodName, boolean checkBases) {
        PsiElement returnValue = this.getReturnValue(methodName, checkBases);
        if (returnValue == null) {
            return null;
        }
        if (returnValue instanceof PsiMethod) {
            return CodeConfigurationPropertiesParser.getStringCompiled((PsiMethod)returnValue);
        }
        Pair pair = StringExpressionHelper.evaluateExpression((PsiElement)returnValue);
        return (String)Pair.getSecond((Pair)pair);
    }

    @Nullable
    private static String getStringCompiled(PsiMethod psiMethod) {
        VirtualFile file = psiMethod.getContainingFile().getVirtualFile();
        if (file == null) {
            return null;
        }
        StringConstantVisitor stringConstantVisitor = new StringConstantVisitor(psiMethod);
        try {
            new ClassReader(file.contentsToByteArray()).accept((ClassVisitor)stringConstantVisitor, 2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringConstantVisitor.getResult();
    }

    String[] getStringArray(String methodName, boolean checkBases) {
        PsiElement returnValue = this.getReturnValue(methodName, checkBases);
        if (returnValue == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        PsiArrayInitializerExpression arrayInitializer = CodeConfigurationPropertiesParser.getArrayInitializerExpression(returnValue);
        if (arrayInitializer == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        SmartList strings = new SmartList();
        for (PsiExpression initializerExpression : arrayInitializer.getInitializers()) {
            Pair pair = StringExpressionHelper.evaluateExpression((PsiElement)initializerExpression);
            if (pair == null) continue;
            ContainerUtil.addIfNotNull((Collection)strings, (Object)pair.getSecond());
        }
        return ArrayUtil.toStringArray((Collection)strings);
    }

    List<PsiClass> getPsiClasses(String methodName, boolean checkBases) {
        PsiElement returnValue = this.getReturnValue(methodName, checkBases);
        if (returnValue == null) {
            return Collections.emptyList();
        }
        PsiArrayInitializerExpression arrayInitializer = CodeConfigurationPropertiesParser.getArrayInitializerExpression(returnValue);
        if (arrayInitializer == null) {
            return Collections.emptyList();
        }
        SmartList psiClasses = new SmartList();
        for (PsiExpression initializerExpression : arrayInitializer.getInitializers()) {
            if (!(initializerExpression instanceof PsiClassObjectAccessExpression)) continue;
            PsiClassObjectAccessExpression classObjectAccessExpression = (PsiClassObjectAccessExpression)initializerExpression;
            PsiClass aClass = PsiTypesUtil.getPsiClass((PsiType)classObjectAccessExpression.getOperand().getType());
            ContainerUtil.addIfNotNull((Collection)psiClasses, (Object)aClass);
        }
        return psiClasses;
    }

    @Nullable
    private PsiElement getReturnValue(String methodName, boolean checkBases) {
        PsiMethod[] methodsByName;
        for (PsiMethod psiMethod : methodsByName = this.myClass.findMethodsByName(methodName, checkBases)) {
            if (psiMethod instanceof PsiCompiledElement) {
                return psiMethod;
            }
            PsiReturnStatement[] returnStatements = PsiUtil.findReturnStatements((PsiMethod)psiMethod);
            if (returnStatements.length != 1) continue;
            PsiReturnStatement returnStatement = returnStatements[0];
            return returnStatement.getReturnValue();
        }
        return null;
    }

    @Nullable
    private static PsiArrayInitializerExpression getArrayInitializerExpression(@NotNull PsiElement expression) {
        PsiElement referenceResolve;
        if (expression == null) {
            CodeConfigurationPropertiesParser.$$$reportNull$$$0(0);
        }
        if (expression instanceof PsiReferenceExpression && (referenceResolve = ((PsiReferenceExpression)expression).resolve()) instanceof PsiField) {
            expression = ((PsiField)referenceResolve).getInitializer();
        }
        if (!(expression instanceof PsiNewExpression)) {
            return null;
        }
        return ((PsiNewExpression)expression).getArrayInitializer();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/spring/web/config/anno/CodeConfigurationPropertiesParser", "getArrayInitializerExpression"));
    }

    private static class StringConstantVisitor
    extends ClassVisitor {
        private final PsiMethod myPsiMethod;
        private String myResult;

        private StringConstantVisitor(PsiMethod psiMethod) {
            super(458752);
            this.myPsiMethod = psiMethod;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (this.myPsiMethod.getName().equals(name)) {
                return new MethodVisitor(458752){

                    public void visitLdcInsn(Object cst) {
                        if (cst instanceof String) {
                            myResult = (String)cst;
                        }
                    }
                };
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }

        private String getResult() {
            return this.myResult;
        }
    }
}

