/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.model;

import com.intellij.javaee.web.ServletMappingInfo;
import com.intellij.javaee.web.ServletMappingType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.spring.model.utils.AntPathMatcher;
import com.intellij.spring.model.utils.PlaceholderTextRanges;
import com.intellij.spring.web.mvc.jam.RequestMethod;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.xml.util.PsiElementPointer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringMVCRequestMappings {
    private final MultiMap<String, Mapping> urls = new MultiMap<String, Mapping>(){

        @NotNull
        protected Collection<Mapping> createCollection() {
            HashSet<Mapping> hashSet = new HashSet<Mapping>();
            if (hashSet == null) {
                1.$$$reportNull$$$0(0);
            }
            return hashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/model/SpringMVCRequestMappings$1", "createCollection"));
        }
    };
    private final List<PatternMapping> patterns = new SmartList();

    SpringMVCRequestMappings() {
    }

    void addUrl(@NotNull String url, @NotNull PsiElementPointer pointer, RequestMethod ... method) {
        if (url == null) {
            SpringMVCRequestMappings.$$$reportNull$$$0(0);
        }
        if (pointer == null) {
            SpringMVCRequestMappings.$$$reportNull$$$0(1);
        }
        if (StringUtil.startsWithChar((CharSequence)url, (char)'/')) {
            url = url.substring(1);
        }
        String originalUrl = url;
        if (AntPathMatcher.isPattern((String)(url = SpringMVCRequestMappings.substitutePathVariables(url)))) {
            this.patterns.add(new PatternMapping(url, originalUrl, new Mapping(pointer, method)));
        } else {
            this.urls.putValue((Object)url, (Object)new Mapping(pointer, method));
        }
    }

    private static String substitutePathVariables(String url) {
        Set ranges = PlaceholderTextRanges.getPlaceholderRanges((String)url, (String)"{", (String)"}", (boolean)false, (boolean)true);
        if (ranges.isEmpty()) {
            return url;
        }
        StringBuilder builder = new StringBuilder(url.length());
        int offset = 0;
        for (TextRange range : ranges) {
            builder.append(url, offset, range.getStartOffset() - 1);
            builder.append('*');
            offset = range.getEndOffset() + 1;
        }
        builder.append(url.substring(offset));
        url = builder.toString();
        return url;
    }

    @Nullable
    Collection<PsiElement> resolve(String url, @NotNull ServletMappingInfo info) {
        if (info == null) {
            SpringMVCRequestMappings.$$$reportNull$$$0(2);
        }
        HashSet<PsiElement> results = new HashSet<PsiElement>();
        Collection mappings = this.getUrls().get((Object)url);
        for (Object mapping : mappings) {
            ContainerUtil.addIfNotNull(results, (Object)((Mapping)mapping).pointer.getPsiElement());
        }
        if (results.isEmpty() && info.getType() == ServletMappingType.EXTENSION && !info.matches(url)) {
            Collection servletMappings = this.getUrls().get((Object)info.addMapping(url));
            for (Mapping mapping : servletMappings) {
                ContainerUtil.addIfNotNull(results, (Object)mapping.pointer.getPsiElement());
            }
        }
        if (!results.isEmpty()) {
            return results;
        }
        for (PatternMapping pattern : this.getPatterns()) {
            if (!AntPathMatcher.match((String)pattern.getUrl(), (String)url)) continue;
            ContainerUtil.addIfNotNull(results, (Object)pattern.getMapping().pointer.getPsiElement());
        }
        return results;
    }

    public MultiMap<String, Mapping> getUrls() {
        return this.urls;
    }

    public List<PatternMapping> getPatterns() {
        return this.patterns;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/web/mvc/model/SpringMVCRequestMappings";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addUrl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "resolve";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class PatternMapping {
        private final String myUrl;
        private final String myOriginalUrl;
        private final Mapping myMapping;

        private PatternMapping(String url, String originalUrl, Mapping mapping) {
            this.myUrl = url;
            this.myOriginalUrl = originalUrl;
            this.myMapping = mapping;
        }

        public String getUrl() {
            return this.myUrl;
        }

        public String getOriginalUrl() {
            return this.myOriginalUrl;
        }

        public Mapping getMapping() {
            return this.myMapping;
        }
    }

    public static class Mapping {
        final PsiElementPointer pointer;
        final RequestMethod[] method;

        private Mapping(PsiElementPointer pointer, RequestMethod ... method) {
            this.pointer = pointer;
            this.method = method;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Mapping mapping = (Mapping)o;
            return Arrays.equals(this.method, mapping.method);
        }

        public int hashCode() {
            return this.method != null ? Arrays.hashCode(this.method) : 0;
        }
    }
}

