/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.toolWindow;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.JamSpringBeanPointer;
import com.intellij.spring.toolWindow.SpringBeanPointerPanelBase;
import com.intellij.spring.web.mvc.jam.RequestMapping;
import com.intellij.spring.web.mvc.jam.RequestMappingUtil;
import com.intellij.spring.web.mvc.toolWindow.SpringMvcRequestMappingsPanel;
import com.intellij.spring.web.mvc.toolWindow.SpringMvcViewUtils;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringMvcControllerPanel
extends SpringBeanPointerPanelBase {
    private final Module[] myModules;
    private static final Function<String, String> URL_TEXT = s -> {
        if (StringUtil.endsWithChar((CharSequence)s, (char)'/')) {
            return s + "*";
        }
        return s + "/*";
    };

    public SpringMvcControllerPanel(Project project) {
        super(project, "SpringMvcController");
        this.myModules = ModuleManager.getInstance((Project)project).getModules();
    }

    public SpringMvcControllerPanel(FinderRecursivePanel<Module> parent, @NotNull Module module) {
        if (module == null) {
            SpringMvcControllerPanel.$$$reportNull$$$0(0);
        }
        super(parent);
        this.myModules = new Module[]{module};
    }

    @NotNull
    protected List<SpringBeanPointer> getListItems() {
        CommonProcessors.CollectUniquesProcessor processor2 = new CommonProcessors.CollectUniquesProcessor();
        for (Module module : this.myModules) {
            SpringMvcViewUtils.processControllers(module, (Processor<? super SpringBeanPointer>)processor2);
        }
        ArrayList<SpringBeanPointer> pointers = new ArrayList<SpringBeanPointer>(processor2.getResults());
        Collections.sort(pointers, Comparator.comparing(arg_0 -> ((SpringMvcControllerPanel)this).getItemText(arg_0), NaturalComparator.INSTANCE));
        ArrayList<SpringBeanPointer> arrayList = pointers;
        if (arrayList == null) {
            SpringMvcControllerPanel.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    protected boolean hasChildren(SpringBeanPointer springBeanPointer) {
        return true;
    }

    protected void doCustomizeCellRenderer(SimpleColoredComponent comp, JList list, SpringBeanPointer value, int index, boolean selected, boolean hasFocus) {
        if (!value.isValid()) {
            return;
        }
        comp.clear();
        comp.setIcon(this.getItemIcon(value));
        if (value instanceof JamSpringBeanPointer) {
            this.renderController(comp, value);
        } else {
            comp.append(this.getItemText(value));
            comp.append(" (" + value.getContainingFile().getName() + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    private void renderController(SimpleColoredComponent comp, SpringBeanPointer springBeanPointer) {
        PsiClass controllerClass = springBeanPointer.getBeanClass();
        if (controllerClass != null) {
            RequestMapping<PsiClass> classMapping = RequestMappingUtil.getClassLevelMapping(controllerClass);
            if (classMapping != null) {
                comp.append(StringUtil.join(classMapping.getUrls(), URL_TEXT, (String)", "), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            } else {
                comp.append(this.getItemText(springBeanPointer));
            }
            String packageName = controllerClass.getQualifiedName();
            comp.append(" (" + packageName + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    @Nullable
    protected JComponent createRightComponent(SpringBeanPointer springBeanPointer) {
        return new SpringMvcRequestMappingsPanel((FinderRecursivePanel<SpringBeanPointer>)this, springBeanPointer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/web/mvc/toolWindow/SpringMvcControllerPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/web/mvc/toolWindow/SpringMvcControllerPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getListItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

