/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flex.model.bc;

import com.intellij.flex.FlexCommonBundle;
import com.intellij.flex.model.bc.OutputType;
import com.intellij.flex.model.bc.TargetPlatform;
import icons.FlexSharedIcons;
import javax.swing.Icon;

public class BuildConfigurationNature {
    public final TargetPlatform targetPlatform;
    public final boolean pureAS;
    public final OutputType outputType;
    public static final BuildConfigurationNature DEFAULT = new BuildConfigurationNature(TargetPlatform.Web, false, OutputType.Application);

    public BuildConfigurationNature(TargetPlatform targetPlatform, boolean pureAS, OutputType outputType) {
        this.targetPlatform = targetPlatform;
        this.pureAS = pureAS;
        this.outputType = outputType;
    }

    public boolean isWebPlatform() {
        return this.targetPlatform == TargetPlatform.Web;
    }

    public boolean isDesktopPlatform() {
        return this.targetPlatform == TargetPlatform.Desktop;
    }

    public boolean isMobilePlatform() {
        return this.targetPlatform == TargetPlatform.Mobile;
    }

    public boolean isApp() {
        return this.outputType == OutputType.Application;
    }

    public boolean isLib() {
        return this.outputType == OutputType.Library;
    }

    public String toString() {
        return this.targetPlatform.getPresentableText() + " " + this.outputType.getPresentableText() + (this.pureAS ? " (pure ActionScript)" : "");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        BuildConfigurationNature otherNature = (BuildConfigurationNature)other;
        if (this.pureAS != otherNature.pureAS) {
            return false;
        }
        if (this.outputType != otherNature.outputType) {
            return false;
        }
        return this.targetPlatform == otherNature.targetPlatform;
    }

    public int hashCode() {
        int result = this.targetPlatform.hashCode();
        result = 31 * result + (this.pureAS ? 1 : 0);
        result = 31 * result + this.outputType.hashCode();
        return result;
    }

    public Icon getIcon() {
        switch (this.targetPlatform) {
            case Web: {
                return this.pureAS ? FlexSharedIcons.Bc_web_as : FlexSharedIcons.Bc_web_flex;
            }
            case Desktop: {
                return this.pureAS ? FlexSharedIcons.Bc_desktop_as : FlexSharedIcons.Bc_desktop_flex;
            }
            case Mobile: {
                return this.pureAS ? FlexSharedIcons.Bc_mobile_as : FlexSharedIcons.Bc_mobile_flex;
            }
        }
        assert (false) : this.targetPlatform;
        return FlexSharedIcons.Bc_web_flex;
    }

    public String getPresentableText() {
        return FlexCommonBundle.message("bc.nature.presentable.text", this.pureAS ? 1 : 0, this.outputType.getPresentableText().toLowerCase(), this.targetPlatform.ordinal());
    }
}

