/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.runtime;

import com.yourkit.util.PresentableException;
import com.yourkit.util.Strings;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Packet {
    static final long MAGIC = 123456789L;

    private Packet() {
    }

    public static void writeHeader(@NotNull DataOutputStream stream, int packetType) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        Packet.writeLong(stream, 123456789L);
        Packet.writeInt(stream, packetType);
    }

    public static void writeHeader(@NotNull DataOutputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        Packet.writeHeader(stream, 1);
    }

    public static int readHeader(@NotNull DataInputStream stream, @NotNull String incompatibleVersionErrorMessage) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (incompatibleVersionErrorMessage == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        long magic = stream.readLong();
        if (123456789L != magic) {
            throw new IOException("Invalid header magic number:" + magic);
        }
        int packetType = stream.readInt();
        if (packetType == 0) {
            String error = Packet.readStringNotNull(stream);
            if (error.startsWith("Unknown packet type:")) {
                throw new PresentableException(incompatibleVersionErrorMessage, error);
            }
            throw new PresentableException(error);
        }
        return packetType;
    }

    public static void readHeaderWithStandardResponse(@NotNull DataInputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        Packet.readHeader(stream, 1, "Communication with the profiled application failed.\nThe profiled application has been started with profiler agent\nincompatible with the current version of the profiler.");
    }

    public static void readHeader(@NotNull DataInputStream stream, int expectedPacketType, @NotNull String incompatibleVersionErrorMessage) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (incompatibleVersionErrorMessage == null) {
            throw new IllegalArgumentException("Parameter 3 must not be null");
        }
        int packetType = Packet.readHeader(stream, incompatibleVersionErrorMessage);
        if (packetType != expectedPacketType) {
            throw new PresentableException(incompatibleVersionErrorMessage, "Wrong packet type: " + packetType + ", expected " + expectedPacketType);
        }
    }

    public static void writeInt(@NotNull DataOutputStream stream, int value) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        stream.writeInt(value);
    }

    public static void writeCount(@NotNull DataOutputStream stream, int value) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (value < 0) {
            throw new PresentableException("Communication failed.\nThe response contains incorrect data.", "negative count: " + value);
        }
        stream.writeInt(value);
    }

    public static int readInt(@NotNull DataInputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return stream.readInt();
    }

    public static int readCount(@NotNull DataInputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        int value = Packet.readInt(stream);
        if (value < 0) {
            throw new PresentableException("Communication failed.\nThe response contains incorrect data.", "negative count: " + value);
        }
        return value;
    }

    public static void writeBoolean(@NotNull DataOutputStream stream, boolean value) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        stream.writeByte(value ? 1 : 0);
    }

    public static boolean readBoolean(@NotNull DataInputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return stream.readByte() != 0;
    }

    public static void writeBytes(@NotNull DataOutputStream stream, @NotNull byte[] bytes, int length) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (bytes == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        stream.write(bytes, 0, length);
    }

    public static int readBytes(@NotNull DataInputStream stream, @NotNull byte[] bytes) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (bytes == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        return stream.read(bytes);
    }

    public static int readBytes(@NotNull DataInputStream stream, @NotNull byte[] bytes, int maxBytes) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (bytes == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        return stream.read(bytes, 0, maxBytes);
    }

    public static void writeLong(@NotNull DataOutputStream stream, long value) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        stream.writeLong(value);
    }

    public static long readLong(@NotNull DataInputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return stream.readLong();
    }

    public static void writeStringNullable(@NotNull DataOutputStream stream, @Nullable String string) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (string == null) {
            stream.writeInt(-1);
        } else {
            Packet.writeStringNotNull(stream, string);
        }
    }

    public static void writeStringNotNull(@NotNull DataOutputStream stream, @NotNull String string) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        byte[] utf = Strings.getUTF8Bytes(string);
        stream.writeInt(utf.length);
        for (byte b : utf) {
            stream.writeByte(b);
        }
    }

    @Nullable
    public static String readStringNullable(@NotNull DataInputStream stream) throws IOException {
        byte[] utf;
        if (stream == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        int length = stream.readInt();
        if (length == -1) {
            return null;
        }
        if (length < 0) {
            throw new PresentableException("Communication failed.\nThe response contains incorrect data.", "Negative string length: " + length);
        }
        try {
            utf = new byte[length];
        }
        catch (OutOfMemoryError ignored) {
            throw new PresentableException("Communication failed.\nThe response contains incorrect data.", "Cannot allocate " + length + " bytes");
        }
        for (int i = 0; i < utf.length; ++i) {
            utf[i] = stream.readByte();
        }
        return Strings.createUTF8String(utf);
    }

    @NotNull
    public static String readStringNotNull(@NotNull DataInputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String s = Packet.readStringNullable(stream);
        if (s == null) {
            throw new PresentableException("Communication failed.\nThe response contains incorrect data.", "Unexpected null string");
        }
        String string = s;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public static void flush(@NotNull DataOutputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        stream.flush();
    }
}

