/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.config;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsStructure;
import org.jetbrains.plugins.groovy.config.AbstractConfigUtils;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public class GrailsConfigUtils
extends AbstractConfigUtils {
    private static final Logger LOG = Logger.getInstance(GrailsConfigUtils.class);
    public static final Pattern CORE_JAR_PATTERN = Pattern.compile("grails-core-(?<version>\\d[^-]*(?:-SNAPSHOT)?)\\.jar");
    public static final Condition<Module> IS_GRAILS3_MODULE = module -> GrailsStructure.isVersionAtLeast("3.0", module);
    private static GrailsConfigUtils myGrailsConfigUtils;
    @NonNls
    private static final String GRAILS_MANIFEST_MF = "META-INF/GRAILS-MANIFEST.MF";
    @NonNls
    protected static final String DIST = "/dist";
    @NonNls
    static final String LIB_DIR = "/lib";

    private GrailsConfigUtils() {
        this.STARTER_SCRIPT_FILE_NAME = "grails";
    }

    public static GrailsConfigUtils getInstance() {
        if (myGrailsConfigUtils == null) {
            myGrailsConfigUtils = new GrailsConfigUtils();
        }
        return myGrailsConfigUtils;
    }

    public boolean isSDKLibrary(Library library) {
        if (library == null) {
            return false;
        }
        return GrailsConfigUtils.findGrailsJar(library.getFiles(OrderRootType.CLASSES)) != null;
    }

    @Nullable
    private static VirtualFile findGrailsJar(VirtualFile[] files) {
        for (VirtualFile file : files) {
            if (!GrailsConfigUtils.isGrailsCoreJar(file.getNameSequence())) continue;
            return VfsUtil.getLocalFile((VirtualFile)file);
        }
        return null;
    }

    public boolean isSDKHome(VirtualFile file) {
        if (file != null && file.isDirectory()) {
            String path = file.getPath();
            if (LibrariesUtil.getFilesInDirectoryByPattern((String)(path + LIB_DIR), (Pattern)CORE_JAR_PATTERN).length > 0) {
                return true;
            }
            if (LibrariesUtil.getFilesInDirectoryByPattern((String)(path + "/embeddable"), (Pattern)CORE_JAR_PATTERN).length > 0) {
                return true;
            }
            if (file.findFileByRelativePath("bin/" + this.STARTER_SCRIPT_FILE_NAME) != null) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public String getSDKVersion(@NotNull String path) {
        String grailsJarVersion;
        if (path == null) {
            GrailsConfigUtils.$$$reportNull$$$0(0);
        }
        if ((grailsJarVersion = GrailsConfigUtils.getSDKJarVersion((String)(path + DIST), (Pattern)CORE_JAR_PATTERN, (String)"META-INF/MANIFEST.MF")) == null) {
            grailsJarVersion = GrailsConfigUtils.getSDKJarVersion((String)(path + DIST), (Pattern)CORE_JAR_PATTERN, (String)GRAILS_MANIFEST_MF);
        }
        String string = grailsJarVersion == null ? "undefined" : grailsJarVersion;
        if (string == null) {
            GrailsConfigUtils.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public static String getGrailsVersion(@Nullable Module module) {
        if (module == null) {
            return null;
        }
        return GrailsConfigUtils.getGrailsVersion(OrderEnumerator.orderEntries((Module)module).getAllLibrariesAndSdkClassesRoots());
    }

    @Nullable
    public static String getGrailsVersion(@NotNull VirtualFile[] files) {
        if (files == null) {
            GrailsConfigUtils.$$$reportNull$$$0(2);
        }
        for (VirtualFile file : files) {
            Matcher m = CORE_JAR_PATTERN.matcher(file.getName());
            if (!m.matches()) continue;
            return m.group(1);
        }
        return null;
    }

    @Nullable
    public static VirtualFile getSDKInstallPath(@Nullable Module module) {
        if (module == null) {
            return null;
        }
        return GrailsConfigUtils.getGrailsLibraryHome(OrderEnumerator.orderEntries((Module)module).getAllLibrariesAndSdkClassesRoots());
    }

    @Nullable
    public static VirtualFile getGrailsLibraryHome(VirtualFile[] files) {
        for (VirtualFile file : files) {
            VirtualFile grailsJar;
            VirtualFile parent;
            if (!GrailsConfigUtils.isGrailsCoreJar(file.getNameSequence()) || (parent = (grailsJar = VfsUtil.getLocalFile((VirtualFile)file)).getParent()) == null) continue;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return parent;
            }
            if (!Comparing.equal((CharSequence)"dist", (CharSequence)parent.getNameSequence())) continue;
            return parent.getParent();
        }
        return null;
    }

    public static boolean isAtLeastGrails(Module module, String version) {
        String currentVersion = GrailsConfigUtils.getGrailsVersion(module);
        return currentVersion != null && currentVersion.compareTo(version) >= 0;
    }

    public static boolean isGrailsLessThan(Module module, String version) {
        String currentVersion = GrailsConfigUtils.getGrailsVersion(module);
        return currentVersion != null && currentVersion.compareTo(version) < 0;
    }

    public static boolean isAtLeastGrails1_1(Module module) {
        return GrailsConfigUtils.isAtLeastGrails(module, "1.1");
    }

    public static boolean isAtLeastGrails1_2(Module module) {
        return GrailsConfigUtils.isAtLeastGrails(module, "1.2");
    }

    public static boolean isAtLeastGrails1_3(Module module) {
        return GrailsConfigUtils.isAtLeastGrails(module, "1.3");
    }

    public static boolean isAtLeastGrails1_4(Module module) {
        return GrailsConfigUtils.isAtLeastGrails(module, "1.4");
    }

    public static boolean isAtLeastGrails2_0(Module module) {
        return GrailsConfigUtils.isAtLeastGrails(module, "2.0");
    }

    public static boolean isAtLeastGrails2_1(Module module) {
        return GrailsConfigUtils.isAtLeastGrails(module, "2.1");
    }

    public static boolean isGrailsCoreJar(CharSequence fileName) {
        return CORE_JAR_PATTERN.matcher(fileName).matches();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/config/GrailsConfigUtils";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/config/GrailsConfigUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSDKVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSDKVersion";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getGrailsVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

