/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.pluginSupport.resources;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.pluginSupport.resources.GrailsResourceModuleReference;
import org.jetbrains.plugins.grails.references.GrailsMethodNamedArgumentReferenceProvider;
import org.jetbrains.plugins.grails.references.common.GrailsFileReferenceSetBase;
import org.jetbrains.plugins.grails.util.SafeReference;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.resolve.GroovyStringLiteralManipulator;
import org.jetbrains.plugins.groovy.util.LightCacheKey;

public class GrailsResourcesReferenceProvider
implements GrailsMethodNamedArgumentReferenceProvider.Contributor {
    @Override
    public void register(GrailsMethodNamedArgumentReferenceProvider registrar) {
        GrailsMethodNamedArgumentReferenceProvider.Contributor.ClassNameCondition classNameCondition = new GrailsMethodNamedArgumentReferenceProvider.Contributor.ClassNameCondition("org.grails.plugin.resource.module.ModuleBuilder");
        registrar.register((Object)-1, ResourceModuleReferenceProvider.class, (Condition<PsiMethod>)classNameCondition, "dependsOn");
        registrar.register((Object)0, ResourceUrlReferenceProvider.class, (Condition<PsiMethod>)classNameCondition, "resource");
        registrar.register((Object)"url", ResourceUrlReferenceProvider.class, (Condition<PsiMethod>)classNameCondition, "resource");
    }

    public static class ResourceModuleReferenceProvider
    extends GrailsMethodNamedArgumentReferenceProvider.Contributor.Provider {
        private static final LightCacheKey<PsiReference[]> KEY = LightCacheKey.create();
        private static final Pattern ourPattern = Pattern.compile("[^\\s,]+");

        public static PsiReference[] createManyModuleReferences(@NotNull PsiElement element, @NotNull String value, int offset) {
            PsiReference[] cachedValue;
            if (element == null) {
                ResourceModuleReferenceProvider.$$$reportNull$$$0(0);
            }
            if (value == null) {
                ResourceModuleReferenceProvider.$$$reportNull$$$0(1);
            }
            if ((cachedValue = (PsiReference[])KEY.getCachedValue(element)) != null) {
                return cachedValue;
            }
            ArrayList<GrailsResourceModuleReference> res = new ArrayList<GrailsResourceModuleReference>();
            Matcher matcher = ourPattern.matcher(value);
            while (matcher.find()) {
                TextRange range = new TextRange(offset + matcher.start(), offset + matcher.end());
                res.add(new GrailsResourceModuleReference(element, range, false));
            }
            PsiReference[] resArray = res.toArray(PsiReference.EMPTY_ARRAY);
            SafeReference.makeReferencesSafe(resArray);
            resArray = (PsiReference[])KEY.putCachedValue(element, (Object)resArray);
            return resArray;
        }

        @Override
        public PsiReference[] createRef(@NotNull PsiElement element, @NotNull GrMethodCall methodCall, int argumentIndex, @NotNull GroovyResolveResult method) {
            if (element == null) {
                ResourceModuleReferenceProvider.$$$reportNull$$$0(2);
            }
            if (methodCall == null) {
                ResourceModuleReferenceProvider.$$$reportNull$$$0(3);
            }
            if (method == null) {
                ResourceModuleReferenceProvider.$$$reportNull$$$0(4);
            }
            GrLiteralImpl literal = (GrLiteralImpl)element;
            String value = (String)literal.getValue();
            assert (value != null);
            if (value.contains(",")) {
                int startInElement = GroovyStringLiteralManipulator.getLiteralRange((String)element.getText()).getStartOffset();
                return ResourceModuleReferenceProvider.createManyModuleReferences(element, value, startInElement);
            }
            return new PsiReference[]{new GrailsResourceModuleReference(element, false)};
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodCall";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/grails/pluginSupport/resources/GrailsResourcesReferenceProvider$ResourceModuleReferenceProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createManyModuleReferences";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createRef";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ResourceUrlReferenceProvider
    extends GrailsMethodNamedArgumentReferenceProvider.Contributor.Provider {
        @Override
        protected PsiReference[] createRef(@NotNull PsiElement element, @NotNull GroovyResolveResult method) {
            if (element == null) {
                ResourceUrlReferenceProvider.$$$reportNull$$$0(0);
            }
            if (method == null) {
                ResourceUrlReferenceProvider.$$$reportNull$$$0(1);
            }
            String text = element.getText();
            assert (element instanceof GrLiteralImpl);
            TextRange range = GroovyStringLiteralManipulator.getLiteralRange((String)text);
            String value = range.substring(text);
            if (value.contains(":/")) {
                return PsiReference.EMPTY_ARRAY;
            }
            VirtualFile root = GrailsFramework.getInstance().findAppRoot(element);
            if (root == null) {
                return PsiReference.EMPTY_ARRAY;
            }
            final VirtualFile webApp = root.findChild("web-app");
            if (webApp == null) {
                return PsiReference.EMPTY_ARRAY;
            }
            GrailsFileReferenceSetBase set = new GrailsFileReferenceSetBase(value, element, range.getStartOffset(), null, true, true){

                @Override
                protected VirtualFile getDefaultContext(boolean isAbsolute) {
                    return webApp;
                }
            };
            return set.getAllReferences();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "method";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/grails/pluginSupport/resources/GrailsResourcesReferenceProvider$ResourceUrlReferenceProvider";
            objectArray[2] = "createRef";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

