/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.common;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.lang.gsp.GspFileViewProvider;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspFile;
import org.jetbrains.plugins.grails.util.GrailsUtils;

public class GrailsLayoutFileReferenceSet
extends FileReferenceSet {
    private final VirtualFile myLayoutDir;

    public GrailsLayoutFileReferenceSet(@NotNull String trimedUrl, @NotNull PsiElement element, int offset, @NotNull VirtualFile layoutDir) {
        if (trimedUrl == null) {
            GrailsLayoutFileReferenceSet.$$$reportNull$$$0(0);
        }
        if (element == null) {
            GrailsLayoutFileReferenceSet.$$$reportNull$$$0(1);
        }
        if (layoutDir == null) {
            GrailsLayoutFileReferenceSet.$$$reportNull$$$0(2);
        }
        super(trimedUrl, element, offset, null, true, false);
        this.myLayoutDir = layoutDir;
    }

    protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
        return new Condition<PsiFileSystemItem>(){
            private final ProjectFileIndex fileIndex;
            {
                this.fileIndex = ProjectRootManager.getInstance((Project)GrailsLayoutFileReferenceSet.this.getElement().getProject()).getFileIndex();
            }

            public boolean value(PsiFileSystemItem psiFileSystemItem) {
                VirtualFile file = psiFileSystemItem.getVirtualFile();
                if (file == null || !this.fileIndex.isInContent(file)) {
                    return false;
                }
                return !(psiFileSystemItem instanceof PsiFile) || ((PsiFile)psiFileSystemItem).getViewProvider() instanceof GspFileViewProvider;
            }
        };
    }

    public FileReference createFileReference(TextRange range, int index, String text) {
        return new LayoutFileReference(this, range, index, text);
    }

    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        PsiDirectory directory = this.getElement().getManager().findDirectory(this.myLayoutDir);
        List<Object> list = directory == null ? Collections.emptyList() : Collections.singletonList(directory);
        if (list == null) {
            GrailsLayoutFileReferenceSet.$$$reportNull$$$0(3);
        }
        return list;
    }

    public static PsiReference[] createReferences(@NotNull PsiElement element) {
        VirtualFile viewsDirectory;
        if (element == null) {
            GrailsLayoutFileReferenceSet.$$$reportNull$$$0(4);
        }
        if ((viewsDirectory = GrailsUtils.findViewsDirectory(element)) == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        VirtualFile layoutDir = viewsDirectory.findChild("layouts");
        if (layoutDir == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)element);
        assert (manipulator != null);
        TextRange range = manipulator.getRangeInElement(element);
        int offset = range.getStartOffset();
        String text = range.substring(element.getText());
        String trimedUrl = PathReference.trimPath((String)text);
        GrailsLayoutFileReferenceSet set = new GrailsLayoutFileReferenceSet(trimedUrl, element, offset, layoutDir);
        return set.getAllReferences();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trimedUrl";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/references/common/GrailsLayoutFileReferenceSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/references/common/GrailsLayoutFileReferenceSet";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDefaultContexts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createReferences";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LayoutFileReference
    extends FileReference {
        LayoutFileReference(@NotNull FileReferenceSet fileReferenceSet, TextRange range, int index, String text) {
            if (fileReferenceSet == null) {
                LayoutFileReference.$$$reportNull$$$0(0);
            }
            super(fileReferenceSet, range, index, text);
        }

        public void innerResolveInContext(@NotNull String text, @NotNull PsiFileSystemItem context, Collection<ResolveResult> result2, boolean caseSensitive) {
            if (text == null) {
                LayoutFileReference.$$$reportNull$$$0(1);
            }
            if (context == null) {
                LayoutFileReference.$$$reportNull$$$0(2);
            }
            super.innerResolveInContext(this.isLast() && !text.endsWith(".gsp") ? text + ".gsp" : text, context, result2, caseSensitive);
        }

        public PsiElement bindToElement(@NotNull PsiElement element, boolean absolute) throws IncorrectOperationException {
            PsiFileSystemItem fileSystemItem;
            VirtualFile dstVFile;
            if (element == null) {
                LayoutFileReference.$$$reportNull$$$0(3);
            }
            if ((dstVFile = (fileSystemItem = (PsiFileSystemItem)element).getVirtualFile()) == null) {
                throw new IncorrectOperationException("Cannot bind to non-physical element:" + element);
            }
            VirtualFile layoutDir = ((GrailsLayoutFileReferenceSet)this.getFileReferenceSet()).myLayoutDir;
            String path = VfsUtilCore.getRelativePath((VirtualFile)dstVFile, (VirtualFile)layoutDir, (char)'/');
            if (path == null) {
                return this.getElement();
            }
            path = StringUtil.trimEnd((String)path, (String)".gsp");
            return this.rename(path);
        }

        protected Object createLookupItem(PsiElement candidate) {
            if (candidate instanceof GspFile) {
                PsiFile file = (PsiFile)candidate;
                String templateName = StringUtil.trimEnd((String)file.getName(), (String)".gsp");
                return LookupElementBuilder.create((String)templateName).withIcon(file.getIcon(0));
            }
            return super.createLookupItem(candidate);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileReferenceSet";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/grails/references/common/GrailsLayoutFileReferenceSet$LayoutFileReference";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "innerResolveInContext";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "bindToElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

