/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.runner;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunProfileWithCompileBeforeLaunchOption;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.JdomKt;
import com.intellij.util.containers.ContainerUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.runner.GrailsCommandExecutor;
import org.jetbrains.plugins.grails.runner.GrailsRunConfigurationExtension;
import org.jetbrains.plugins.grails.runner.LocatableRunConfigurationWithCommonParameters;
import org.jetbrains.plugins.grails.runner.ui.GrailsRunConfigurationEditor;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.GrailsApplicationManager;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;

public class GrailsRunConfiguration
extends LocatableRunConfigurationWithCommonParameters
implements RunProfileWithCompileBeforeLaunchOption {
    private static final String ROOT_ELEMENT_NAME = "grailsApplicationRoot";
    private static final String LAUNCH_BROWSER = "launchBrowser";
    private static final String LAUNCH_BROWSER_URL = "launchBrowserUrl";
    @Nullable
    private String myGrailsApplicationRootPath;
    private boolean myLaunchBrowser;
    @Nullable
    private String myLaunchBrowserUrl;
    @Nullable
    private RunConfigurationModule myConfigurationModule;

    public GrailsRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory, String name) {
        if (project == null) {
            GrailsRunConfiguration.$$$reportNull$$$0(0);
        }
        if (factory == null) {
            GrailsRunConfiguration.$$$reportNull$$$0(1);
        }
        super(project, factory, name);
        this.setProgramParameters("run-app");
        this.myLaunchBrowser = true;
    }

    public boolean isLaunchBrowser() {
        return this.myLaunchBrowser;
    }

    public void setLaunchBrowser(boolean launchBrowser) {
        this.myLaunchBrowser = launchBrowser;
    }

    @Nullable
    public String getLaunchBrowserUrl() {
        return StringUtil.nullize((String)this.myLaunchBrowserUrl, (boolean)true);
    }

    public void setLaunchBrowserUrl(@Nullable String launchBrowserUrl) {
        this.myLaunchBrowserUrl = StringUtil.nullize((String)launchBrowserUrl, (boolean)true);
    }

    @NotNull
    public SettingsEditor<GrailsRunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        GrailsRunConfigurationEditor runConfigurationEditor = new GrailsRunConfigurationEditor(this.getProject());
        group.addEditor("Grails", (SettingsEditor)runConfigurationEditor);
        List configurationExtensions = ContainerUtil.findAll((Object[])GrailsCommandExecutor.EP_NAME.getExtensions(), GrailsRunConfigurationExtension.class);
        for (GrailsRunConfigurationExtension extension : configurationExtensions) {
            Pair<String, SettingsEditor<GrailsRunConfiguration>> pair;
            SettingsEditor<GrailsRunConfiguration> extensionEditor = extension.createExtensionEditor();
            if (extensionEditor != null) {
                runConfigurationEditor.addExtension(extensionEditor);
            }
            if ((pair = extension.createSettingsEditor(this.getProject())) == null) continue;
            group.addEditor((String)pair.first, (SettingsEditor)pair.second);
        }
        JavaRunConfigurationExtensionManager.getInstance().appendEditors((RunConfigurationBase)this, group);
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            GrailsRunConfiguration.$$$reportNull$$$0(2);
        }
        return settingsEditorGroup;
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (executor == null) {
            GrailsRunConfiguration.$$$reportNull$$$0(3);
        }
        if (environment == null) {
            GrailsRunConfiguration.$$$reportNull$$$0(4);
        }
        GrailsCommandExecutor grailsExecutor = this.getGrailsExecutor();
        return grailsExecutor.getState(this, executor, environment);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        String browserUrl;
        GrailsApplication grailsApplication2 = this.getGrailsApplicationNullable();
        if (grailsApplication2 == null) {
            throw new RuntimeConfigurationException("Grails application is not selected");
        }
        MvcCommand grailsCommand = this.getGrailsCommandNullable();
        if (grailsCommand == null) {
            throw new RuntimeConfigurationException("Command is not specified");
        }
        GrailsCommandExecutor grailsExecutor = GrailsCommandExecutor.getGrailsExecutor(grailsApplication2);
        if (grailsExecutor == null) {
            throw new RuntimeConfigurationException("Cannot execute: " + grailsApplication2.getRoot().getPath());
        }
        if (this.isLaunchBrowser() && (browserUrl = this.getLaunchBrowserUrl()) != null) {
            try {
                new URL(browserUrl);
            }
            catch (MalformedURLException e) {
                throw new RuntimeConfigurationException("Invalid launch URL");
            }
        }
    }

    @Override
    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            GrailsRunConfiguration.$$$reportNull$$$0(5);
        }
        super.readExternal(element);
        String grailsApplicationRootPath = JDOMExternalizer.readString((Element)element, (String)ROOT_ELEMENT_NAME);
        if (grailsApplicationRootPath != null) {
            this.myGrailsApplicationRootPath = grailsApplicationRootPath;
        } else {
            this.myConfigurationModule = new RunConfigurationModule(this.getProject());
            this.myConfigurationModule.readExternal(element);
        }
        this.myLaunchBrowser = !"false".equals(JDOMExternalizer.readString((Element)element, (String)LAUNCH_BROWSER));
        this.myLaunchBrowserUrl = JDOMExternalizer.readString((Element)element, (String)LAUNCH_BROWSER_URL);
        List configurationExtensions = ContainerUtil.findAll((Object[])GrailsCommandExecutor.EP_NAME.getExtensions(), GrailsRunConfigurationExtension.class);
        for (GrailsRunConfigurationExtension extension : configurationExtensions) {
            Object additionalConfiguration = extension.readAdditionalConfiguration(element);
            this.putUserData(extension.getKey(), additionalConfiguration);
        }
        JavaRunConfigurationExtensionManager.getInstance().readExternal((RunConfigurationBase)this, element);
    }

    @Override
    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            GrailsRunConfiguration.$$$reportNull$$$0(6);
        }
        super.writeExternal(element);
        if (this.getGrailsApplicationRootPath() != null) {
            JDOMExternalizer.write((Element)element, (String)ROOT_ELEMENT_NAME, (String)this.getGrailsApplicationRootPath());
        }
        JdomKt.addOptionTag((Element)element, (String)LAUNCH_BROWSER, (String)Boolean.toString(this.myLaunchBrowser), (String)"setting");
        JDOMExternalizer.write((Element)element, (String)LAUNCH_BROWSER_URL, (String)this.myLaunchBrowserUrl);
        List configurationExtensions = ContainerUtil.findAll((Object[])GrailsCommandExecutor.EP_NAME.getExtensions(), GrailsRunConfigurationExtension.class);
        for (GrailsRunConfigurationExtension extension : configurationExtensions) {
            Object additionalConfiguration = this.getUserData(extension.getKey());
            if (additionalConfiguration == null) continue;
            extension.writeAdditionalConfiguration(additionalConfiguration, element);
        }
        JavaRunConfigurationExtensionManager.getInstance().writeExternal((RunConfigurationBase)this, element);
    }

    @Nullable
    public String getGrailsApplicationRootPath() {
        VirtualFile[] roots;
        Module module;
        if (this.myGrailsApplicationRootPath == null && this.myConfigurationModule != null && (module = this.myConfigurationModule.getModule()) != null && (roots = ModuleRootManager.getInstance((Module)module).getContentRoots()).length == 1) {
            this.myGrailsApplicationRootPath = roots[0].getPath();
        }
        return this.myGrailsApplicationRootPath;
    }

    @Nullable
    public GrailsApplication getGrailsApplicationNullable() {
        String path = this.getGrailsApplicationRootPath();
        if (path == null) {
            return null;
        }
        return GrailsApplicationManager.getInstance(this.getProject()).getApplicationByRoot(LocalFileSystem.getInstance().findFileByPath(path));
    }

    @NotNull
    public GrailsApplication getGrailsApplication() throws ExecutionException {
        GrailsApplication application = this.getGrailsApplicationNullable();
        if (application == null) {
            throw new ExecutionException("Grails application is not found");
        }
        GrailsApplication grailsApplication2 = application;
        if (grailsApplication2 == null) {
            GrailsRunConfiguration.$$$reportNull$$$0(7);
        }
        return grailsApplication2;
    }

    public void setGrailsApplication(@Nullable GrailsApplication grailsApplication2) {
        this.myGrailsApplicationRootPath = grailsApplication2 == null ? null : grailsApplication2.getRoot().getPath();
    }

    @NotNull
    public GrailsCommandExecutor getGrailsExecutor() throws ExecutionException {
        GrailsApplication grailsApplication2 = this.getGrailsApplication();
        GrailsCommandExecutor grailsExecutor = GrailsCommandExecutor.getGrailsExecutor(grailsApplication2);
        if (grailsExecutor == null) {
            throw new ExecutionException("Cannot execute: " + grailsApplication2.getRoot().getPath());
        }
        GrailsCommandExecutor grailsCommandExecutor = grailsExecutor;
        if (grailsCommandExecutor == null) {
            GrailsRunConfiguration.$$$reportNull$$$0(8);
        }
        return grailsCommandExecutor;
    }

    @Nullable
    public MvcCommand getGrailsCommandNullable() {
        String parameters = this.getProgramParameters();
        if (parameters == null) {
            return null;
        }
        return MvcCommand.parse((String)parameters).setVmOptions(this.getVMParameters()).setEnvVariables(this.getEnvs()).setPassParentEnvs(this.isPassParentEnvs());
    }

    @NotNull
    public MvcCommand getGrailsCommand() throws ExecutionException {
        String parameters = this.getProgramParameters();
        if (parameters == null) {
            throw new ExecutionException("Program parameters are empty");
        }
        MvcCommand mvcCommand = MvcCommand.parse((String)parameters).setVmOptions(this.getVMParameters()).setEnvVariables(this.getEnvs()).setPassParentEnvs(this.isPassParentEnvs());
        if (mvcCommand == null) {
            GrailsRunConfiguration.$$$reportNull$$$0(9);
        }
        return mvcCommand;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/runner/GrailsRunConfiguration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/runner/GrailsRunConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGrailsApplication";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGrailsExecutor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getGrailsCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

