/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.runner;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.actions.GrailsActionUtilKt;
import org.jetbrains.plugins.grails.runner.GrailsRunConfiguration;
import org.jetbrains.plugins.grails.runner.GrailsRunConfigurationType;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.util.version.Version;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyNamesUtil;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;

public class GrailsScriptRunConfigurationProducer
extends RunConfigurationProducer<GrailsRunConfiguration> {
    public GrailsScriptRunConfigurationProducer() {
        super((ConfigurationType)GrailsRunConfigurationType.getInstance());
    }

    protected boolean setupConfigurationFromContext(GrailsRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        GrailsApplication application = GrailsActionUtilKt.getGrailsApplication(context.getDataContext());
        if (application == null) {
            return false;
        }
        PsiElement element = context.getPsiLocation();
        if (!(element instanceof GroovyFile)) {
            return false;
        }
        GroovyFile file = (GroovyFile)element;
        VirtualFile virtualFile = file.getOriginalFile().getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile scriptDir = GrailsScriptRunConfigurationProducer.getScriptsDirectory(application);
        if (scriptDir == null || !scriptDir.equals(virtualFile.getParent())) {
            return false;
        }
        if (!file.isScript() || !MvcFramework.isScriptFileName((String)virtualFile.getName())) {
            return false;
        }
        String scriptName = virtualFile.getNameWithoutExtension();
        configuration.setProgramParameters(GroovyNamesUtil.camelToSnake((String)scriptName));
        configuration.setGrailsApplication(application);
        configuration.setName("Grails: " + scriptName);
        sourceElement.set((Object)file);
        return true;
    }

    public boolean isConfigurationFromContext(GrailsRunConfiguration configuration, ConfigurationContext context) {
        PsiElement element = context.getPsiLocation();
        if (!(element instanceof GroovyFile)) {
            return false;
        }
        GrailsRunConfiguration fromContext = (GrailsRunConfiguration)configuration.clone();
        if (this.setupConfigurationFromContext(fromContext, context, (Ref<PsiElement>)new Ref((Object)element))) {
            return Comparing.equal((String)configuration.getProgramParameters(), (String)fromContext.getProgramParameters()) && Comparing.equal((Object)configuration.getGrailsApplicationNullable(), (Object)fromContext.getGrailsApplicationNullable());
        }
        return false;
    }

    @Nullable
    public static VirtualFile getScriptsDirectory(@NotNull GrailsApplication application) {
        if (application == null) {
            GrailsScriptRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        return application.getGrailsVersion().isAtLeast(Version.GRAILS_3_0) ? VfsUtil.findRelativeFile((VirtualFile)application.getRoot(), (String[])new String[]{"src", "main", "scripts"}) : VfsUtil.findRelativeFile((VirtualFile)application.getRoot(), (String[])new String[]{"scripts"});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "org/jetbrains/plugins/grails/runner/GrailsScriptRunConfigurationProducer", "getScriptsDirectory"));
    }
}

