/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.tests.runner;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.runner.GrailsRunConfiguration;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.tests.runner.OldUtilsKt;
import org.jetbrains.plugins.grails.util.version.VersionsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a \u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a \u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u000bH\u0000\u001a\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0011*\u00020\u000bH\u0002\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0001X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\u00a8\u0006\u0013"}, d2={"integrationTestKeyV3", "", "getIntegrationTestKeyV3", "()Ljava/lang/String;", "unitTestKeyV3", "getUnitTestKeyV3", "setupConfigurationByDir", "", "configuration", "Lorg/jetbrains/plugins/grails/runner/GrailsRunConfiguration;", "application", "Lorg/jetbrains/plugins/grails/structure/GrailsApplication;", "dir", "Lcom/intellij/psi/PsiDirectory;", "setupConfigurationByDirOld", "setupConfigurationByDirV3", "findIntegrationTestDirV3", "Lcom/intellij/openapi/vfs/VirtualFile;", "findTestDirV3", "intellij.groovy.grails"})
public final class ByDirectoryKt {
    @NotNull
    private static final String unitTestKeyV3 = "-unit";
    @NotNull
    private static final String integrationTestKeyV3 = "-integration";

    public static final boolean setupConfigurationByDir(@NotNull GrailsRunConfiguration configuration, @NotNull GrailsApplication application, @NotNull PsiDirectory dir) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        return application.getGrailsVersion().compareTo(VersionsKt.getV3()) >= 0 ? ByDirectoryKt.setupConfigurationByDirV3(configuration, application, dir) : ByDirectoryKt.setupConfigurationByDirOld(configuration, application, dir);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean setupConfigurationByDirV3(GrailsRunConfiguration configuration, GrailsApplication application, PsiDirectory dir) {
        CharSequence charSequence;
        boolean bl;
        VirtualFile virtualFile = dir.getVirtualFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"dir.virtualFile");
        VirtualFile directory = virtualFile;
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)dir.getProject());
        Intrinsics.checkExpressionValueIsNotNull((Object)projectRootManager, (String)"ProjectRootManager.getInstance(dir.project)");
        ProjectFileIndex projectFileIndex = projectRootManager.getFileIndex();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectFileIndex, (String)"ProjectRootManager.getIn\u2026ce(dir.project).fileIndex");
        ProjectFileIndex fileIndex = projectFileIndex;
        String packageName = fileIndex.getPackageNameByDirectory(directory);
        VirtualFile integrationTestsDir = ByDirectoryKt.findIntegrationTestDirV3(application);
        VirtualFile testsDir = ByDirectoryKt.findTestDirV3(application);
        if (packageName == null) {
            VirtualFile virtualFile2 = directory;
            if (Intrinsics.areEqual((Object)virtualFile2, (Object)testsDir)) {
                bl = false;
            } else {
                if (!Intrinsics.areEqual((Object)virtualFile2, (Object)integrationTestsDir)) return false;
                bl = true;
            }
        } else if (testsDir != null && VfsUtilCore.isAncestor((VirtualFile)testsDir, (VirtualFile)directory, (boolean)true)) {
            bl = false;
        } else {
            if (integrationTestsDir == null || !VfsUtilCore.isAncestor((VirtualFile)integrationTestsDir, (VirtualFile)directory, (boolean)true)) return false;
            bl = true;
        }
        boolean integrationTest = bl;
        StringBuilder configurationName = new StringBuilder(integrationTest ? "Grails integration tests" : "Grails tests");
        StringBuilder parameters = new StringBuilder("test-app");
        if (packageName != null && !((charSequence = (CharSequence)packageName).length() == 0)) {
            configurationName.append(": ").append(packageName);
            parameters.append(" ").append(packageName).append(".**");
        }
        parameters.append(" ").append(integrationTest ? integrationTestKeyV3 : unitTestKeyV3);
        configuration.setName(configurationName.toString());
        configuration.setProgramParameters(parameters.toString());
        return true;
    }

    @NotNull
    public static final String getUnitTestKeyV3() {
        return unitTestKeyV3;
    }

    @NotNull
    public static final String getIntegrationTestKeyV3() {
        return integrationTestKeyV3;
    }

    private static final VirtualFile findTestDirV3(@NotNull GrailsApplication $receiver) {
        return VfsUtil.findRelativeFile((VirtualFile)$receiver.getRoot(), (String[])new String[]{"src", "test"});
    }

    @Nullable
    public static final VirtualFile findIntegrationTestDirV3(@NotNull GrailsApplication $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return VfsUtil.findRelativeFile((VirtualFile)$receiver.getRoot(), (String[])new String[]{"src", "integration-test"});
    }

    private static final boolean setupConfigurationByDirOld(GrailsRunConfiguration configuration, GrailsApplication application, PsiDirectory dir) {
        CharSequence charSequence;
        VirtualFile virtualFile = dir.getVirtualFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"dir.virtualFile");
        VirtualFile directory = virtualFile;
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)dir.getProject());
        Intrinsics.checkExpressionValueIsNotNull((Object)projectRootManager, (String)"ProjectRootManager.getInstance(dir.project)");
        ProjectFileIndex projectFileIndex = projectRootManager.getFileIndex();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectFileIndex, (String)"ProjectRootManager.getIn\u2026ce(dir.project).fileIndex");
        ProjectFileIndex fileIndex = projectFileIndex;
        if (!fileIndex.isInTestSourceContent(directory)) {
            return false;
        }
        VirtualFile virtualFile2 = fileIndex.getSourceRootForFile(directory);
        if (virtualFile2 == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"fileIndex.getSourceRootF\u2026irectory) ?: return false");
        VirtualFile srcRoot = virtualFile2;
        String string = OldUtilsKt.getParamKeyByTestRoot(application, srcRoot);
        if (string == null) {
            return false;
        }
        String testKind = string;
        StringBuilder configurationName = new StringBuilder("Grails " + testKind + " tests");
        StringBuilder parameters = new StringBuilder("test-app");
        parameters.append(" ").append(testKind);
        String packageName = fileIndex.getPackageNameByDirectory(directory);
        if (packageName != null && (charSequence = (CharSequence)packageName).length() > 0) {
            configurationName.append(": ").append(packageName);
            parameters.append(" ").append(packageName).append(".**");
        }
        configuration.setName(configurationName.toString());
        configuration.setProgramParameters(parameters.toString());
        return true;
    }

    static {
        unitTestKeyV3 = unitTestKeyV3;
        integrationTestKeyV3 = integrationTestKeyV3;
    }
}

