/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.grails.annotator;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.config.GrailsSettingSynchronizer;
import org.jetbrains.plugins.grails.config.GrailsSettingsService;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.GrailsApplicationManager;
import org.jetbrains.plugins.grails.structure.impl.Grails2Application;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class GrailsSynchronizeStructureAnnotator
implements Annotator,
DumbAware {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            GrailsSynchronizeStructureAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            GrailsSynchronizeStructureAnnotator.$$$reportNull$$$0(1);
        }
        if (!(element instanceof GroovyFile)) {
            return;
        }
        VirtualFile file = ((GroovyFile)element).getVirtualFile();
        if (file == null || !file.getName().equals("BuildConfig.groovy")) {
            return;
        }
        VirtualFile confDir = file.getParent();
        if (confDir == null || !confDir.getName().equals("conf")) {
            return;
        }
        VirtualFile grailsApp = confDir.getParent();
        if (grailsApp == null || !grailsApp.getName().equals("grails-app")) {
            return;
        }
        GrailsApplication application = GrailsApplicationManager.getInstance(element.getProject()).findApplication(grailsApp);
        if (!(application instanceof Grails2Application)) {
            return;
        }
        final Grails2Application grails2Application = (Grails2Application)application;
        if (GrailsSettingSynchronizer.isUpdateSettingRunning(grails2Application.getProject())) {
            return;
        }
        if (!GrailsSettingsService.getGrailsSettings(grails2Application.getModule()).isBuildConfigOutdated(element.getText())) {
            return;
        }
        Annotation annotation = holder.createWarningAnnotation(element, "Grails configuration may be outdated");
        annotation.setFileLevelAnnotation(true);
        annotation.registerFix(new IntentionAction(){

            @NotNull
            public String getText() {
                if ("Apply Grails changes to IDEA project structure" == null) {
                    1.$$$reportNull$$$0(0);
                }
                return "Apply Grails changes to IDEA project structure";
            }

            @NotNull
            public String getFamilyName() {
                if ("Apply" == null) {
                    1.$$$reportNull$$$0(1);
                }
                return "Apply";
            }

            public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                if (project == null) {
                    1.$$$reportNull$$$0(2);
                }
                return true;
            }

            public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
                if (project == null) {
                    1.$$$reportNull$$$0(3);
                }
                GrailsFramework.forceSynchronizationSetting(grails2Application.getModule());
            }

            public boolean startInWriteAction() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/groovy/grails/annotator/GrailsSynchronizeStructureAnnotator$1";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/groovy/grails/annotator/GrailsSynchronizeStructureAnnotator$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "isAvailable";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "invoke";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        annotation.registerFix(new IntentionAction(){

            @NotNull
            public String getText() {
                if ("Ignore" == null) {
                    2.$$$reportNull$$$0(0);
                }
                return "Ignore";
            }

            @NotNull
            public String getFamilyName() {
                String string = this.getText();
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                if (project == null) {
                    2.$$$reportNull$$$0(2);
                }
                return true;
            }

            public void invoke(@NotNull Project project, Editor editor, PsiFile f) throws IncorrectOperationException {
                if (project == null) {
                    2.$$$reportNull$$$0(3);
                }
                FileDocumentManager.getInstance().saveAllDocuments();
                GrailsSettingsService.getGrailsSettings(grails2Application.getModule()).updateBuildConfig(f.getText());
                DaemonCodeAnalyzer.getInstance((Project)project).restart();
            }

            @Nullable
            public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(4);
                }
                return null;
            }

            public boolean startInWriteAction() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/groovy/grails/annotator/GrailsSynchronizeStructureAnnotator$2";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/groovy/grails/annotator/GrailsSynchronizeStructureAnnotator$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "isAvailable";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "invoke";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "getElementToMakeWritable";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/grails/annotator/GrailsSynchronizeStructureAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

