/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc.plugins;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.actions.GrailsActionUtilKt;
import org.jetbrains.plugins.grails.runner.GrailsCommandExecutor;
import org.jetbrains.plugins.grails.runner.GrailsConsole;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.OldGrailsApplication;
import org.jetbrains.plugins.grails.util.version.Version;
import org.jetbrains.plugins.groovy.mvc.plugins.AvailablePluginsModel;
import org.jetbrains.plugins.groovy.mvc.plugins.InstallUninstallPluginsDialog;
import org.jetbrains.plugins.groovy.mvc.plugins.MvcPluginDescriptor;
import org.jetbrains.plugins.groovy.mvc.plugins.MvcPluginIsInstalledColumnInfo;
import org.jetbrains.plugins.groovy.mvc.plugins.MvcPluginUtil;
import org.jetbrains.plugins.groovy.mvc.plugins.MvcPluginsMain;
import org.jetbrains.plugins.groovy.mvc.plugins.actions.ReloadMvcPluginListAction;

public class MvcPluginsAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            MvcPluginsAction.$$$reportNull$$$0(0);
        }
        GrailsApplication application = GrailsActionUtilKt.getGrailsApplication(e.getDataContext());
        e.getPresentation().setEnabledAndVisible(application instanceof OldGrailsApplication && application.getGrailsVersion().isLessThan(Version.GRAILS_2_3_0) && GrailsCommandExecutor.getGrailsExecutor(application) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            MvcPluginsAction.$$$reportNull$$$0(1);
        }
        final OldGrailsApplication application = (OldGrailsApplication)GrailsActionUtilKt.getGrailsApplication(e.getDataContext());
        assert (application != null);
        final Project project = application.getProject();
        Runnable runnable = () -> TransactionGuard.submitTransaction((Disposable)project, () -> {
            final DialogBuilder dialogBuilder = new DialogBuilder(project);
            dialogBuilder.addOkAction().setText("&Apply changes");
            final MvcPluginsMain mvcPluginsMain = new MvcPluginsMain(application, dialogBuilder);
            AvailablePluginsModel tableModel = mvcPluginsMain.getPluginTable().getModel();
            MvcPluginIsInstalledColumnInfo pluginIsInstalledColumnInfo = (MvcPluginIsInstalledColumnInfo)tableModel.getColumnInfos()[0];
            dialogBuilder.setOkActionEnabled(false);
            dialogBuilder.addCancelAction();
            dialogBuilder.setTitle("Grails plugins");
            dialogBuilder.setCenterPanel(mvcPluginsMain.getMainPanel());
            dialogBuilder.setOkOperation(() -> {
                Map<MvcPluginDescriptor, String> pluginToPath = mvcPluginsMain.getCustomPlugins();
                Set<String> toRemovePluginNames = pluginIsInstalledColumnInfo.getToRemovePlugins();
                Set<String> toInstallPluginNames = pluginIsInstalledColumnInfo.getToInstallPlugins();
                if (toRemovePluginNames.size() == 0 && toInstallPluginNames.size() == 0) {
                    StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
                    if (statusBar != null) {
                        statusBar.setInfo("There are no plugins to install or uninstall");
                    }
                    return;
                }
                Map<String, MvcPluginDescriptor> pluginMap = mvcPluginsMain.getPluginDescriptions();
                ArrayList<MvcPluginDescriptor> toInstallCustomPlugins = new ArrayList<MvcPluginDescriptor>();
                ArrayList<MvcPluginDescriptor> toInstallServerPlugins = new ArrayList<MvcPluginDescriptor>();
                for (String string : toInstallPluginNames) {
                    MvcPluginDescriptor plugin = pluginMap.get(string);
                    if (pluginToPath.containsKey(plugin)) {
                        toInstallCustomPlugins.add(plugin);
                        continue;
                    }
                    toInstallServerPlugins.add(plugin);
                }
                ArrayList<MvcPluginDescriptor> toRemovePlugins = new ArrayList<MvcPluginDescriptor>(toRemovePluginNames.size());
                for (String toRemovePluginName : toRemovePluginNames) {
                    toRemovePlugins.add(pluginMap.get(toRemovePluginName));
                }
                InstallUninstallPluginsDialog installUninstallPluginsDialog = new InstallUninstallPluginsDialog(toInstallServerPlugins, toInstallCustomPlugins, toRemovePlugins, application, mvcPluginsMain.getCustomPlugins());
                installUninstallPluginsDialog.show();
                if (0 == installUninstallPluginsDialog.getExitCode()) {
                    dialogBuilder.getDialogWrapper().close(0);
                    installUninstallPluginsDialog.doInstallRemove();
                }
            });
            dialogBuilder.getWindow().addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e1) {
                    Boolean f = (Boolean)MvcPluginUtil.PLUGIN_LIST_DONOT_DOWNLOADED.get((UserDataHolder)application);
                    if (f != null && f.booleanValue()) {
                        MvcPluginUtil.PLUGIN_LIST_DONOT_DOWNLOADED.set((UserDataHolder)application, null);
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (dialogBuilder.getWindow().isShowing() && !GrailsConsole.getInstance(project).isExecuting()) {
                                ReloadMvcPluginListAction.doReloadPluginList(mvcPluginsMain);
                            }
                        });
                    }
                }
            });
            dialogBuilder.show();
        });
        GrailsConsole.getInstance(project).show(runnable, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "org/jetbrains/plugins/groovy/mvc/plugins/MvcPluginsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

