/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc.plugins;

import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.ColumnInfo;
import java.awt.FontMetrics;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.mvc.plugins.AvailablePluginsModel;
import org.jetbrains.plugins.groovy.mvc.plugins.MvcPluginDescriptor;

public class MvcPluginsTable
extends JBTable {
    public MvcPluginsTable(AvailablePluginsModel model) {
        super((TableModel)model);
        this.initializeHeader();
        for (int i2 = 0; i2 < model.getColumnCount(); ++i2) {
            TableColumn column = this.getColumnModel().getColumn(i2);
            ColumnInfo columnInfo = model.getColumnInfos()[i2];
            column.setCellEditor(columnInfo.getEditor(null));
            if (i2 != 0 && i2 != 2) continue;
            String name = columnInfo.getName();
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int width = fontMetrics.stringWidth(" " + name + " ");
            if (i2 == 2) {
                width += fontMetrics.stringWidth(name);
            }
            column.setWidth(width);
            column.setPreferredWidth(width);
            column.setMaxWidth(width);
        }
        this.setSelectionMode(2);
        this.setShowGrid(false);
    }

    public void setValueAt(Object aValue, int row, int column) {
        super.setValueAt(aValue, row, column);
        this.repaint();
    }

    @Nullable
    public TableCellRenderer getCellRenderer(int row, int column) {
        ColumnInfo columnInfo = this.getModel().getColumnInfos()[column];
        return columnInfo.getRenderer(null);
    }

    private void initializeHeader() {
        JTableHeader header = this.getTableHeader();
        header.setReorderingAllowed(false);
    }

    public Object[] getElements() {
        return this.getModel().getAvailablePlugins().toArray();
    }

    @NotNull
    public MvcPluginDescriptor getPluginAt(int row) {
        MvcPluginDescriptor mvcPluginDescriptor = this.getModel().getRowValue(this.convertRowIndexToModel(row));
        if (mvcPluginDescriptor == null) {
            MvcPluginsTable.$$$reportNull$$$0(0);
        }
        return mvcPluginDescriptor;
    }

    public AvailablePluginsModel getModel() {
        return (AvailablePluginsModel)super.getModel();
    }

    @Nullable
    public MvcPluginDescriptor getSelectedObject() {
        if (this.getSelectedRowCount() > 0) {
            return this.getPluginAt(this.getSelectedRow());
        }
        return null;
    }

    protected boolean isSortOnUpdates() {
        return false;
    }

    @NotNull
    public MvcPluginDescriptor[] getSelectedObjects() {
        if (this.getSelectedRowCount() == 0) {
            if (MvcPluginDescriptor.EMPTY_ARRAY == null) {
                MvcPluginsTable.$$$reportNull$$$0(1);
            }
            return MvcPluginDescriptor.EMPTY_ARRAY;
        }
        int[] poses = this.getSelectedRows();
        MvcPluginDescriptor[] selection = new MvcPluginDescriptor[poses.length];
        for (int i2 = 0; i2 < poses.length; ++i2) {
            selection[i2] = this.getPluginAt(poses[i2]);
        }
        if (selection == null) {
            MvcPluginsTable.$$$reportNull$$$0(2);
        }
        return selection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/groovy/mvc/plugins/MvcPluginsTable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginAt";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedObjects";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

