/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc.plugins.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.runner.GrailsCommandExecutorUtil;
import org.jetbrains.plugins.grails.runner.GrailsConsole;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;
import org.jetbrains.plugins.groovy.mvc.plugins.MvcPluginsMain;

public class ReloadMvcPluginListAction
extends AnAction
implements DumbAware {
    private final MvcPluginsMain myMvcPluginsMain;

    public ReloadMvcPluginListAction(MvcPluginsMain mvcPluginsMain) {
        super("Reload plugin list", "Reload plugin list", AllIcons.Actions.Refresh);
        this.myMvcPluginsMain = mvcPluginsMain;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ReloadMvcPluginListAction.$$$reportNull$$$0(0);
        }
        if (GrailsConsole.getInstance(project = this.myMvcPluginsMain.getProject()).isExecuting()) {
            String frameworkName = "Grails";
            Messages.showErrorDialog((Project)project, (String)("Failed to reload plugin list: " + frameworkName + " Console is busy"), (String)("Can't execute " + frameworkName + " command"));
            return;
        }
        ReloadMvcPluginListAction.doReloadPluginList(this.myMvcPluginsMain);
    }

    public static void doReloadPluginList(@NotNull MvcPluginsMain mvcPlugins) {
        if (mvcPlugins == null) {
            ReloadMvcPluginListAction.$$$reportNull$$$0(1);
        }
        assert (!GrailsConsole.getInstance(mvcPlugins.getProject()).isExecuting());
        GrailsCommandExecutorUtil.executeInModal(mvcPlugins.getApplication(), new MvcCommand("list-plugins", new String[0]), "Updating plugin list...", mvcPlugins::reloadPlugins, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mvcPlugins";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/mvc/plugins/actions/ReloadMvcPluginListAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "doReloadPluginList";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

