/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.gutter;

import com.intellij.cdi.beans.InjectionPointDescriptor;
import com.intellij.cdi.gutter.PsiMethodCallExpressionCellRenderer;
import com.intellij.cdi.jam.CdiJamModel;
import com.intellij.cdi.jam.events.CdiEventObserves;
import com.intellij.cdi.jam.events.CdiEventObservesAsync;
import com.intellij.cdi.jam.events.CdiObserves;
import com.intellij.cdi.jam.inject.CdiInject;
import com.intellij.cdi.manager.CdiManager;
import com.intellij.cdi.resources.CdiBundle;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiInjectionUtils;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.semantic.SemService;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import icons.CdiCoreIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CdiEventsModelClassAnnotator
extends RelatedItemLineMarkerProvider {
    private static final String FIRE_EVENT_METHOD = "fire";
    private static final String FIRE_ASYNC_EVENT_METHOD = "fireAsync";
    private static final List<String> OBSERVES_ANNOTATIONS = Arrays.asList("javax.enterprise.event.Observes", "javax.enterprise.event.ObservesAsync");
    private static final PsiElementListCellRenderer psiParameterListRenderer = new PsiElementListCellRenderer<PsiParameter>(){

        public String getElementText(PsiParameter element) {
            PsiMethod method = (PsiMethod)element.getParent().getParent();
            StringBuilder sb = new StringBuilder();
            sb.append(method.getName());
            sb.append("(");
            ArrayList<String> params = new ArrayList<String>();
            for (PsiParameter psiParameter : method.getParameterList().getParameters()) {
                if (psiParameter.equals(element)) {
                    params.add(element.getText());
                    continue;
                }
                params.add(psiParameter.getType().getPresentableText());
            }
            sb.append(StringUtil.join(params, (String)","));
            sb.append(")");
            return sb.toString();
        }

        protected Icon getIcon(PsiElement element) {
            return PlatformIcons.METHOD_ICON;
        }

        protected String getContainerText(PsiParameter element, String name) {
            return "(" + element.getContainingFile().getName() + ")";
        }

        protected int getIconFlags() {
            return 0;
        }
    };

    public void collectNavigationMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo> result, boolean forNavigation) {
        PsiElement psiElement;
        if (elements == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(0);
        }
        if (result == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(1);
        }
        if ((psiElement = (PsiElement)ContainerUtil.getFirstItem(elements)) == null) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (CdiCommonUtils.isCdiInstalled(module)) {
            for (PsiElement element : elements) {
                CdiEventsModelClassAnnotator.collectNavigationMarkers(element, module, result);
            }
        }
    }

    protected static void collectNavigationMarkers(@NotNull PsiElement psiElement, @NotNull Module module, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        if (psiElement == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(2);
        }
        if (module == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(3);
        }
        if (result == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(4);
        }
        if (psiElement instanceof PsiIdentifier) {
            PsiMethodCallExpression methodCallExpression;
            String referenceName;
            PsiElement parent = psiElement.getParent();
            if (parent instanceof PsiParameter) {
                PsiParameter psiParameter = (PsiParameter)parent;
                if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiParameter, OBSERVES_ANNOTATIONS, (int)0)) {
                    CdiEventsModelClassAnnotator.annotateObserves(psiParameter, result, module);
                }
            } else if (parent instanceof PsiField || parent instanceof PsiMethod) {
                PsiClassType eventType = CdiEventsModelClassAnnotator.getEventPsiType(module);
                if (eventType == null) {
                    return;
                }
                CdiInject cdiInject = (CdiInject)SemService.getSemService((Project)module.getProject()).getSemElement(CdiInject.SEM_KEY, parent);
                if (cdiInject != null && CdiInjectionUtils.getInjectionPointOfType((PsiType)eventType, cdiInject).size() > 0) {
                    CdiEventsModelClassAnnotator.annotateEvents(cdiInject, result, module, CdiJamModel.getModel(module).getObserves());
                }
            } else if (parent instanceof PsiReferenceExpression && (FIRE_EVENT_METHOD.equals(referenceName = ((PsiReferenceExpression)parent).getReferenceName()) || FIRE_ASYNC_EVENT_METHOD.equals(referenceName)) && (methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiMethodCallExpression.class)) != null && CdiEventsModelClassAnnotator.isFireEventEventExpression(methodCallExpression)) {
                CdiEventsModelClassAnnotator.annotateFireEventExpression(methodCallExpression, result);
            }
        }
    }

    public static boolean isFireEventEventExpression(@NotNull PsiMethodCallExpression methodCallExpression) {
        PsiElement element;
        PsiReferenceExpression methodExpression;
        String referenceName;
        if (methodCallExpression == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(5);
        }
        if ((FIRE_EVENT_METHOD.equals(referenceName = (methodExpression = methodCallExpression.getMethodExpression()).getReferenceName()) || FIRE_ASYNC_EVENT_METHOD.equals(referenceName)) && (element = methodExpression.resolve()) instanceof PsiMethod) {
            PsiClass containingClass = ((PsiMethod)element).getContainingClass();
            return containingClass != null && InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"javax.enterprise.event.Event");
        }
        return false;
    }

    private static void annotateFireEventExpression(@NotNull PsiMethodCallExpression methodCallExpression, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        Set<CdiObserves> observes;
        if (methodCallExpression == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(6);
        }
        if (result == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(7);
        }
        if ((observes = CdiEventsModelClassAnnotator.getObserves(methodCallExpression)).size() > 0) {
            PsiReferenceExpression expression = methodCallExpression.getMethodExpression();
            PsiElement referenceNameElement = expression.getReferenceNameElement();
            CdiEventsModelClassAnnotator.addGotoObservesIcon(result, (PsiElement)(referenceNameElement == null ? expression : referenceNameElement), new NotNullLazyValue<Collection<? extends PsiElement>>(){

                @NotNull
                protected Collection<PsiParameter> compute() {
                    List list = ContainerUtil.mapNotNull((Collection)observes, cdiObserves -> cdiObserves.getPsiElement());
                    if (list == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return list;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/gutter/CdiEventsModelClassAnnotator$2", "compute"));
                }
            });
        }
    }

    @NotNull
    private static Set<CdiObserves> getObserves(@NotNull PsiMethodCallExpression methodCallExpression) {
        Module module;
        if (methodCallExpression == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(8);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)methodCallExpression)) == null) {
            Set<CdiObserves> set = Collections.emptySet();
            if (set == null) {
                CdiEventsModelClassAnnotator.$$$reportNull$$$0(9);
            }
            return set;
        }
        Set<CdiObserves> allObservesList = CdiJamModel.getModel(module).getObserves();
        if (allObservesList.size() == 0) {
            Set<CdiObserves> set = Collections.emptySet();
            if (set == null) {
                CdiEventsModelClassAnnotator.$$$reportNull$$$0(10);
            }
            return set;
        }
        Set<CdiObserves> observes = CdiEventsModelClassAnnotator.getObserves(methodCallExpression, module, allObservesList);
        if (observes.size() == 0) {
            Set<CdiObserves> set = Collections.emptySet();
            if (set == null) {
                CdiEventsModelClassAnnotator.$$$reportNull$$$0(11);
            }
            return set;
        }
        boolean isAsyncMethodCall = FIRE_ASYNC_EVENT_METHOD.equals(methodCallExpression.getMethodExpression().getReferenceName());
        if (isAsyncMethodCall) {
            Set<CdiObserves> set = observes.stream().filter(async -> async instanceof CdiEventObservesAsync).collect(Collectors.toSet());
            if (set == null) {
                CdiEventsModelClassAnnotator.$$$reportNull$$$0(12);
            }
            return set;
        }
        Set<CdiObserves> set = observes.stream().filter(notAsync -> notAsync instanceof CdiEventObserves).collect(Collectors.toSet());
        if (set == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(13);
        }
        return set;
    }

    private static Set<CdiObserves> getObserves(@NotNull PsiMethodCallExpression methodCallExpression, Module module, Set<CdiObserves> allObservesList) {
        CdiInject injectedEvent;
        if (methodCallExpression == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(14);
        }
        if ((injectedEvent = CdiEventsModelClassAnnotator.getInjectedEvent(methodCallExpression)) == null) {
            return CdiEventsModelClassAnnotator.collectObserves(CdiEventsModelClassAnnotator.getHandledEventType(methodCallExpression), allObservesList);
        }
        return CdiEventsModelClassAnnotator.collectObserves(injectedEvent, allObservesList, module);
    }

    @Nullable
    private static CdiInject getInjectedEvent(@NotNull PsiMethodCallExpression methodCallExpression) {
        PsiElement resolve;
        PsiReferenceExpression methodExpression;
        PsiExpression qualifierExpression;
        if (methodCallExpression == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(15);
        }
        if ((qualifierExpression = (methodExpression = methodCallExpression.getMethodExpression()).getQualifierExpression()) == null) {
            return null;
        }
        if (qualifierExpression instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)qualifierExpression).resolve()) instanceof PsiField) {
            return (CdiInject)CdiInject.FIELD_META.getJamElement((PsiModifierListOwner)((PsiField)resolve));
        }
        return null;
    }

    @Nullable
    private static PsiType getHandledEventType(@NotNull PsiMethodCallExpression expression) {
        PsiExpression[] expressions;
        if (expression == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(16);
        }
        return (expressions = expression.getArgumentList().getExpressions()).length > 0 ? expressions[0].getType() : null;
    }

    @Nullable
    private static PsiClassType getEventPsiType(@NotNull Module module) {
        JavaPsiFacade psiFacade;
        PsiClass eventPsiClass;
        if (module == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(17);
        }
        if ((eventPsiClass = (psiFacade = JavaPsiFacade.getInstance((Project)module.getProject())).findClass("javax.enterprise.event.Event", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module))) != null) {
            return psiFacade.getElementFactory().createType(eventPsiClass);
        }
        return null;
    }

    private static void annotateObserves(final @NotNull PsiParameter psiParameter, @NotNull Collection<? super RelatedItemLineMarkerInfo> result, final @NotNull Module module) {
        if (psiParameter == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(18);
        }
        if (result == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(19);
        }
        if (module == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(20);
        }
        CdiEventsModelClassAnnotator.addGotoFiresIcon(result, psiParameter, new NotNullLazyValue<Collection<? extends PsiElement>>(){

            @NotNull
            protected Collection<PsiElement> compute() {
                List list = ContainerUtil.mapNotNull((Collection)CdiEventsModelClassAnnotator.getFireEventPoints(psiParameter, module), firePoint -> ((PsiElement)firePoint.first).isValid() ? (PsiElement)firePoint.first : null);
                if (list == null) {
                    3.$$$reportNull$$$0(0);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/gutter/CdiEventsModelClassAnnotator$3", "compute"));
            }
        });
    }

    @NotNull
    private static Set<Pair<PsiElement, PsiType>> getFireEventPoints(@NotNull PsiParameter psiParameter, @NotNull Module module) {
        if (psiParameter == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(21);
        }
        if (module == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(22);
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiParameter, (String)"javax.enterprise.event.Observes", (int)0)) {
            Set<Pair<PsiElement, PsiType>> set = CdiEventsModelClassAnnotator.getFireEventExpressions(psiParameter.getType(), module, scope);
            if (set == null) {
                CdiEventsModelClassAnnotator.$$$reportNull$$$0(23);
            }
            return set;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiParameter, (String)"javax.enterprise.event.ObservesAsync", (int)0)) {
            Set<Pair<PsiElement, PsiType>> set = CdiEventsModelClassAnnotator.getFireAsyncEventExpressions(psiParameter.getType(), module, scope);
            if (set == null) {
                CdiEventsModelClassAnnotator.$$$reportNull$$$0(24);
            }
            return set;
        }
        Set<Pair<PsiElement, PsiType>> set = Collections.emptySet();
        if (set == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(25);
        }
        return set;
    }

    private static void annotateEvents(CdiInject event, @NotNull Collection<? super RelatedItemLineMarkerInfo> result, Module module, Set<CdiObserves> allObservesList) {
        Set<CdiObserves> observes;
        if (result == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(26);
        }
        if ((observes = CdiEventsModelClassAnnotator.collectObserves(event, allObservesList, module)).size() > 0) {
            CdiEventsModelClassAnnotator.addGotoObservesIcon(result, event.getPsiElement(), new NotNullLazyValue<Collection<? extends PsiElement>>(){

                @NotNull
                protected Collection<PsiParameter> compute() {
                    List list = ContainerUtil.mapNotNull((Collection)observes, cdiObserves -> cdiObserves.getPsiElement());
                    if (list == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    return list;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/gutter/CdiEventsModelClassAnnotator$4", "compute"));
                }
            });
        }
    }

    private static void addGotoObservesIcon(@NotNull Collection<? super RelatedItemLineMarkerInfo> result, PsiElement psiIdentifier, NotNullLazyValue<Collection<? extends PsiElement>> targets) {
        if (result == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(27);
        }
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)CdiCoreIcons.Gutter.GotoObserves).setCellRenderer(psiParameterListRenderer).setTargets(targets).setPopupTitle(CdiBundle.message("gutter.choose.goto.observes", new Object[0])).setTooltipText(CdiBundle.message("gutter.navigate.to.observes", new Object[0]));
        result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo(CdiEventsModelClassAnnotator.getLeafElement(psiIdentifier)));
    }

    @NotNull
    private static PsiElement getLeafElement(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(28);
        }
        PsiIdentifier nameIdentifier = null;
        if (psiElement instanceof PsiVariable) {
            nameIdentifier = ((PsiVariable)psiElement).getNameIdentifier();
        } else if (psiElement instanceof PsiMethod) {
            nameIdentifier = ((PsiMethod)psiElement).getNameIdentifier();
        }
        Object object = nameIdentifier == null ? psiElement : nameIdentifier;
        if (object == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(29);
        }
        return object;
    }

    private static void addGotoFiresIcon(@NotNull Collection<? super RelatedItemLineMarkerInfo> result, PsiParameter psiParameter, NotNullLazyValue<Collection<? extends PsiElement>> targets) {
        if (result == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(30);
        }
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)CdiCoreIcons.Gutter.GotoFires).setTargets(targets).setPopupTitle(CdiBundle.message("gutter.choose.goto.fires", new Object[0])).setTooltipText(CdiBundle.message("gutter.navigate.to.fires", new Object[0])).setCellRenderer(CdiEventsModelClassAnnotator.getEventFirePointRenderer());
        result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo(CdiEventsModelClassAnnotator.getLeafElement((PsiElement)psiParameter)));
    }

    private static Set<CdiObserves> collectObserves(CdiInject event, Set<CdiObserves> allObservesList, Module module) {
        PsiType eventType = CdiEventsModelClassAnnotator.getEventType(event, CdiEventsModelClassAnnotator.getEventPsiType(module));
        if (eventType != null) {
            PsiAnnotation[] eventQualifierAnnotations = event.getQualifierAnnotations();
            return allObservesList.stream().filter(observes -> {
                PsiType type = observes.getType();
                return type != null && type.isAssignableFrom(eventType) && CdiEventsModelClassAnnotator.isQualifiersAssignable(eventQualifierAnnotations, (PsiModifierListOwner)observes.getPsiElement());
            }).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private static Set<CdiObserves> collectObserves(@Nullable PsiType handledEventType, @NotNull Set<CdiObserves> allObservesList) {
        if (allObservesList == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(31);
        }
        if (handledEventType != null) {
            return allObservesList.stream().filter(observes -> {
                PsiType type = observes.getType();
                return type != null && type.isAssignableFrom(handledEventType);
            }).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    @Nullable
    private static PsiType getEventType(CdiInject<PsiMember> event, PsiClassType eventPsiType) {
        for (InjectionPointDescriptor pair : event.getInjectionPoints()) {
            PsiType injectionPointType = pair.getType();
            if (injectionPointType == null || !injectionPointType.isAssignableFrom((PsiType)eventPsiType)) continue;
            return PsiUtil.substituteTypeParameter((PsiType)injectionPointType, (String)"javax.enterprise.event.Event", (int)0, (boolean)false);
        }
        return null;
    }

    private static boolean isQualifiersAssignable(PsiAnnotation[] qualifierAnnotation, PsiModifierListOwner candidate) {
        return CdiManager.hasAnnotated(candidate, qualifierAnnotation);
    }

    @NotNull
    private static Set<Pair<PsiElement, PsiType>> searchAndCacheFireEventExpressions(@NotNull PsiMethod fireEventMethod, @NotNull SearchScope searchScope) {
        if (fireEventMethod == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(32);
        }
        if (searchScope == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(33);
        }
        Set set = (Set)CachedValuesManager.getCachedValue((PsiElement)fireEventMethod, () -> {
            if (fireEventMethod == null) {
                CdiEventsModelClassAnnotator.$$$reportNull$$$0(58);
            }
            if (searchScope == null) {
                CdiEventsModelClassAnnotator.$$$reportNull$$$0(59);
            }
            return CachedValueProvider.Result.create(CdiEventsModelClassAnnotator.searchFireEventExpressions(fireEventMethod, searchScope), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        if (set == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(34);
        }
        return set;
    }

    @NotNull
    private static Set<Pair<PsiElement, PsiType>> searchFireEventExpressions(@NotNull PsiMethod fireEventMethod, @NotNull SearchScope searchScope) {
        if (fireEventMethod == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(35);
        }
        if (searchScope == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(36);
        }
        LinkedHashSet set = ContainerUtil.newLinkedHashSet();
        MethodReferencesSearch.search((PsiMethod)fireEventMethod, (SearchScope)searchScope, (boolean)true).forEach(psiReference -> {
            PsiExpression[] expressions;
            PsiMethodCallExpression methodCallExpression;
            if (set == null) {
                CdiEventsModelClassAnnotator.$$$reportNull$$$0(57);
            }
            if ((methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), PsiMethodCallExpression.class)) != null && (expressions = methodCallExpression.getArgumentList().getExpressions()).length > 0) {
                PsiExpression expression = expressions[0];
                set.add(Pair.create((Object)methodCallExpression, (Object)expression.getType()));
            }
            return true;
        });
        LinkedHashSet linkedHashSet = set;
        if (linkedHashSet == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(37);
        }
        return linkedHashSet;
    }

    @NotNull
    private static Set<Pair<PsiElement, PsiType>> getFireEventExpressions(@NotNull PsiType handledType, @NotNull Module module, @NotNull GlobalSearchScope scope) {
        if (handledType == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(38);
        }
        if (module == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(39);
        }
        if (scope == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(40);
        }
        Set<Pair<PsiElement, PsiType>> set = CdiEventsModelClassAnnotator.filter(CdiEventsModelClassAnnotator.getFireEventExpressions(FIRE_EVENT_METHOD, module, scope), handledType);
        if (set == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(41);
        }
        return set;
    }

    @NotNull
    private static Set<Pair<PsiElement, PsiType>> getFireAsyncEventExpressions(@NotNull PsiType handledType, @NotNull Module module, @NotNull GlobalSearchScope scope) {
        if (handledType == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(42);
        }
        if (module == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(43);
        }
        if (scope == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(44);
        }
        Set<Pair<PsiElement, PsiType>> set = CdiEventsModelClassAnnotator.filter(CdiEventsModelClassAnnotator.getFireEventExpressions(FIRE_ASYNC_EVENT_METHOD, module, scope), handledType);
        if (set == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(45);
        }
        return set;
    }

    @NotNull
    private static Set<Pair<PsiElement, PsiType>> getFireEventExpressions(@NotNull String methodName, @NotNull Module module, @NotNull GlobalSearchScope scope) {
        if (methodName == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(46);
        }
        if (module == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(47);
        }
        if (scope == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(48);
        }
        LinkedHashSet firePoints = ContainerUtil.newLinkedHashSet();
        for (PsiMethod fireEventMethod : CdiEventsModelClassAnnotator.getFireEventMethods(module, methodName)) {
            firePoints.addAll(CdiEventsModelClassAnnotator.searchAndCacheFireEventExpressions(fireEventMethod, (SearchScope)scope));
        }
        LinkedHashSet linkedHashSet = firePoints;
        if (linkedHashSet == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(49);
        }
        return linkedHashSet;
    }

    private static PsiMethod[] getFireEventMethods(@NotNull Module module, @NotNull String fireMethod) {
        PsiClass eventClass;
        if (module == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(50);
        }
        if (fireMethod == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(51);
        }
        if ((eventClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass("javax.enterprise.event.Event", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module))) != null) {
            return eventClass.findMethodsByName(fireMethod, false);
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    @NotNull
    private static Set<Pair<PsiElement, PsiType>> filter(@NotNull Set<Pair<PsiElement, PsiType>> firePoints, @NotNull PsiType eventType) {
        if (firePoints == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(52);
        }
        if (eventType == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(53);
        }
        Set<Pair<PsiElement, PsiType>> set = firePoints.stream().filter(firePoint -> {
            PsiType firedEventType;
            if (eventType == null) {
                CdiEventsModelClassAnnotator.$$$reportNull$$$0(56);
            }
            return (firedEventType = (PsiType)firePoint.second) != null && eventType.isAssignableFrom(firedEventType);
        }).collect(Collectors.toSet());
        if (set == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(54);
        }
        return set;
    }

    @NotNull
    private static PsiElementListCellRenderer<PsiMethodCallExpression> getEventFirePointRenderer() {
        PsiMethodCallExpressionCellRenderer psiMethodCallExpressionCellRenderer = new PsiMethodCallExpressionCellRenderer();
        if (psiMethodCallExpressionCellRenderer == null) {
            CdiEventsModelClassAnnotator.$$$reportNull$$$0(55);
        }
        return psiMethodCallExpressionCellRenderer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 34: 
            case 37: 
            case 41: 
            case 45: 
            case 49: 
            case 54: 
            case 55: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 34: 
            case 37: 
            case 41: 
            case 45: 
            case 49: 
            case 54: 
            case 55: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 19: 
            case 26: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 3: 
            case 17: 
            case 20: 
            case 22: 
            case 39: 
            case 43: 
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCallExpression";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 34: 
            case 37: 
            case 41: 
            case 45: 
            case 49: 
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/gutter/CdiEventsModelClassAnnotator";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiParameter";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allObservesList";
                break;
            }
            case 32: 
            case 35: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fireEventMethod";
                break;
            }
            case 33: 
            case 36: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 38: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handledType";
                break;
            }
            case 40: 
            case 44: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fireMethod";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firePoints";
                break;
            }
            case 53: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventType";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/gutter/CdiEventsModelClassAnnotator";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getObserves";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getFireEventPoints";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeafElement";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "searchAndCacheFireEventExpressions";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "searchFireEventExpressions";
                break;
            }
            case 41: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getFireEventExpressions";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getFireAsyncEventExpressions";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventFirePointRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectNavigationMarkers";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isFireEventEventExpression";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "annotateFireEventExpression";
                break;
            }
            case 8: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getObserves";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 34: 
            case 37: 
            case 41: 
            case 45: 
            case 49: 
            case 54: 
            case 55: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedEvent";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getHandledEventType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getEventPsiType";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "annotateObserves";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getFireEventPoints";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "annotateEvents";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addGotoObservesIcon";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getLeafElement";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addGotoFiresIcon";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "collectObserves";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "searchAndCacheFireEventExpressions";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "searchFireEventExpressions";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getFireEventExpressions";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getFireAsyncEventExpressions";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getFireEventMethods";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "lambda$filter$6";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "lambda$searchFireEventExpressions$5";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "lambda$searchAndCacheFireEventExpressions$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 34: 
            case 37: 
            case 41: 
            case 45: 
            case 49: 
            case 54: 
            case 55: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

