/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.gutter;

import com.intellij.cdi.beans.CdiBeanDescriptor;
import com.intellij.cdi.beans.CdiExtensionBeanDescriptor;
import com.intellij.cdi.beans.InjectionPointDescriptor;
import com.intellij.cdi.gutter.PsiMethodCallExpressionCellRenderer;
import com.intellij.cdi.manager.CdiManager;
import com.intellij.cdi.resources.CdiBundle;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiInjectionUtils;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import icons.CdiCoreIcons;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CdiInjectionsClassAnnotator
extends RelatedItemLineMarkerProvider {
    private static final InjectedBeansCellRenderer myInjectedBeansRenderer = new InjectedBeansCellRenderer();
    private static final CdiInjectionPointOwnerCellRenderer myInjectionPointsRenderer = new CdiInjectionPointOwnerCellRenderer();

    public void collectNavigationMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo> result, boolean forNavigation) {
        PsiElement psiElement;
        if (elements == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(0);
        }
        if (result == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(1);
        }
        if ((psiElement = (PsiElement)ContainerUtil.getFirstItem(elements)) == null) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (CdiCommonUtils.isCdiInstalled(module)) {
            for (PsiElement element : elements) {
                CdiInjectionsClassAnnotator.collectNavigationMarkers(element, module, result);
            }
        }
    }

    protected static void collectNavigationMarkers(@NotNull PsiElement psiElement, @NotNull Module module, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        if (psiElement == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(2);
        }
        if (module == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(3);
        }
        if (result == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(4);
        }
        if (psiElement instanceof PsiIdentifier) {
            PsiMethodCallExpression methodCallExpression;
            PsiElement parent = psiElement.getParent();
            if (parent instanceof PsiParameter) {
                CdiInjectionsClassAnnotator.addInjectedGutterIconIfNeeded(result, module, parent);
            } else if (parent instanceof PsiField) {
                CdiInjectionsClassAnnotator.annotatePsiField(module, result, (PsiField)parent);
            } else if (parent instanceof PsiMethod) {
                CdiInjectionsClassAnnotator.annotatePsiMethod(result, module, (PsiMethod)parent);
            } else if (parent instanceof PsiClass) {
                CdiInjectionsClassAnnotator.annotatePsiClass(module, result, (PsiClass)parent);
            } else if (parent instanceof PsiReferenceExpression && "addBean".equals(((PsiReferenceExpression)parent).getReferenceName()) && (methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiMethodCallExpression.class)) != null && CdiInjectionsClassAnnotator.isAddBeanExpression(methodCallExpression)) {
                CdiInjectionsClassAnnotator.annotateAddBeanExpression(methodCallExpression, module, result);
            }
        }
    }

    private static void annotateAddBeanExpression(@NotNull PsiMethodCallExpression methodCallExpression, @NotNull Module module, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        PsiType psiType;
        if (methodCallExpression == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(5);
        }
        if (module == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(6);
        }
        if (result == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(7);
        }
        if ((psiType = CdiExtensionBeanDescriptor.create(methodCallExpression).getType()) != null) {
            PsiElement referenceNameElement = methodCallExpression.getMethodExpression().getReferenceNameElement();
            CdiInjectionsClassAnnotator.addOutjectedGutter(result, module, (PsiElement)(referenceNameElement == null ? methodCallExpression : referenceNameElement), psiType);
        }
    }

    private static void annotatePsiClass(@NotNull Module module, @NotNull Collection<? super RelatedItemLineMarkerInfo> result, PsiClass psiClass) {
        if (module == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(8);
        }
        if (result == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(9);
        }
        if (CdiInjectionUtils.canBeInjected(psiClass, module)) {
            PsiClassType psiClassType = JavaPsiFacade.getInstance((Project)module.getProject()).getElementFactory().createType(psiClass);
            CdiInjectionsClassAnnotator.addOutjectedGutter(result, module, (PsiElement)psiClass, (PsiType)psiClassType);
        }
    }

    private static void annotatePsiMethod(@NotNull Collection<? super RelatedItemLineMarkerInfo> result, @NotNull Module module, PsiMethod psiMethod) {
        if (result == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(10);
        }
        if (module == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(11);
        }
        if (CdiInjectionsClassAnnotator.isProducer((PsiModifierListOwner)psiMethod)) {
            CdiInjectionsClassAnnotator.addOutjectedGutter(result, module, (PsiElement)psiMethod, psiMethod.getReturnType());
        }
    }

    private static void annotatePsiField(@NotNull Module module, @NotNull Collection<? super RelatedItemLineMarkerInfo> result, @NotNull PsiField psiField) {
        if (module == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(12);
        }
        if (result == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(13);
        }
        if (psiField == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(14);
        }
        CdiInjectionsClassAnnotator.addInjectedGutterIconIfNeeded(result, module, (PsiElement)psiField);
        if (CdiInjectionsClassAnnotator.isProducer((PsiModifierListOwner)psiField)) {
            CdiInjectionsClassAnnotator.addOutjectedGutter(result, module, (PsiElement)psiField, psiField.getType());
        }
    }

    private static boolean isProducer(PsiModifierListOwner parent) {
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)parent, (String)"javax.enterprise.inject.Produces", (int)1);
    }

    private static void addInjectedGutterIconIfNeeded(@NotNull Collection<? super RelatedItemLineMarkerInfo> result, @NotNull Module module, PsiElement parent) {
        InjectionPointDescriptor ip;
        if (result == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(15);
        }
        if (module == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(16);
        }
        if ((ip = CdiInjectionsClassAnnotator.getInjectionPoint(parent, module)) != null) {
            CdiInjectionsClassAnnotator.addInjectedGutterIcon(result, ip);
        }
    }

    @Nullable
    private static InjectionPointDescriptor getInjectionPoint(@NotNull PsiElement psiElement, @NotNull Module module) {
        PsiClass psiClass;
        if (psiElement == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(17);
        }
        if (module == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(18);
        }
        if ((psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class)) != null && CdiCommonUtils.isClassContainsCdiAnnotations(psiClass, module)) {
            for (InjectionPointDescriptor ip : CdiInjectionUtils.getInjectionPoints(psiClass)) {
                if (!ip.getOwner().equals(psiElement)) continue;
                return ip;
            }
        }
        return null;
    }

    public static boolean isAddBeanExpression(@NotNull PsiMethodCallExpression methodCallExpression) {
        PsiElement element;
        PsiReferenceExpression methodExpression;
        String referenceName;
        if (methodCallExpression == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(19);
        }
        if ("addBean".equals(referenceName = (methodExpression = methodCallExpression.getMethodExpression()).getReferenceName()) && (element = methodExpression.resolve()) instanceof PsiMethod) {
            PsiClass containingClass = ((PsiMethod)element).getContainingClass();
            return containingClass != null && InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"javax.enterprise.inject.spi.AfterBeanDiscovery");
        }
        return false;
    }

    private static void addOutjectedGutter(@NotNull Collection<? super RelatedItemLineMarkerInfo> result, @NotNull Module module, @Nullable PsiElement psiMember, @Nullable PsiType type) {
        if (result == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(20);
        }
        if (module == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(21);
        }
        if (psiMember == null || type == null) {
            return;
        }
        Set<InjectionPointDescriptor> outjectedPoints = CdiInjectionUtils.getInjectionPoints(type, CdiInjectionUtils.getInjectionPoints(module));
        if (outjectedPoints.size() > 0) {
            HashSet bindedOutjectedPoints = new HashSet();
            PsiAnnotation[] bindingAnnotations = psiMember instanceof PsiModifierListOwner ? CdiCommonUtils.getQualifierAnnotations((PsiModifierListOwner)psiMember) : PsiAnnotation.EMPTY_ARRAY;
            for (InjectionPointDescriptor point : outjectedPoints) {
                if (!CdiManager.hasAnnotated(point.getOwner(), bindingAnnotations)) continue;
                bindedOutjectedPoints.add(point);
            }
            CdiInjectionsClassAnnotator.addOutjectedGutterIcon(result, (Set<InjectionPointDescriptor>)bindedOutjectedPoints, psiMember);
        }
    }

    private static void addInjectedGutterIcon(@NotNull Collection<? super RelatedItemLineMarkerInfo> result, @NotNull InjectionPointDescriptor ip) {
        if (result == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(22);
        }
        if (ip == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(23);
        }
        CdiInjectionsClassAnnotator.addInjectedGutterIcon(result, CdiInjectionUtils.getInjectedBeans(ip), ip.getOwner());
    }

    private static void addInjectedGutterIcon(Collection<? super RelatedItemLineMarkerInfo> result, Set<CdiBeanDescriptor> beanDescriptors, PsiModifierListOwner owner) {
        if (beanDescriptors != null && beanDescriptors.size() > 0) {
            CdiInjectionsClassAnnotator.addInjectedBeanGutterIcon(result, owner, CdiInjectionsClassAnnotator.getTargets(beanDescriptors));
        }
    }

    @NotNull
    private static NotNullLazyValue<Collection<? extends PsiElement>> getTargets(final Set<CdiBeanDescriptor> beanDescriptors) {
        NotNullLazyValue<Collection<? extends PsiElement>> notNullLazyValue = new NotNullLazyValue<Collection<? extends PsiElement>>(){

            @NotNull
            protected Collection<PsiElement> compute() {
                List list = ContainerUtil.mapNotNull((Collection)beanDescriptors, cdiBeanDescriptor -> cdiBeanDescriptor.getIdentifyingElement());
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/gutter/CdiInjectionsClassAnnotator$1", "compute"));
            }
        };
        if (notNullLazyValue == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(24);
        }
        return notNullLazyValue;
    }

    private static void addOutjectedGutterIcon(Collection<? super RelatedItemLineMarkerInfo> result, Set<InjectionPointDescriptor> ips, PsiElement member) {
        List members = ContainerUtil.map(ips, InjectionPointDescriptor::getOwner);
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)CdiCoreIcons.Gutter.Inject).setTargets((Collection)members).setPopupTitle(CdiBundle.message("gutter.choose.injected.point", new Object[0])).setCellRenderer((PsiElementListCellRenderer)myInjectionPointsRenderer).setTooltipText(CdiBundle.message("gutter.navigate.to.injection.point", new Object[0]));
        PsiElement element = member instanceof PsiNameIdentifierOwner ? ((PsiNameIdentifierOwner)member).getNameIdentifier() : member;
        result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo(element == null ? member : element));
    }

    private static void addInjectedBeanGutterIcon(Collection<? super RelatedItemLineMarkerInfo> result, PsiModifierListOwner psiIdentifier, NotNullLazyValue<Collection<? extends PsiElement>> targets) {
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)CdiCoreIcons.Gutter.CdiBean).setTargets(targets).setPopupTitle(CdiBundle.message("gutter.choose.bean", new Object[0])).setTooltipText(CdiBundle.message("gutter.navigate.method.injections", new Object[0])).setCellRenderer((PsiElementListCellRenderer)myInjectedBeansRenderer);
        PsiElement identifier = CdiInjectionsClassAnnotator.getIdentifingElement(psiIdentifier);
        if (identifier != null) {
            result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo(identifier));
        }
    }

    private static PsiElement getIdentifingElement(@NotNull PsiModifierListOwner psiIdentifier) {
        PsiAnnotation injectAnno;
        PsiModifierList modifierList;
        if (psiIdentifier == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(25);
        }
        if ((modifierList = psiIdentifier.getModifierList()) != null && (injectAnno = modifierList.findAnnotation("javax.inject.Inject")) != null) {
            return CdiInjectionsClassAnnotator.getIdentifier(injectAnno);
        }
        if (psiIdentifier instanceof PsiNameIdentifierOwner) {
            return ((PsiNameIdentifierOwner)psiIdentifier).getNameIdentifier();
        }
        return null;
    }

    public static PsiElement getIdentifier(@NotNull PsiAnnotation annotation) {
        PsiJavaCodeReferenceElement identifier;
        if (annotation == null) {
            CdiInjectionsClassAnnotator.$$$reportNull$$$0(26);
        }
        return (identifier = annotation.getNameReferenceElement()) == null ? null : identifier.getReferenceNameElement();
    }

    @Nullable
    public String getName() {
        return "Injection points";
    }

    public String getId() {
        return "CdiInjectionsClassAnnotator";
    }

    @Nullable
    public Icon getIcon() {
        return CdiCoreIcons.CdiBean;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCallExpression";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ip";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/gutter/CdiInjectionsClassAnnotator";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiIdentifier";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/gutter/CdiInjectionsClassAnnotator";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectNavigationMarkers";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "annotateAddBeanExpression";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "annotatePsiClass";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "annotatePsiMethod";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "annotatePsiField";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addInjectedGutterIconIfNeeded";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getInjectionPoint";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isAddBeanExpression";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addOutjectedGutter";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addInjectedGutterIcon";
                break;
            }
            case 24: {
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getIdentifingElement";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getIdentifier";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CdiInjectionPointOwnerCellRenderer
    extends DefaultPsiElementCellRenderer {
        public String getContainerText(PsiElement element, String name) {
            return CdiInjectionPointOwnerCellRenderer.containerText(element);
        }

        @Nullable
        public static String containerText(@NotNull PsiElement element) {
            String sb;
            PsiMethod psiMethod;
            if (element == null) {
                CdiInjectionPointOwnerCellRenderer.$$$reportNull$$$0(0);
            }
            if (element instanceof PsiParameter && (psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class)) != null && (sb = CdiInjectionPointOwnerCellRenderer.getMethodText(psiMethod)) != null) {
                return "(" + sb + ")";
            }
            return SymbolPresentationUtil.getSymbolContainerText((PsiElement)element);
        }

        @Nullable
        private static String getMethodText(@NotNull PsiMethod psiMethod) {
            if (psiMethod == null) {
                CdiInjectionPointOwnerCellRenderer.$$$reportNull$$$0(1);
            }
            PsiClass containingClass = psiMethod.getContainingClass();
            StringBuilder sb = new StringBuilder();
            if (containingClass != null) {
                sb.append(SymbolPresentationUtil.getSymbolPresentableText((PsiElement)containingClass)).append(".");
                sb.append(SymbolPresentationUtil.getSymbolPresentableText((PsiElement)psiMethod));
                return sb.toString();
            }
            return null;
        }

        protected int getIconFlags() {
            return 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiMethod";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/cdi/gutter/CdiInjectionsClassAnnotator$CdiInjectionPointOwnerCellRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "containerText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getMethodText";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class InjectedBeansCellRenderer
    extends DefaultPsiElementCellRenderer {
        private InjectedBeansCellRenderer() {
        }

        public String getElementText(PsiElement element) {
            if (element instanceof PsiMethodCallExpression) {
                return PsiMethodCallExpressionCellRenderer.elementText((PsiMethodCallExpression)element);
            }
            return super.getElementText(element);
        }

        @Nullable
        public String getContainerText(PsiElement element, String name) {
            if (element instanceof PsiMethodCallExpression) {
                return PsiMethodCallExpressionCellRenderer.containerText((PsiMethodCallExpression)element);
            }
            return super.getContainerText(element, name);
        }

        protected Icon getIcon(PsiElement element) {
            if (element instanceof PsiMethodCallExpression) {
                return AllIcons.Nodes.MethodReference;
            }
            return super.getIcon(element);
        }
    }
}

