/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.view;

import com.intellij.cdi.CdiProjectComponent;
import com.intellij.cdi.beans.AbstractCdiBeanDescriptor;
import com.intellij.cdi.beans.CdiBeanDescriptor;
import com.intellij.cdi.beans.FieldProducerBeanDescriptor;
import com.intellij.cdi.beans.InjectionPointDescriptor;
import com.intellij.cdi.beans.ManagedBeanDescriptor;
import com.intellij.cdi.beans.MethodProducerBeanDescriptor;
import com.intellij.cdi.beans.ProducerBeanDescriptor;
import com.intellij.cdi.jam.CdiJamModel;
import com.intellij.cdi.jam.CdiNamedBean;
import com.intellij.cdi.jam.producers.CdiProduces;
import com.intellij.cdi.manager.CdiDescriptorsFactory;
import com.intellij.cdi.toolWindow.tree.nodes.CdiViewSettings;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiInjectionUtils;
import com.intellij.cdi.view.CdiInjectionPointsPanel;
import com.intellij.cdi.view.actions.ShowBeansAction;
import com.intellij.cdi.view.actions.ShowInjectionPointsAction;
import com.intellij.cdi.view.actions.ShowProducersAction;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CdiBeansRecursivePanel
extends FinderRecursivePanel<AbstractCdiBeanDescriptor> {
    private final Module myModule;
    protected final DefaultActionGroup myActions;
    private ShowProducersAction myShowProducersAction;
    private ShowBeansAction myShowBeansAction;
    private ShowInjectionPointsAction myShowInjectionPointsAction;

    public CdiBeansRecursivePanel(@NotNull FinderRecursivePanel parent, @Nullable Module module, DefaultActionGroup actions) {
        if (parent == null) {
            CdiBeansRecursivePanel.$$$reportNull$$$0(0);
        }
        super(parent);
        this.myModule = module;
        this.myActions = actions;
        this.initAdditionalActions(actions);
    }

    private void initAdditionalActions(DefaultActionGroup actions) {
        this.myShowBeansAction = new ShowBeansAction(this);
        this.myShowProducersAction = new ShowProducersAction(this);
        this.myShowInjectionPointsAction = new ShowInjectionPointsAction(this);
        actions.add((AnAction)this.myShowBeansAction);
        actions.add((AnAction)this.myShowProducersAction);
        actions.add((AnAction)this.myShowInjectionPointsAction);
    }

    @Nullable
    protected JComponent createRightComponent(AbstractCdiBeanDescriptor beanDescriptor) {
        if (this.isShowInjectionPoints() && this.hasChildren(beanDescriptor)) {
            return new CdiInjectionPointsPanel(this, this.getModule());
        }
        return this.getBeanDescriptorInfoPanel(beanDescriptor);
    }

    private JComponent getBeanDescriptorInfoPanel(AbstractCdiBeanDescriptor beanDescriptor) {
        return DocumentationComponent.createAndFetch((Project)this.getProject(), beanDescriptor.getAnnotatedItem(), (Disposable)this);
    }

    @NotNull
    protected String getItemText(AbstractCdiBeanDescriptor beanDescriptor) {
        String name = beanDescriptor.getAnnotatedItem().getName();
        String string = name == null ? "" : name;
        if (string == null) {
            CdiBeansRecursivePanel.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected void doCustomizeCellRenderer(SimpleColoredComponent comp, JList list, AbstractCdiBeanDescriptor beanDescriptor, int index, boolean selected, boolean hasFocus) {
        PsiField field;
        String s;
        PsiMethod method;
        PsiClass aClass;
        comp.clear();
        comp.setIcon(this.getItemIcon(beanDescriptor));
        if (beanDescriptor instanceof ManagedBeanDescriptor && (aClass = (PsiClass)((ManagedBeanDescriptor)beanDescriptor).getIdentifyingElement()).isValid()) {
            comp.append(aClass.getName());
            CdiBeansRecursivePanel.addQualifierAnnotations(comp, beanDescriptor);
        }
        if (beanDescriptor instanceof MethodProducerBeanDescriptor && (method = (PsiMethod)((MethodProducerBeanDescriptor)beanDescriptor).getIdentifyingElement()).isValid()) {
            s = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)7, (int)2);
            PsiClass containingClass = method.getContainingClass();
            if (containingClass != null) {
                comp.append(containingClass.getName() + "->", SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
            }
            comp.append(s);
            CdiBeansRecursivePanel.addQualifierAnnotations(comp, beanDescriptor);
        }
        if (beanDescriptor instanceof FieldProducerBeanDescriptor && (field = (PsiField)((FieldProducerBeanDescriptor)beanDescriptor).getIdentifyingElement()).isValid()) {
            s = PsiFormatUtil.formatVariable((PsiVariable)field, (int)7, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            comp.append(s);
            CdiBeansRecursivePanel.addQualifierAnnotations(comp, beanDescriptor);
        }
    }

    private static void addQualifierAnnotations(SimpleColoredComponent comp, AbstractCdiBeanDescriptor beanDescriptor) {
        String annotations = CdiBeansRecursivePanel.getQualifierAnnotations(beanDescriptor);
        if (!StringUtil.isEmpty((String)annotations)) {
            comp.append(" " + annotations, SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        }
    }

    @NotNull
    private static String getQualifierAnnotations(AbstractCdiBeanDescriptor beanDescriptor) {
        StringBuilder buffer = new StringBuilder();
        Object item = beanDescriptor.getAnnotatedItem();
        if (item.isValid()) {
            for (PsiAnnotation psiAnnotation : CdiCommonUtils.getQualifierAnnotations(item)) {
                String fqName = psiAnnotation.getQualifiedName();
                if (fqName == null) continue;
                buffer.append("@");
                buffer.append(StringUtil.getShortName((String)fqName));
                buffer.append(" ");
            }
        }
        String string = buffer.toString();
        if (string == null) {
            CdiBeansRecursivePanel.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    protected Icon getItemIcon(AbstractCdiBeanDescriptor beanDescriptor) {
        Object item = beanDescriptor.getAnnotatedItem();
        return item.getIcon(0);
    }

    @NotNull
    protected Set<AbstractCdiBeanDescriptor> getListItems(@NotNull Module module) {
        if (module == null) {
            CdiBeansRecursivePanel.$$$reportNull$$$0(3);
        }
        HashSet points = new HashSet();
        HashMap injectionPointOwners = ContainerUtil.newHashMap();
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesScope((Module)module);
        CdiJamModel model = CdiJamModel.getModel(module);
        for (CdiProduces produces : model.getProduces(scope)) {
            ProducerBeanDescriptor<? extends PsiMember> beanDescriptor;
            if (this.isShowProduces() && (beanDescriptor = CdiDescriptorsFactory.createProducerCdiBeanDescriptor(produces.getPsiElement())) != null) {
                points.add(beanDescriptor);
            }
            CdiBeansRecursivePanel.putIfNotNull(injectionPointOwners, produces.getPsiElement().getContainingClass());
        }
        if (this.isShowBeans()) {
            for (InjectionPointDescriptor ip : CdiInjectionUtils.getInjectionPoints(module, scope)) {
                PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)ip.getOwner(), PsiClass.class);
                if (psiClass != null) {
                    CdiBeansRecursivePanel.putIfNotNull(injectionPointOwners, psiClass);
                }
                for (CdiBeanDescriptor bean : CdiInjectionUtils.getInjectedBeans(ip)) {
                    if (!(bean instanceof AbstractCdiBeanDescriptor)) continue;
                    points.add((AbstractCdiBeanDescriptor)bean);
                }
            }
            for (CdiNamedBean namedBean : model.getNamedBeans(scope)) {
                if (!(namedBean instanceof CdiNamedBean.ClassMapping)) continue;
                CdiBeansRecursivePanel.putIfNotNull(injectionPointOwners, (PsiClass)((CdiNamedBean.ClassMapping)namedBean).getPsiElement());
            }
            for (PsiClass owner : injectionPointOwners.values()) {
                points.add(CdiDescriptorsFactory.createCdiBeanDescriptor(owner));
            }
        }
        HashSet hashSet = points;
        if (hashSet == null) {
            CdiBeansRecursivePanel.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    private static void putIfNotNull(@NotNull Map<String, PsiClass> injectionPointOwners, @Nullable PsiClass aClass) {
        if (injectionPointOwners == null) {
            CdiBeansRecursivePanel.$$$reportNull$$$0(5);
        }
        if (aClass != null) {
            ContainerUtil.putIfNotNull((Object)aClass.getQualifiedName(), (Object)aClass, injectionPointOwners);
        }
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            CdiBeansRecursivePanel.$$$reportNull$$$0(6);
        }
        AbstractCdiBeanDescriptor value = (AbstractCdiBeanDescriptor)this.getSelectedValue();
        if (CommonDataKeys.NAVIGATABLE.is(dataId) && value != null) {
            return value.getAnnotatedItem();
        }
        return super.getData(dataId);
    }

    public void dispose() {
        super.dispose();
        this.myActions.remove((AnAction)this.myShowBeansAction);
        this.myActions.remove((AnAction)this.myShowProducersAction);
        this.myActions.remove((AnAction)this.myShowInjectionPointsAction);
    }

    @NotNull
    protected List<AbstractCdiBeanDescriptor> getListItems() {
        ArrayList<AbstractCdiBeanDescriptor> points = new ArrayList<AbstractCdiBeanDescriptor>();
        if (this.myModule != null) {
            points.addAll(this.getListItems(this.myModule));
        } else {
            for (Module module : ModuleManager.getInstance((Project)this.getProject()).getModules()) {
                if (!CdiCommonUtils.isCdiInstalled(module)) continue;
                points.addAll(this.getListItems(module));
            }
        }
        Collections.sort(points, (o1, o2) -> {
            if (o1 instanceof ManagedBeanDescriptor && o2 instanceof ManagedBeanDescriptor) {
                String value1 = o1.getAnnotatedItem().getName();
                String value2 = o2.getAnnotatedItem().getName();
                if (value1 != null && value2 != null) {
                    return value1.compareTo(value2);
                }
                return 0;
            }
            if (o1 instanceof ProducerBeanDescriptor && o2 instanceof ProducerBeanDescriptor) {
                String value1 = o1.getAnnotatedItem().getName();
                String value2 = o2.getAnnotatedItem().getName();
                if (value1 != null && value2 != null) {
                    return value1.compareTo(value2);
                }
                return 0;
            }
            return o1 instanceof ManagedBeanDescriptor ? 1 : -1;
        });
        ArrayList<AbstractCdiBeanDescriptor> arrayList = points;
        if (arrayList == null) {
            CdiBeansRecursivePanel.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    protected boolean hasChildren(AbstractCdiBeanDescriptor beanDescriptor) {
        Object identifyingElement = beanDescriptor.getIdentifyingElement();
        if (identifyingElement.isValid()) {
            if (beanDescriptor instanceof ManagedBeanDescriptor) {
                return CdiInjectionUtils.getInjectionPoints(((ManagedBeanDescriptor)beanDescriptor).getAnnotatedItem()).size() > 0;
            }
            if (beanDescriptor instanceof MethodProducerBeanDescriptor) {
                return CdiInjectionUtils.getInjectionPoints(((MethodProducerBeanDescriptor)beanDescriptor).getAnnotatedItem()).size() > 0;
            }
        }
        return false;
    }

    public Module getModule() {
        return this.myModule;
    }

    public boolean isShowBeans() {
        CdiViewSettings viewSettings = CdiProjectComponent.getInstance(this.getProject()).getState();
        return viewSettings == null || viewSettings.showBeans;
    }

    public boolean isShowInjectionPoints() {
        CdiViewSettings viewSettings = CdiProjectComponent.getInstance(this.getProject()).getState();
        return viewSettings == null || viewSettings.showInjectionPoints;
    }

    public boolean isShowProduces() {
        CdiViewSettings viewSettings = CdiProjectComponent.getInstance(this.getProject()).getState();
        return viewSettings == null || viewSettings.showProducers;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/view/CdiBeansRecursivePanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectionPointOwners";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/view/CdiBeansRecursivePanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierAnnotations";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getListItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getListItems";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "putIfNotNull";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

