/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.EmptyRunnable;
import java.util.Collection;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenArtifactDownloader;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenProjectsProcessorArtifactsDownloadingTask
implements MavenProjectsProcessorTask {
    private final Collection<MavenProject> myProjects;
    private final Collection<MavenArtifact> myArtifacts;
    private final MavenProjectsTree myTree;
    private final boolean myDownloadSources;
    private final boolean myDownloadDocs;
    private final AsyncResult<? super MavenArtifactDownloader.DownloadResult> myCallbackResult;

    public MavenProjectsProcessorArtifactsDownloadingTask(Collection<MavenProject> projects, Collection<MavenArtifact> artifacts, MavenProjectsTree tree, boolean downloadSources, boolean downloadDocs, AsyncResult<? super MavenArtifactDownloader.DownloadResult> callbackResult) {
        this.myProjects = projects;
        this.myArtifacts = artifacts;
        this.myTree = tree;
        this.myDownloadSources = downloadSources;
        this.myDownloadDocs = downloadDocs;
        this.myCallbackResult = callbackResult;
    }

    @Override
    public void perform(Project project, MavenEmbeddersManager embeddersManager, MavenConsole console, MavenProgressIndicator indicator) throws MavenProcessCanceledException {
        MavenArtifactDownloader.DownloadResult result = this.myTree.downloadSourcesAndJavadocs(project, this.myProjects, this.myArtifacts, this.myDownloadSources, this.myDownloadDocs, embeddersManager, console, indicator);
        if (this.myCallbackResult != null) {
            this.myCallbackResult.setDone((Object)result);
        }
        MavenUtil.invokeLater(project, () -> WriteAction.run(() -> ProjectRootManagerEx.getInstanceEx((Project)project).makeRootsChange(EmptyRunnable.getInstance(), false, true)));
    }
}

