/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.actions;

import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.util.NullableConsumer;
import java.io.IOException;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.statistics.MavenActionsUsagesCollector;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.utils.actions.MavenActionUtil;

public class MavenShowEffectivePom
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(MavenShowEffectivePom.class);

    private static void showUnsupportedNotification(final @NotNull Project project) {
        if (project == null) {
            MavenShowEffectivePom.$$$reportNull$$$0(0);
        }
        new Notification("Maven", "Unsupported action", "<html>Maven3 required to use Show Effective POM action. \nPlease <a href='#'>select Maven3 home directory</a> or use \"Bundled (Maven 3)\"</html>", NotificationType.ERROR, (NotificationListener)new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                if (notification == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                notification.expire();
                ShowSettingsUtil.getInstance().showSettingsDialog(project, "Maven");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/idea/maven/project/actions/MavenShowEffectivePom$1";
                objectArray[2] = "hyperlinkActivated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).notify(project);
    }

    public static void actionPerformed(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            MavenShowEffectivePom.$$$reportNull$$$0(1);
        }
        if (file == null) {
            MavenShowEffectivePom.$$$reportNull$$$0(2);
        }
        MavenProjectsManager manager = MavenProjectsManager.getInstance(project);
        MavenProject mavenProject = manager.findProject(file);
        assert (mavenProject != null);
        manager.evaluateEffectivePom(mavenProject, (NullableConsumer<String>)((NullableConsumer)s -> {
            if (project == null) {
                MavenShowEffectivePom.$$$reportNull$$$0(6);
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (project == null) {
                    MavenShowEffectivePom.$$$reportNull$$$0(7);
                }
                if (project.isDisposed()) {
                    return;
                }
                if (s == null) {
                    new Notification("Maven", "Error", "Failed to evaluate effective pom.", NotificationType.ERROR).notify(project);
                    return;
                }
                String fileName = mavenProject.getMavenId().getArtifactId() + "-effective-pom.xml";
                PsiFile file1 = PsiFileFactory.getInstance((Project)project).createFileFromText(fileName, (Language)XMLLanguage.INSTANCE, (CharSequence)s);
                try {
                    file1.getVirtualFile().setWritable(false);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
                file1.navigate(true);
            });
        }));
    }

    @Nullable
    private static VirtualFile findPomXml(@NotNull DataContext dataContext) {
        VirtualFile file;
        if (dataContext == null) {
            MavenShowEffectivePom.$$$reportNull$$$0(3);
        }
        if ((file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext)) == null) {
            return null;
        }
        if (file.isDirectory() && (file = (VirtualFile)MavenUtil.streamPomFiles(MavenActionUtil.getProject(dataContext), file).findFirst().orElse(null)) == null) {
            return null;
        }
        MavenProjectsManager manager = MavenActionUtil.getProjectsManager(dataContext);
        if (manager == null) {
            return null;
        }
        MavenProject mavenProject = manager.findProject(file);
        if (mavenProject == null) {
            return null;
        }
        return file;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Project project;
        if (event == null) {
            MavenShowEffectivePom.$$$reportNull$$$0(4);
        }
        if ((project = MavenActionUtil.getProject(event.getDataContext())) == null) {
            return;
        }
        MavenActionsUsagesCollector.trigger(project, this, event, new String[0]);
        VirtualFile file = MavenShowEffectivePom.findPomXml(event.getDataContext());
        if (file == null) {
            return;
        }
        if (MavenServerManager.getInstance().isUseMaven2()) {
            MavenShowEffectivePom.showUnsupportedNotification(project);
        } else {
            MavenShowEffectivePom.actionPerformed(project, file);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            MavenShowEffectivePom.$$$reportNull$$$0(5);
        }
        Presentation p = e.getPresentation();
        boolean visible = MavenShowEffectivePom.findPomXml(e.getDataContext()) != null;
        p.setVisible(visible);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/project/actions/MavenShowEffectivePom";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "showUnsupportedNotification";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findPomXml";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$actionPerformed$1";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

