/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.heroku.agent.cloud;

import com.heroku.api.App;
import com.heroku.api.HerokuAPI;
import com.heroku.api.connection.Connection;
import com.heroku.api.connection.JerseyClientAsyncConnection;
import com.heroku.api.exception.HerokuAPIException;
import com.intellij.javaee.heroku.agent.HerokuApplicationImpl;
import com.intellij.javaee.heroku.agent.cloud.HerokuApiTaskProvider;
import com.intellij.javaee.heroku.agent.cloud.HerokuCloudAgent;
import com.intellij.javaee.heroku.agent.cloud.HerokuCloudAgentConfig;
import com.intellij.javaee.heroku.agent.cloud.HerokuCloudAgentDeployment;
import com.intellij.javaee.heroku.agent.cloud.HerokuCloudAgentDeploymentImpl;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import com.intellij.remoteServer.agent.util.CloudRemoteApplication;
import com.intellij.remoteServer.agent.util.log.LogAgentManager;
import java.util.ArrayList;
import java.util.List;

public class HerokuCloudAgentImpl
implements HerokuCloudAgent {
    private final LogAgentManager myLogManager = new LogAgentManager();
    private HerokuApiTaskProvider myTaskProvider;
    private CloudAgentLogger myLogger;
    private String myApiKey;
    private final List<HerokuCloudAgentDeploymentImpl> myCloudAgentDeployments = new ArrayList<HerokuCloudAgentDeploymentImpl>();

    public void connect(HerokuCloudAgentConfig config, CloudAgentErrorHandler errorHandler, CloudAgentLogger logger) {
        try {
            String apiKey;
            this.myLogger = logger;
            JerseyClientAsyncConnection connection = new JerseyClientAsyncConnection();
            this.myApiKey = apiKey = config.getApiKeySafe();
            HerokuAPI api = new HerokuAPI((Connection)connection, apiKey);
            api.listApps();
            this.myTaskProvider = new HerokuApiTaskProvider(api, errorHandler, logger);
        }
        catch (HerokuAPIException e) {
            errorHandler.onError(e.toString());
        }
    }

    public HerokuCloudAgentDeployment createDeployment(String deploymentName, CloudAgentLoggingHandler loggingHandler) {
        HerokuCloudAgentDeploymentImpl agentDeployment = new HerokuCloudAgentDeploymentImpl(this.myTaskProvider, deploymentName, loggingHandler, this.myLogManager, this.myLogger, this.myApiKey);
        this.myCloudAgentDeployments.add(agentDeployment);
        return agentDeployment;
    }

    public void disconnect() {
        this.myLogManager.stopListeningAllLogs();
        this.stopAllDebugProcess();
    }

    public void stopAllDebugProcess() {
        new HerokuApiTaskProvider.ApiTask(this.myTaskProvider){

            protected Object doPerform(HerokuAPI api) throws HerokuAPIException {
                for (HerokuCloudAgentDeploymentImpl agentDeployment : HerokuCloudAgentImpl.this.myCloudAgentDeployments) {
                    agentDeployment.detachDebugRemote();
                }
                return null;
            }
        }.perform();
    }

    public CloudRemoteApplication[] getApplications() {
        return (CloudRemoteApplication[])new HerokuApiTaskProvider.ApiTask<CloudRemoteApplication[]>(this.myTaskProvider){

            @Override
            protected CloudRemoteApplication[] doPerform(HerokuAPI api) throws HerokuAPIException {
                ArrayList<HerokuApplicationImpl> result = new ArrayList<HerokuApplicationImpl>();
                for (App app : api.listApps()) {
                    result.add(new HerokuApplicationImpl(app));
                }
                return result.toArray(new CloudRemoteApplication[0]);
            }
        }.perform();
    }

    private boolean isDeploymentMaintenance(final String deploymentName) {
        HerokuApiTaskProvider herokuApiTaskProvider = this.myTaskProvider;
        herokuApiTaskProvider.getClass();
        Boolean result = (Boolean)new HerokuApiTaskProvider.ApiSilentTask<Boolean>(herokuApiTaskProvider){

            @Override
            protected Boolean doPerform(HerokuAPI api) throws HerokuAPIException {
                return api.isMaintenanceModeEnabled(deploymentName);
            }
        }.perform();
        return result == null ? false : result;
    }

    public void addSshKey(final String sshKey) {
        HerokuApiTaskProvider herokuApiTaskProvider = this.myTaskProvider;
        herokuApiTaskProvider.getClass();
        new HerokuApiTaskProvider.ApiTask(herokuApiTaskProvider){

            protected Object doPerform(HerokuAPI api) throws HerokuAPIException {
                api.addKey(sshKey);
                return null;
            }
        }.perform();
    }
}

