/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.util.containers.WeakList;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.util.List;
import javax.swing.SwingUtilities;

public class WeakFocusStackManager {
    private final WeakList<Component> focusOwners = new WeakList();
    private static final WeakFocusStackManager instance = new WeakFocusStackManager();

    public Component getLastFocusedOutside(Container container) {
        Component[] components = this.focusOwners.toStrongList().toArray(new Component[0]);
        for (int i = components.length - 1; i >= 0; --i) {
            if (SwingUtilities.isDescendingFrom(components[i], container)) continue;
            return components[i];
        }
        return null;
    }

    public static WeakFocusStackManager getInstance() {
        return instance;
    }

    private WeakFocusStackManager() {
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                if (event.getID() == 1004) {
                    WeakFocusStackManager.this.focusOwners.add((Object)((Component)event.getSource()));
                }
            }
        }, 4L);
    }

    public Component getLastFocusedComponent() {
        List strongList = this.focusOwners.toStrongList();
        return strongList.isEmpty() ? null : (Component)strongList.get(strongList.size() - 1);
    }

    public Component getLastButOneFocusedComponent() {
        List strongList = this.focusOwners.toStrongList();
        return strongList.size() < 2 ? null : (Component)strongList.get(strongList.size() - 2);
    }
}

